/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.core.AxisInformation;
import com.prosysopc.ua.types.opcua.YArrayItemType;
import com.prosysopc.ua.types.opcua.server.ArrayItemTypeNode;
import com.prosysopc.ua.types.opcua.server.YArrayItemTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=12029")
public abstract class YArrayItemTypeNodeBase
extends ArrayItemTypeNode
implements YArrayItemType {
    private static GeneratedNodeInitializer<YArrayItemTypeNode> Qa;

    protected YArrayItemTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<YArrayItemTypeNode> generatedNodeInitializer = YArrayItemTypeNodeBase.getYArrayItemTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((YArrayItemTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<YArrayItemTypeNode> getYArrayItemTypeNodeInitializer() {
        return Qa;
    }

    public static void setYArrayItemTypeNodeInitializer(GeneratedNodeInitializer<YArrayItemTypeNode> generatedNodeInitializer) {
        Qa = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getXAxisDefinitionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "XAxisDefinition");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public AxisInformation getXAxisDefinition() {
        UaProperty uaProperty = this.getXAxisDefinitionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node XAxisDefinition does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (AxisInformation)object;
    }

    @Override
    @Mandatory
    public void setXAxisDefinition(AxisInformation axisInformation) {
        UaProperty uaProperty = this.getXAxisDefinitionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting XAxisDefinition failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(axisInformation);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting XAxisDefinition failed unexpectedly", statusException);
        }
    }
}

