/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.DataSetWriterDataType;
import com.prosysopc.ua.types.opcua.WriterGroupType;
import com.prosysopc.ua.types.opcua.server.PubSubDiagnosticsWriterGroupTypeNode;
import com.prosysopc.ua.types.opcua.server.PubSubGroupTypeNode;
import com.prosysopc.ua.types.opcua.server.WriterGroupMessageTypeNode;
import com.prosysopc.ua.types.opcua.server.WriterGroupTransportTypeNode;
import com.prosysopc.ua.types.opcua.server.WriterGroupTypeAddDataSetWriterMethod;
import com.prosysopc.ua.types.opcua.server.WriterGroupTypeNode;
import com.prosysopc.ua.types.opcua.server.WriterGroupTypeRemoveDataSetWriterMethod;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=17725")
public abstract class WriterGroupTypeNodeBase
extends PubSubGroupTypeNode
implements WriterGroupType {
    private static GeneratedNodeInitializer<WriterGroupTypeNode> PW;
    private static WriterGroupTypeRemoveDataSetWriterMethod PX;
    private static WriterGroupTypeAddDataSetWriterMethod PY;

    protected WriterGroupTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getTransportSettingsNode());
        this.callAfterCreateIfExists(this.getDiagnosticsNode());
        this.callAfterCreateIfExists(this.getMessageSettingsNode());
        GeneratedNodeInitializer<WriterGroupTypeNode> generatedNodeInitializer = WriterGroupTypeNodeBase.getWriterGroupTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((WriterGroupTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<WriterGroupTypeNode> getWriterGroupTypeNodeInitializer() {
        return PW;
    }

    public static void setWriterGroupTypeNodeInitializer(GeneratedNodeInitializer<WriterGroupTypeNode> generatedNodeInitializer) {
        PW = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getWriterGroupIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "WriterGroupId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getWriterGroupId() {
        UaProperty uaProperty = this.getWriterGroupIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node WriterGroupId does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setWriterGroupId(UnsignedShort unsignedShort) {
        UaProperty uaProperty = this.getWriterGroupIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting WriterGroupId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedShort);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting WriterGroupId failed unexpectedly", statusException);
        }
    }

    public void setWriterGroupId(int n2) {
        this.setWriterGroupId(UnsignedShort.valueOf(n2));
    }

    @Override
    @Mandatory
    public UaProperty getLocaleIdsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LocaleIds");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String[] getLocaleIds() {
        UaProperty uaProperty = this.getLocaleIdsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node LocaleIds does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String[])object;
    }

    @Override
    @Mandatory
    public void setLocaleIds(String[] stringArray) {
        UaProperty uaProperty = this.getLocaleIdsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting LocaleIds failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(stringArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting LocaleIds failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getHeaderLayoutUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "HeaderLayoutUri");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getHeaderLayoutUri() {
        UaProperty uaProperty = this.getHeaderLayoutUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node HeaderLayoutUri does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setHeaderLayoutUri(String string) {
        UaProperty uaProperty = this.getHeaderLayoutUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting HeaderLayoutUri failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting HeaderLayoutUri failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getKeepAliveTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "KeepAliveTime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getKeepAliveTime() {
        UaProperty uaProperty = this.getKeepAliveTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node KeepAliveTime does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setKeepAliveTime(Double d2) {
        UaProperty uaProperty = this.getKeepAliveTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting KeepAliveTime failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting KeepAliveTime failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getPriorityNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Priority");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedByte getPriority() {
        UaProperty uaProperty = this.getPriorityNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node Priority does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedByte)object;
    }

    @Override
    @Mandatory
    public void setPriority(UnsignedByte unsignedByte) {
        UaProperty uaProperty = this.getPriorityNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Priority failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedByte);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Priority failed unexpectedly", statusException);
        }
    }

    public void setPriority(int n2) {
        this.setPriority(UnsignedByte.valueOf(n2));
    }

    @Override
    @Mandatory
    public UaProperty getPublishingIntervalNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "PublishingInterval");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getPublishingInterval() {
        UaProperty uaProperty = this.getPublishingIntervalNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node PublishingInterval does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setPublishingInterval(Double d2) {
        UaProperty uaProperty = this.getPublishingIntervalNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting PublishingInterval failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting PublishingInterval failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public WriterGroupTransportTypeNode getTransportSettingsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TransportSettings");
        return (WriterGroupTransportTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public PubSubDiagnosticsWriterGroupTypeNode getDiagnosticsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Diagnostics");
        return (PubSubDiagnosticsWriterGroupTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public WriterGroupMessageTypeNode getMessageSettingsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MessageSettings");
        return (WriterGroupMessageTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveDataSetWriter"), nodeId)) {
            this.r(serviceContext, (NodeId)variantArray[0].getValue());
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "AddDataSetWriter"), nodeId)) {
            return new Variant[]{new Variant(this.a(serviceContext, (DataSetWriterDataType)variantArray[0].getValue()))};
        }
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    @Optional
    public UaMethod getRemoveDataSetWriterNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveDataSetWriter");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onRemoveDataSetWriter(ServiceContext var1, NodeId var2) throws StatusException;

    @Override
    public void removeDataSetWriter(NodeId nodeId) throws StatusException {
        this.r(ServiceContext.INTERNAL_OPERATION_CONTEXT, nodeId);
    }

    private void r(ServiceContext serviceContext, NodeId nodeId) throws StatusException {
        WriterGroupTypeRemoveDataSetWriterMethod writerGroupTypeRemoveDataSetWriterMethod = WriterGroupTypeNodeBase.getRemoveDataSetWriterMethodImplementation();
        if (writerGroupTypeRemoveDataSetWriterMethod != null) {
            writerGroupTypeRemoveDataSetWriterMethod.removeDataSetWriter(serviceContext, (WriterGroupTypeNode)this, nodeId);
        } else {
            this.onRemoveDataSetWriter(serviceContext, nodeId);
        }
    }

    public static WriterGroupTypeRemoveDataSetWriterMethod getRemoveDataSetWriterMethodImplementation() {
        return PX;
    }

    public static void setRemoveDataSetWriterMethodImplementation(WriterGroupTypeRemoveDataSetWriterMethod writerGroupTypeRemoveDataSetWriterMethod) {
        PX = writerGroupTypeRemoveDataSetWriterMethod;
    }

    @Override
    @Optional
    public UaMethod getAddDataSetWriterNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AddDataSetWriter");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract NodeId onAddDataSetWriter(ServiceContext var1, DataSetWriterDataType var2) throws StatusException;

    @Override
    public NodeId addDataSetWriter(DataSetWriterDataType dataSetWriterDataType) throws StatusException {
        return this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, dataSetWriterDataType);
    }

    private NodeId a(ServiceContext serviceContext, DataSetWriterDataType dataSetWriterDataType) throws StatusException {
        WriterGroupTypeAddDataSetWriterMethod writerGroupTypeAddDataSetWriterMethod = WriterGroupTypeNodeBase.getAddDataSetWriterMethodImplementation();
        if (writerGroupTypeAddDataSetWriterMethod != null) {
            return writerGroupTypeAddDataSetWriterMethod.addDataSetWriter(serviceContext, (WriterGroupTypeNode)this, dataSetWriterDataType);
        }
        return this.onAddDataSetWriter(serviceContext, dataSetWriterDataType);
    }

    public static WriterGroupTypeAddDataSetWriterMethod getAddDataSetWriterMethodImplementation() {
        return PY;
    }

    public static void setAddDataSetWriterMethodImplementation(WriterGroupTypeAddDataSetWriterMethod writerGroupTypeAddDataSetWriterMethod) {
        PY = writerGroupTypeAddDataSetWriterMethod;
    }
}

