/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.core.EUInformation;
import com.prosysopc.ua.types.opcua.VectorType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.VectorTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=17714")
public abstract class VectorTypeNodeBase
extends BaseDataVariableTypeNode
implements VectorType {
    private static GeneratedNodeInitializer<VectorTypeNode> PS;

    protected VectorTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<VectorTypeNode> generatedNodeInitializer = VectorTypeNodeBase.getVectorTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((VectorTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<VectorTypeNode> getVectorTypeNodeInitializer() {
        return PS;
    }

    public static void setVectorTypeNodeInitializer(GeneratedNodeInitializer<VectorTypeNode> generatedNodeInitializer) {
        PS = generatedNodeInitializer;
    }

    @Override
    @Optional
    public UaProperty getVectorUnitNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "VectorUnit");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public EUInformation getVectorUnit() {
        UaProperty uaProperty = this.getVectorUnitNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (EUInformation)object;
    }

    @Override
    @Optional
    public void setVectorUnit(EUInformation eUInformation) {
        UaProperty uaProperty = this.getVectorUnitNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting VectorUnit failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(eUInformation);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting VectorUnit failed unexpectedly", statusException);
        }
    }
}

