/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.OptionSetUtils;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.PasswordOptionsMask;
import com.prosysopc.ua.stack.core.Range;
import com.prosysopc.ua.stack.core.UserConfigurationMask;
import com.prosysopc.ua.stack.core.UserManagementDataType;
import com.prosysopc.ua.types.opcua.UserManagementType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.UserManagementTypeAddUserMethod;
import com.prosysopc.ua.types.opcua.server.UserManagementTypeChangePasswordMethod;
import com.prosysopc.ua.types.opcua.server.UserManagementTypeModifyUserMethod;
import com.prosysopc.ua.types.opcua.server.UserManagementTypeNode;
import com.prosysopc.ua.types.opcua.server.UserManagementTypeRemoveUserMethod;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=24264")
public abstract class UserManagementTypeNodeBase
extends BaseObjectTypeNode
implements UserManagementType {
    private static GeneratedNodeInitializer<UserManagementTypeNode> PM;
    private static UserManagementTypeModifyUserMethod PN;
    private static UserManagementTypeRemoveUserMethod PO;
    private static UserManagementTypeChangePasswordMethod PP;
    private static UserManagementTypeAddUserMethod PQ;

    protected UserManagementTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<UserManagementTypeNode> generatedNodeInitializer = UserManagementTypeNodeBase.getUserManagementTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((UserManagementTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<UserManagementTypeNode> getUserManagementTypeNodeInitializer() {
        return PM;
    }

    public static void setUserManagementTypeNodeInitializer(GeneratedNodeInitializer<UserManagementTypeNode> generatedNodeInitializer) {
        PM = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getPasswordOptionsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "PasswordOptions");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public PasswordOptionsMask getPasswordOptions() {
        UaProperty uaProperty = this.getPasswordOptionsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node PasswordOptions does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (PasswordOptionsMask)object;
    }

    @Override
    @Mandatory
    public void setPasswordOptions(PasswordOptionsMask passwordOptionsMask) {
        UaProperty uaProperty = this.getPasswordOptionsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting PasswordOptions failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(passwordOptionsMask);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting PasswordOptions failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getPasswordRestrictionsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "PasswordRestrictions");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public LocalizedText getPasswordRestrictions() {
        UaProperty uaProperty = this.getPasswordRestrictionsNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Optional
    public void setPasswordRestrictions(LocalizedText localizedText) {
        UaProperty uaProperty = this.getPasswordRestrictionsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting PasswordRestrictions failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(localizedText);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting PasswordRestrictions failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getUsersNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Users");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UserManagementDataType[] getUsers() {
        UaProperty uaProperty = this.getUsersNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node Users does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UserManagementDataType[])object;
    }

    @Override
    @Mandatory
    public void setUsers(UserManagementDataType[] userManagementDataTypeArray) {
        UaProperty uaProperty = this.getUsersNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Users failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(userManagementDataTypeArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Users failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getPasswordLengthNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "PasswordLength");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Range getPasswordLength() {
        UaProperty uaProperty = this.getPasswordLengthNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node PasswordLength does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Range)object;
    }

    @Override
    @Mandatory
    public void setPasswordLength(Range range) {
        UaProperty uaProperty = this.getPasswordLengthNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting PasswordLength failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(range);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting PasswordLength failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "ModifyUser"), nodeId)) {
            this.a(serviceContext, (String)variantArray[0].getValue(), (Boolean)variantArray[1].getValue(), (String)variantArray[2].getValue(), (Boolean)variantArray[3].getValue(), (UserConfigurationMask)OptionSetUtils.convert(variantArray[4], UnsignedInteger.class, UserConfigurationMask.class, new OptionSetUtils.Factory<UnsignedInteger, UserConfigurationMask>(){

                public UserConfigurationMask m(UnsignedInteger unsignedInteger) {
                    return UserConfigurationMask.of(unsignedInteger);
                }

                @Override
                public /* synthetic */ Object create(Object object) throws StatusException {
                    return this.m((UnsignedInteger)object);
                }
            }), (Boolean)variantArray[5].getValue(), (String)variantArray[6].getValue());
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveUser"), nodeId)) {
            this.j(serviceContext, (String)variantArray[0].getValue());
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "ChangePassword"), nodeId)) {
            this.d(serviceContext, (String)variantArray[0].getValue(), (String)variantArray[1].getValue());
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "AddUser"), nodeId)) {
            this.a(serviceContext, (String)variantArray[0].getValue(), (String)variantArray[1].getValue(), (UserConfigurationMask)OptionSetUtils.convert(variantArray[2], UnsignedInteger.class, UserConfigurationMask.class, new OptionSetUtils.Factory<UnsignedInteger, UserConfigurationMask>(){

                public UserConfigurationMask m(UnsignedInteger unsignedInteger) {
                    return UserConfigurationMask.of(unsignedInteger);
                }

                @Override
                public /* synthetic */ Object create(Object object) throws StatusException {
                    return this.m((UnsignedInteger)object);
                }
            }), (String)variantArray[3].getValue());
            return null;
        }
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    @Mandatory
    public UaMethod getModifyUserNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ModifyUser");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onModifyUser(ServiceContext var1, String var2, Boolean var3, String var4, Boolean var5, UserConfigurationMask var6, Boolean var7, String var8) throws StatusException;

    @Override
    public void modifyUser(String string, Boolean bl, String string2, Boolean bl2, UserConfigurationMask userConfigurationMask, Boolean bl3, String string3) throws StatusException {
        this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, string, bl, string2, bl2, userConfigurationMask, bl3, string3);
    }

    private void a(ServiceContext serviceContext, String string, Boolean bl, String string2, Boolean bl2, UserConfigurationMask userConfigurationMask, Boolean bl3, String string3) throws StatusException {
        UserManagementTypeModifyUserMethod userManagementTypeModifyUserMethod = UserManagementTypeNodeBase.getModifyUserMethodImplementation();
        if (userManagementTypeModifyUserMethod != null) {
            userManagementTypeModifyUserMethod.modifyUser(serviceContext, (UserManagementTypeNode)this, string, bl, string2, bl2, userConfigurationMask, bl3, string3);
        } else {
            this.onModifyUser(serviceContext, string, bl, string2, bl2, userConfigurationMask, bl3, string3);
        }
    }

    public static UserManagementTypeModifyUserMethod getModifyUserMethodImplementation() {
        return PN;
    }

    public static void setModifyUserMethodImplementation(UserManagementTypeModifyUserMethod userManagementTypeModifyUserMethod) {
        PN = userManagementTypeModifyUserMethod;
    }

    @Override
    @Mandatory
    public UaMethod getRemoveUserNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveUser");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onRemoveUser(ServiceContext var1, String var2) throws StatusException;

    @Override
    public void removeUser(String string) throws StatusException {
        this.j(ServiceContext.INTERNAL_OPERATION_CONTEXT, string);
    }

    private void j(ServiceContext serviceContext, String string) throws StatusException {
        UserManagementTypeRemoveUserMethod userManagementTypeRemoveUserMethod = UserManagementTypeNodeBase.getRemoveUserMethodImplementation();
        if (userManagementTypeRemoveUserMethod != null) {
            userManagementTypeRemoveUserMethod.removeUser(serviceContext, (UserManagementTypeNode)this, string);
        } else {
            this.onRemoveUser(serviceContext, string);
        }
    }

    public static UserManagementTypeRemoveUserMethod getRemoveUserMethodImplementation() {
        return PO;
    }

    public static void setRemoveUserMethodImplementation(UserManagementTypeRemoveUserMethod userManagementTypeRemoveUserMethod) {
        PO = userManagementTypeRemoveUserMethod;
    }

    @Override
    @Mandatory
    public UaMethod getChangePasswordNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ChangePassword");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onChangePassword(ServiceContext var1, String var2, String var3) throws StatusException;

    @Override
    public void changePassword(String string, String string2) throws StatusException {
        this.d(ServiceContext.INTERNAL_OPERATION_CONTEXT, string, string2);
    }

    private void d(ServiceContext serviceContext, String string, String string2) throws StatusException {
        UserManagementTypeChangePasswordMethod userManagementTypeChangePasswordMethod = UserManagementTypeNodeBase.getChangePasswordMethodImplementation();
        if (userManagementTypeChangePasswordMethod != null) {
            userManagementTypeChangePasswordMethod.changePassword(serviceContext, (UserManagementTypeNode)this, string, string2);
        } else {
            this.onChangePassword(serviceContext, string, string2);
        }
    }

    public static UserManagementTypeChangePasswordMethod getChangePasswordMethodImplementation() {
        return PP;
    }

    public static void setChangePasswordMethodImplementation(UserManagementTypeChangePasswordMethod userManagementTypeChangePasswordMethod) {
        PP = userManagementTypeChangePasswordMethod;
    }

    @Override
    @Mandatory
    public UaMethod getAddUserNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AddUser");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onAddUser(ServiceContext var1, String var2, String var3, UserConfigurationMask var4, String var5) throws StatusException;

    @Override
    public void addUser(String string, String string2, UserConfigurationMask userConfigurationMask, String string3) throws StatusException {
        this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, string, string2, userConfigurationMask, string3);
    }

    private void a(ServiceContext serviceContext, String string, String string2, UserConfigurationMask userConfigurationMask, String string3) throws StatusException {
        UserManagementTypeAddUserMethod userManagementTypeAddUserMethod = UserManagementTypeNodeBase.getAddUserMethodImplementation();
        if (userManagementTypeAddUserMethod != null) {
            userManagementTypeAddUserMethod.addUser(serviceContext, (UserManagementTypeNode)this, string, string2, userConfigurationMask, string3);
        } else {
            this.onAddUser(serviceContext, string, string2, userConfigurationMask, string3);
        }
    }

    public static UserManagementTypeAddUserMethod getAddUserMethodImplementation() {
        return PQ;
    }

    public static void setAddUserMethodImplementation(UserManagementTypeAddUserMethod userManagementTypeAddUserMethod) {
        PQ = userManagementTypeAddUserMethod;
    }
}

