/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.nodes.CacheProperty;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.types.opcua.server.TwoStateVariableTypeNodeBase;
import java.util.Locale;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=8995")
public class TwoStateVariableTypeNode
extends TwoStateVariableTypeNodeBase {
    protected TwoStateVariableTypeNode(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        CacheProperty cacheProperty;
        NodeId nodeId;
        super.afterCreate();
        this.setValueRank(-1);
        this.setId(false);
        if (this.getTrueStateNode() == null) {
            nodeId = this.getNodeManager().createNodeId((UaNode)this, new QualifiedName("TrueState"));
            cacheProperty = new CacheProperty(this.getNodeManager(), nodeId, new QualifiedName("TrueState"), new LocalizedText("TrueState"));
            cacheProperty.setDataTypeId(Identifiers.LocalizedText);
            cacheProperty.setValueRank(-1);
            this.addProperty(cacheProperty);
        }
        if (this.getFalseStateNode() == null) {
            nodeId = this.getNodeManager().createNodeId((UaNode)this, new QualifiedName("FalseState"));
            cacheProperty = new CacheProperty(this.getNodeManager(), nodeId, new QualifiedName("FalseState"), new LocalizedText("FalseState"));
            cacheProperty.setDataTypeId(Identifiers.LocalizedText);
            cacheProperty.setValueRank(-1);
            this.addProperty(cacheProperty);
        }
    }

    public void setFalseState(String string, Locale locale) {
        this.setFalseState(new LocalizedText(string, locale));
    }

    public void setId(boolean bl, DateTime dateTime) {
        if (bl != this.isId() || this.getValue() != null && this.getValue().getStatusCode().isBad()) {
            super.setId(bl);
            this.setIdWithTime(bl, dateTime);
        }
    }

    @Override
    public void setId(Boolean bl) {
        super.setId(bl);
        this.setIdWithTime(bl, null);
    }

    public void setTrueState(String string, Locale locale) {
        this.setTrueState(new LocalizedText(string, locale));
    }

    protected void setIdWithTime(Boolean bl, DateTime dateTime) {
        if (dateTime == null) {
            dateTime = DateTime.currentTime();
        }
        try {
            DataValue dataValue = bl == null ? new DataValue(StatusCode.valueOf(StatusCodes.Bad_AttributeIdInvalid)) : new DataValue(new Variant(bl != false ? this.getTrueState() : this.getFalseState()));
            dataValue.setSourceTimestamp(dateTime);
            this.setValue(dataValue);
            if (this.getTransitionTimeNode() != null) {
                this.setTransitionTime(dateTime);
            }
            if (this.getEffectiveTransitionTimeNode() != null) {
                this.setEffectiveTransitionTime(dateTime);
            }
        }
        catch (StatusException statusException) {
            throw new RuntimeException("setId: " + bl, statusException);
        }
    }
}

