/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.TransitionEventType;
import com.prosysopc.ua.types.opcua.server.BaseEventTypeNode;
import com.prosysopc.ua.types.opcua.server.StateVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.TransitionEventTypeNode;
import com.prosysopc.ua.types.opcua.server.TransitionVariableTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2311")
public abstract class TransitionEventTypeNodeBase
extends BaseEventTypeNode
implements TransitionEventType {
    private static GeneratedNodeInitializer<TransitionEventTypeNode> Pr;

    protected TransitionEventTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getToStateNode());
        this.callAfterCreateIfExists(this.getTransitionNode());
        this.callAfterCreateIfExists(this.getFromStateNode());
        GeneratedNodeInitializer<TransitionEventTypeNode> generatedNodeInitializer = TransitionEventTypeNodeBase.getTransitionEventTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((TransitionEventTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<TransitionEventTypeNode> getTransitionEventTypeNodeInitializer() {
        return Pr;
    }

    public static void setTransitionEventTypeNodeInitializer(GeneratedNodeInitializer<TransitionEventTypeNode> generatedNodeInitializer) {
        Pr = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public StateVariableTypeNode getToStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ToState");
        return (StateVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getToState() {
        StateVariableTypeNode stateVariableTypeNode = this.getToStateNode();
        if (stateVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node ToState does not exist");
        }
        Object object = stateVariableTypeNode.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setToState(LocalizedText localizedText) {
        StateVariableTypeNode stateVariableTypeNode = this.getToStateNode();
        if (stateVariableTypeNode == null) {
            throw new RuntimeException("Setting ToState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            stateVariableTypeNode.setValue(localizedText);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ToState failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public TransitionVariableTypeNode getTransitionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Transition");
        return (TransitionVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getTransition() {
        TransitionVariableTypeNode transitionVariableTypeNode = this.getTransitionNode();
        if (transitionVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node Transition does not exist");
        }
        Object object = transitionVariableTypeNode.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setTransition(LocalizedText localizedText) {
        TransitionVariableTypeNode transitionVariableTypeNode = this.getTransitionNode();
        if (transitionVariableTypeNode == null) {
            throw new RuntimeException("Setting Transition failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            transitionVariableTypeNode.setValue(localizedText);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Transition failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public StateVariableTypeNode getFromStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "FromState");
        return (StateVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getFromState() {
        StateVariableTypeNode stateVariableTypeNode = this.getFromStateNode();
        if (stateVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node FromState does not exist");
        }
        Object object = stateVariableTypeNode.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setFromState(LocalizedText localizedText) {
        StateVariableTypeNode stateVariableTypeNode = this.getFromStateNode();
        if (stateVariableTypeNode == null) {
            throw new RuntimeException("Setting FromState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            stateVariableTypeNode.setValue(localizedText);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting FromState failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

