/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.TransactionErrorType;
import com.prosysopc.ua.types.opcua.TransactionDiagnosticsType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.TransactionDiagnosticsTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=32286")
public abstract class TransactionDiagnosticsTypeNodeBase
extends BaseObjectTypeNode
implements TransactionDiagnosticsType {
    private static GeneratedNodeInitializer<TransactionDiagnosticsTypeNode> Pq;

    protected TransactionDiagnosticsTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<TransactionDiagnosticsTypeNode> generatedNodeInitializer = TransactionDiagnosticsTypeNodeBase.getTransactionDiagnosticsTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((TransactionDiagnosticsTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<TransactionDiagnosticsTypeNode> getTransactionDiagnosticsTypeNodeInitializer() {
        return Pq;
    }

    public static void setTransactionDiagnosticsTypeNodeInitializer(GeneratedNodeInitializer<TransactionDiagnosticsTypeNode> generatedNodeInitializer) {
        Pq = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getStartTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "StartTime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getStartTime() {
        UaProperty uaProperty = this.getStartTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node StartTime does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setStartTime(DateTime dateTime) {
        UaProperty uaProperty = this.getStartTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting StartTime failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(dateTime);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting StartTime failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getAffectedCertificateGroupsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AffectedCertificateGroups");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId[] getAffectedCertificateGroups() {
        UaProperty uaProperty = this.getAffectedCertificateGroupsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node AffectedCertificateGroups does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId[])object;
    }

    @Override
    @Mandatory
    public void setAffectedCertificateGroups(NodeId[] nodeIdArray) {
        UaProperty uaProperty = this.getAffectedCertificateGroupsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting AffectedCertificateGroups failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(nodeIdArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting AffectedCertificateGroups failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getEndTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EndTime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getEndTime() {
        UaProperty uaProperty = this.getEndTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node EndTime does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setEndTime(DateTime dateTime) {
        UaProperty uaProperty = this.getEndTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EndTime failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(dateTime);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting EndTime failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getAffectedTrustListsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AffectedTrustLists");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId[] getAffectedTrustLists() {
        UaProperty uaProperty = this.getAffectedTrustListsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node AffectedTrustLists does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId[])object;
    }

    @Override
    @Mandatory
    public void setAffectedTrustLists(NodeId[] nodeIdArray) {
        UaProperty uaProperty = this.getAffectedTrustListsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting AffectedTrustLists failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(nodeIdArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting AffectedTrustLists failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getResultNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Result");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public StatusCode getResult() {
        UaProperty uaProperty = this.getResultNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node Result does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (StatusCode)object;
    }

    @Override
    @Mandatory
    public void setResult(StatusCode statusCode) {
        UaProperty uaProperty = this.getResultNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Result failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(statusCode);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Result failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getErrorsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Errors");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public TransactionErrorType[] getErrors() {
        UaProperty uaProperty = this.getErrorsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node Errors does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (TransactionErrorType[])object;
    }

    @Override
    @Mandatory
    public void setErrors(TransactionErrorType[] transactionErrorTypeArray) {
        UaProperty uaProperty = this.getErrorsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Errors failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(transactionErrorTypeArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Errors failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

