/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.types.opcua.ThreeDOrientationType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.OrientationTypeNode;
import com.prosysopc.ua.types.opcua.server.ThreeDOrientationTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=18781")
public abstract class ThreeDOrientationTypeNodeBase
extends OrientationTypeNode
implements ThreeDOrientationType {
    private static GeneratedNodeInitializer<ThreeDOrientationTypeNode> Pn;

    protected ThreeDOrientationTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getCNode());
        this.callAfterCreateIfExists(this.getANode());
        this.callAfterCreateIfExists(this.getBNode());
        GeneratedNodeInitializer<ThreeDOrientationTypeNode> generatedNodeInitializer = ThreeDOrientationTypeNodeBase.getThreeDOrientationTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((ThreeDOrientationTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<ThreeDOrientationTypeNode> getThreeDOrientationTypeNodeInitializer() {
        return Pn;
    }

    public static void setThreeDOrientationTypeNodeInitializer(GeneratedNodeInitializer<ThreeDOrientationTypeNode> generatedNodeInitializer) {
        Pn = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getCNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "C");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getC() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getCNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node C does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setC(Double d2) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getCNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting C failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting C failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getANode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "A");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getA() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getANode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node A does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setA(Double d2) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getANode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting A failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting A failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getBNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "B");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getB() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getBNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node B does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setB(Double d2) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getBNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting B failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting B failed unexpectedly", statusException);
        }
    }
}

