/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.ServerState;
import com.prosysopc.ua.types.opcua.SystemStatusChangeEventType;
import com.prosysopc.ua.types.opcua.server.SystemEventTypeNode;
import com.prosysopc.ua.types.opcua.server.SystemStatusChangeEventTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=11446")
public abstract class SystemStatusChangeEventTypeNodeBase
extends SystemEventTypeNode
implements SystemStatusChangeEventType {
    private static GeneratedNodeInitializer<SystemStatusChangeEventTypeNode> Pc;

    protected SystemStatusChangeEventTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<SystemStatusChangeEventTypeNode> generatedNodeInitializer = SystemStatusChangeEventTypeNodeBase.getSystemStatusChangeEventTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((SystemStatusChangeEventTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<SystemStatusChangeEventTypeNode> getSystemStatusChangeEventTypeNodeInitializer() {
        return Pc;
    }

    public static void setSystemStatusChangeEventTypeNodeInitializer(GeneratedNodeInitializer<SystemStatusChangeEventTypeNode> generatedNodeInitializer) {
        Pc = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getSystemStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SystemState");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public ServerState getSystemState() {
        UaProperty uaProperty = this.getSystemStateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node SystemState does not exist");
        }
        Variant variant = uaProperty.getValue().getValue();
        return (ServerState)variant.asEnum(ServerState.class);
    }

    @Override
    @Mandatory
    public void setSystemState(ServerState serverState) {
        UaProperty uaProperty = this.getSystemStateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SystemState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(serverState);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SystemState failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

