/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.types.opcua.server.AlarmConditionTypeNode;
import com.prosysopc.ua.types.opcua.server.ShelvedStateMachineTypeNodeBase;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2929")
public class ShelvedStateMachineTypeNode
extends ShelvedStateMachineTypeNodeBase {
    private static final Logger logger = LoggerFactory.getLogger(ShelvedStateMachineTypeNode.class);
    private AlarmConditionTypeNode Ow;
    private boolean Ox;
    private long Oy;
    private Timer Oz;

    protected ShelvedStateMachineTypeNode(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.getCurrentStateNode().setId(Identifiers.ShelvedStateMachineType_Unshelved);
    }

    public AlarmConditionTypeNode getCondition() {
        return this.Ow;
    }

    @Override
    public Double getUnshelveTime() {
        long l2 = this.Oy - System.currentTimeMillis();
        return l2 > 0L ? (double)l2 : 0.0;
    }

    public boolean isOneshotShelved() {
        return NodeId.equals(this.getCurrentStateNode().getId(), Identifiers.ShelvedStateMachineType_OneShotShelved);
    }

    public boolean isShelved() {
        return !NodeId.equals(this.getCurrentStateNode().getId(), Identifiers.ShelvedStateMachineType_Unshelved);
    }

    public void setCondition(AlarmConditionTypeNode alarmConditionTypeNode) {
        this.Ow = alarmConditionTypeNode;
    }

    @Override
    protected void onOneShotShelve(ServiceContext serviceContext) throws StatusException {
        NodeId nodeId = this.getCurrentStateNode().getId();
        if (Identifiers.ShelvedStateMachineType_OneShotShelved.equals(nodeId)) {
            return;
        }
        this.getCurrentStateNode().setId(Identifiers.ShelvedStateMachineType_OneShotShelved);
        if (Identifiers.ShelvedStateMachineType_TimedShelved.equals(nodeId)) {
            this.Oz.cancel();
            this.getLastTransitionNode().setId(Identifiers.ShelvedStateMachineType_TimedShelvedToOneShotShelved);
        }
        if (Identifiers.ShelvedStateMachineType_Unshelved.equals(nodeId)) {
            this.getLastTransitionNode().setId(Identifiers.ShelvedStateMachineType_UnshelvedToOneShotShelved);
        }
    }

    @Override
    protected void onOneShotShelve2(ServiceContext serviceContext, LocalizedText localizedText) throws StatusException {
        throw new StatusException(StatusCodes.Bad_NotImplemented);
    }

    @Override
    protected void onTimedShelve(ServiceContext serviceContext, Double d2) throws StatusException {
        NodeId nodeId = this.getCurrentStateNode().getId();
        if (Identifiers.ShelvedStateMachineType_TimedShelved.equals(nodeId)) {
            if (this.Ox) {
                this.Oz.cancel();
                this.Oz = null;
                logger.info("TimedShelve reset: NodeId=" + this.getNodeId());
            } else {
                throw new StatusException(StatusCodes.Bad_ConditionAlreadyShelved);
            }
        }
        long l2 = (long)Math.ceil(d2);
        this.getCurrentStateNode().setId(Identifiers.ShelvedStateMachineType_TimedShelved);
        if (this.Oz == null) {
            this.Oz = new Timer("UnshelveTimer");
        }
        try {
            this.Oz.schedule((TimerTask)new UnshelveTask(this), l2);
            this.Oy = System.currentTimeMillis() + l2;
            logger.info("TimedShelve started: NodeId=" + this.getNodeId());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new StatusException(StatusCodes.Bad_ShelvingTimeOutOfRange);
        }
        if (Identifiers.ShelvedStateMachineType_OneShotShelved.equals(nodeId)) {
            this.getLastTransitionNode().setId(Identifiers.ShelvedStateMachineType_OneShotShelvedToTimedShelved);
        }
        if (Identifiers.ShelvedStateMachineType_Unshelved.equals(nodeId)) {
            this.getLastTransitionNode().setId(Identifiers.ShelvedStateMachineType_UnshelvedToTimedShelved);
        }
    }

    @Override
    protected void onTimedShelve2(ServiceContext serviceContext, Double d2, LocalizedText localizedText) throws StatusException {
        throw new StatusException(StatusCodes.Bad_NotImplemented);
    }

    @Override
    protected void onUnshelve(ServiceContext serviceContext) throws StatusException {
        NodeId nodeId = this.getCurrentStateNode().getId();
        if (Identifiers.ShelvedStateMachineType_Unshelved.equals(nodeId)) {
            return;
        }
        this.getCurrentStateNode().setId(Identifiers.ShelvedStateMachineType_Unshelved);
        if (Identifiers.ShelvedStateMachineType_OneShotShelved.equals(nodeId)) {
            this.getLastTransitionNode().setId(Identifiers.ShelvedStateMachineType_OneShotShelvedToUnshelved);
        }
        if (Identifiers.ShelvedStateMachineType_TimedShelved.equals(nodeId)) {
            this.Oz.cancel();
            this.getLastTransitionNode().setId(Identifiers.ShelvedStateMachineType_TimedShelvedToUnshelved);
            this.Oz = null;
        }
    }

    @Override
    protected void onUnshelve2(ServiceContext serviceContext, LocalizedText localizedText) throws StatusException {
        throw new StatusException(StatusCodes.Bad_NotImplemented);
    }

    public class UnshelveTask
    extends TimerTask {
        private final ShelvedStateMachineTypeNode OA;

        public UnshelveTask(ShelvedStateMachineTypeNode shelvedStateMachineTypeNode2) {
            this.OA = shelvedStateMachineTypeNode2;
        }

        @Override
        public void run() {
            try {
                this.OA.unshelve();
                logger.info("TimedShelve ended: NodeId=" + this.OA.getNodeId());
            }
            catch (StatusException statusException) {
                logger.error("Timed unshelving failed: " + statusException);
            }
        }
    }
}

