/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.types.opcua.SessionSecurityDiagnosticsType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.SessionSecurityDiagnosticsTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2244")
public abstract class SessionSecurityDiagnosticsTypeNodeBase
extends BaseDataVariableTypeNode
implements SessionSecurityDiagnosticsType {
    private static GeneratedNodeInitializer<SessionSecurityDiagnosticsTypeNode> Ou;

    protected SessionSecurityDiagnosticsTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getClientUserIdHistoryNode());
        this.callAfterCreateIfExists(this.getSecurityModeNode());
        this.callAfterCreateIfExists(this.getEncodingNode());
        this.callAfterCreateIfExists(this.getSessionIdNode());
        this.callAfterCreateIfExists(this.getClientCertificateNode());
        this.callAfterCreateIfExists(this.getTransportProtocolNode());
        this.callAfterCreateIfExists(this.getAuthenticationMechanismNode());
        this.callAfterCreateIfExists(this.getSecurityPolicyUriNode());
        this.callAfterCreateIfExists(this.getClientUserIdOfSessionNode());
        GeneratedNodeInitializer<SessionSecurityDiagnosticsTypeNode> generatedNodeInitializer = SessionSecurityDiagnosticsTypeNodeBase.getSessionSecurityDiagnosticsTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((SessionSecurityDiagnosticsTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<SessionSecurityDiagnosticsTypeNode> getSessionSecurityDiagnosticsTypeNodeInitializer() {
        return Ou;
    }

    public static void setSessionSecurityDiagnosticsTypeNodeInitializer(GeneratedNodeInitializer<SessionSecurityDiagnosticsTypeNode> generatedNodeInitializer) {
        Ou = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getClientUserIdHistoryNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ClientUserIdHistory");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String[] getClientUserIdHistory() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getClientUserIdHistoryNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node ClientUserIdHistory does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (String[])object;
    }

    @Override
    @Mandatory
    public void setClientUserIdHistory(String[] stringArray) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getClientUserIdHistoryNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting ClientUserIdHistory failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(stringArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ClientUserIdHistory failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getSecurityModeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SecurityMode");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public MessageSecurityMode getSecurityMode() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSecurityModeNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node SecurityMode does not exist");
        }
        Variant variant = baseDataVariableTypeNode.getValue().getValue();
        return (MessageSecurityMode)variant.asEnum(MessageSecurityMode.class);
    }

    @Override
    @Mandatory
    public void setSecurityMode(MessageSecurityMode messageSecurityMode) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSecurityModeNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting SecurityMode failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(messageSecurityMode);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SecurityMode failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getEncodingNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Encoding");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getEncoding() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getEncodingNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node Encoding does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setEncoding(String string) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getEncodingNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting Encoding failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Encoding failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getSessionIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SessionId");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getSessionId() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSessionIdNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node SessionId does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setSessionId(NodeId nodeId) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSessionIdNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting SessionId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(nodeId);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SessionId failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getClientCertificateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ClientCertificate");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ByteString getClientCertificate() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getClientCertificateNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node ClientCertificate does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (ByteString)object;
    }

    @Override
    @Mandatory
    public void setClientCertificate(ByteString byteString) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getClientCertificateNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting ClientCertificate failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(byteString);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ClientCertificate failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getTransportProtocolNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TransportProtocol");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getTransportProtocol() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getTransportProtocolNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node TransportProtocol does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setTransportProtocol(String string) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getTransportProtocolNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting TransportProtocol failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting TransportProtocol failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getAuthenticationMechanismNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AuthenticationMechanism");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getAuthenticationMechanism() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getAuthenticationMechanismNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node AuthenticationMechanism does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setAuthenticationMechanism(String string) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getAuthenticationMechanismNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting AuthenticationMechanism failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting AuthenticationMechanism failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getSecurityPolicyUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SecurityPolicyUri");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getSecurityPolicyUri() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSecurityPolicyUriNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node SecurityPolicyUri does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setSecurityPolicyUri(String string) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSecurityPolicyUriNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting SecurityPolicyUri failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SecurityPolicyUri failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getClientUserIdOfSessionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ClientUserIdOfSession");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getClientUserIdOfSession() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getClientUserIdOfSessionNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node ClientUserIdOfSession does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setClientUserIdOfSession(String string) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getClientUserIdOfSessionNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting ClientUserIdOfSession failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ClientUserIdOfSession failed unexpectedly", statusException);
        }
    }
}

