/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.ServerState;
import com.prosysopc.ua.stack.core.ServerStatusDataType;
import com.prosysopc.ua.stack.core.TimeZoneDataType;
import com.prosysopc.ua.types.opcua.ServerType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.NamespacesTypeNode;
import com.prosysopc.ua.types.opcua.server.ServerCapabilitiesTypeNode;
import com.prosysopc.ua.types.opcua.server.ServerDiagnosticsTypeNode;
import com.prosysopc.ua.types.opcua.server.ServerRedundancyTypeNode;
import com.prosysopc.ua.types.opcua.server.ServerStatusTypeNode;
import com.prosysopc.ua.types.opcua.server.ServerTypeGetMonitoredItemsMethod;
import com.prosysopc.ua.types.opcua.server.ServerTypeNode;
import com.prosysopc.ua.types.opcua.server.ServerTypeRequestServerStateChangeMethod;
import com.prosysopc.ua.types.opcua.server.ServerTypeResendDataMethod;
import com.prosysopc.ua.types.opcua.server.ServerTypeSetSubscriptionDurableMethod;
import com.prosysopc.ua.types.opcua.server.VendorServerInfoTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2004")
public abstract class ServerTypeNodeBase
extends BaseObjectTypeNode
implements ServerType {
    private static GeneratedNodeInitializer<ServerTypeNode> Oi;
    private static ServerTypeGetMonitoredItemsMethod Oj;
    private static ServerTypeSetSubscriptionDurableMethod Ok;
    private static ServerTypeRequestServerStateChangeMethod Ol;
    private static ServerTypeResendDataMethod Om;

    protected ServerTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getServerStatusNode());
        this.callAfterCreateIfExists(this.getServerDiagnosticsNode());
        this.callAfterCreateIfExists(this.getServerRedundancyNode());
        this.callAfterCreateIfExists(this.getNamespacesNode());
        this.callAfterCreateIfExists(this.getVendorServerInfoNode());
        this.callAfterCreateIfExists(this.getServerCapabilitiesNode());
        GeneratedNodeInitializer<ServerTypeNode> generatedNodeInitializer = ServerTypeNodeBase.getServerTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((ServerTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<ServerTypeNode> getServerTypeNodeInitializer() {
        return Oi;
    }

    public static void setServerTypeNodeInitializer(GeneratedNodeInitializer<ServerTypeNode> generatedNodeInitializer) {
        Oi = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getServerArrayNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ServerArray");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String[] getServerArray() {
        UaProperty uaProperty = this.getServerArrayNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ServerArray does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String[])object;
    }

    @Override
    @Mandatory
    public void setServerArray(String[] stringArray) {
        UaProperty uaProperty = this.getServerArrayNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ServerArray failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(stringArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ServerArray failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getAuditingNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Auditing");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isAuditing() {
        UaProperty uaProperty = this.getAuditingNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node Auditing does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setAuditing(Boolean bl) {
        UaProperty uaProperty = this.getAuditingNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Auditing failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(bl);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Auditing failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getEstimatedReturnTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EstimatedReturnTime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public DateTime getEstimatedReturnTime() {
        UaProperty uaProperty = this.getEstimatedReturnTimeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Optional
    public void setEstimatedReturnTime(DateTime dateTime) {
        UaProperty uaProperty = this.getEstimatedReturnTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EstimatedReturnTime failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(dateTime);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting EstimatedReturnTime failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getUrisVersionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "UrisVersion");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getUrisVersion() {
        UaProperty uaProperty = this.getUrisVersionNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setUrisVersion(UnsignedInteger unsignedInteger) {
        UaProperty uaProperty = this.getUrisVersionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting UrisVersion failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting UrisVersion failed unexpectedly", statusException);
        }
    }

    public void setUrisVersion(long l2) {
        this.setUrisVersion(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Optional
    public UaProperty getLocalTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LocalTime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public TimeZoneDataType getLocalTime() {
        UaProperty uaProperty = this.getLocalTimeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (TimeZoneDataType)object;
    }

    @Override
    @Optional
    public void setLocalTime(TimeZoneDataType timeZoneDataType) {
        UaProperty uaProperty = this.getLocalTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting LocalTime failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(timeZoneDataType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting LocalTime failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getNamespaceArrayNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "NamespaceArray");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String[] getNamespaceArray() {
        UaProperty uaProperty = this.getNamespaceArrayNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node NamespaceArray does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String[])object;
    }

    @Override
    @Mandatory
    public void setNamespaceArray(String[] stringArray) {
        UaProperty uaProperty = this.getNamespaceArrayNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting NamespaceArray failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(stringArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting NamespaceArray failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getServiceLevelNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ServiceLevel");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedByte getServiceLevel() {
        UaProperty uaProperty = this.getServiceLevelNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ServiceLevel does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedByte)object;
    }

    @Override
    @Mandatory
    public void setServiceLevel(UnsignedByte unsignedByte) {
        UaProperty uaProperty = this.getServiceLevelNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ServiceLevel failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedByte);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ServiceLevel failed unexpectedly", statusException);
        }
    }

    public void setServiceLevel(int n2) {
        this.setServiceLevel(UnsignedByte.valueOf(n2));
    }

    @Override
    @Mandatory
    public ServerStatusTypeNode getServerStatusNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ServerStatus");
        return (ServerStatusTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServerStatusDataType getServerStatus() {
        ServerStatusTypeNode serverStatusTypeNode = this.getServerStatusNode();
        if (serverStatusTypeNode == null) {
            throw new RuntimeException("Mandatory node ServerStatus does not exist");
        }
        Object object = serverStatusTypeNode.getValue().getValue().getValue();
        return (ServerStatusDataType)object;
    }

    @Override
    @Mandatory
    public void setServerStatus(ServerStatusDataType serverStatusDataType) {
        ServerStatusTypeNode serverStatusTypeNode = this.getServerStatusNode();
        if (serverStatusTypeNode == null) {
            throw new RuntimeException("Setting ServerStatus failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            serverStatusTypeNode.setValue(serverStatusDataType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ServerStatus failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public ServerDiagnosticsTypeNode getServerDiagnosticsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ServerDiagnostics");
        return (ServerDiagnosticsTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServerRedundancyTypeNode getServerRedundancyNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ServerRedundancy");
        return (ServerRedundancyTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public NamespacesTypeNode getNamespacesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Namespaces");
        return (NamespacesTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public VendorServerInfoTypeNode getVendorServerInfoNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "VendorServerInfo");
        return (VendorServerInfoTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServerCapabilitiesTypeNode getServerCapabilitiesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ServerCapabilities");
        return (ServerCapabilitiesTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "GetMonitoredItems"), nodeId)) {
            return this.c(serviceContext, (UnsignedInteger)variantArray[0].getValue()).asVariantArray();
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "SetSubscriptionDurable"), nodeId)) {
            return new Variant[]{new Variant(this.a(serviceContext, (UnsignedInteger)variantArray[0].getValue(), (UnsignedInteger)variantArray[1].getValue()))};
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "RequestServerStateChange"), nodeId)) {
            this.a(serviceContext, (ServerState)variantArray[0].asEnum(ServerState.class), (DateTime)variantArray[1].getValue(), (UnsignedInteger)variantArray[2].getValue(), (LocalizedText)variantArray[3].getValue(), (Boolean)variantArray[4].getValue());
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "ResendData"), nodeId)) {
            this.d(serviceContext, (UnsignedInteger)variantArray[0].getValue());
            return null;
        }
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    @Optional
    public UaMethod getGetMonitoredItemsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "GetMonitoredItems");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract ServerType.GetMonitoredItemsMethodOutputs onGetMonitoredItems(ServiceContext var1, UnsignedInteger var2) throws StatusException;

    @Override
    public ServerType.GetMonitoredItemsMethodOutputs getMonitoredItems(UnsignedInteger unsignedInteger) throws StatusException {
        return this.c(ServiceContext.INTERNAL_OPERATION_CONTEXT, unsignedInteger);
    }

    private ServerType.GetMonitoredItemsMethodOutputs c(ServiceContext serviceContext, UnsignedInteger unsignedInteger) throws StatusException {
        ServerTypeGetMonitoredItemsMethod serverTypeGetMonitoredItemsMethod = ServerTypeNodeBase.getGetMonitoredItemsMethodImplementation();
        if (serverTypeGetMonitoredItemsMethod != null) {
            return serverTypeGetMonitoredItemsMethod.getMonitoredItems(serviceContext, (ServerTypeNode)this, unsignedInteger);
        }
        return this.onGetMonitoredItems(serviceContext, unsignedInteger);
    }

    public static ServerTypeGetMonitoredItemsMethod getGetMonitoredItemsMethodImplementation() {
        return Oj;
    }

    public static void setGetMonitoredItemsMethodImplementation(ServerTypeGetMonitoredItemsMethod serverTypeGetMonitoredItemsMethod) {
        Oj = serverTypeGetMonitoredItemsMethod;
    }

    @Override
    @Optional
    public UaMethod getSetSubscriptionDurableNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SetSubscriptionDurable");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract UnsignedInteger onSetSubscriptionDurable(ServiceContext var1, UnsignedInteger var2, UnsignedInteger var3) throws StatusException;

    @Override
    public UnsignedInteger setSubscriptionDurable(UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2) throws StatusException {
        return this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, unsignedInteger, unsignedInteger2);
    }

    private UnsignedInteger a(ServiceContext serviceContext, UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2) throws StatusException {
        ServerTypeSetSubscriptionDurableMethod serverTypeSetSubscriptionDurableMethod = ServerTypeNodeBase.getSetSubscriptionDurableMethodImplementation();
        if (serverTypeSetSubscriptionDurableMethod != null) {
            return serverTypeSetSubscriptionDurableMethod.setSubscriptionDurable(serviceContext, (ServerTypeNode)this, unsignedInteger, unsignedInteger2);
        }
        return this.onSetSubscriptionDurable(serviceContext, unsignedInteger, unsignedInteger2);
    }

    public static ServerTypeSetSubscriptionDurableMethod getSetSubscriptionDurableMethodImplementation() {
        return Ok;
    }

    public static void setSetSubscriptionDurableMethodImplementation(ServerTypeSetSubscriptionDurableMethod serverTypeSetSubscriptionDurableMethod) {
        Ok = serverTypeSetSubscriptionDurableMethod;
    }

    @Override
    @Optional
    public UaMethod getRequestServerStateChangeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RequestServerStateChange");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onRequestServerStateChange(ServiceContext var1, ServerState var2, DateTime var3, UnsignedInteger var4, LocalizedText var5, Boolean var6) throws StatusException;

    @Override
    public void requestServerStateChange(ServerState serverState, DateTime dateTime, UnsignedInteger unsignedInteger, LocalizedText localizedText, Boolean bl) throws StatusException {
        this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, serverState, dateTime, unsignedInteger, localizedText, bl);
    }

    private void a(ServiceContext serviceContext, ServerState serverState, DateTime dateTime, UnsignedInteger unsignedInteger, LocalizedText localizedText, Boolean bl) throws StatusException {
        ServerTypeRequestServerStateChangeMethod serverTypeRequestServerStateChangeMethod = ServerTypeNodeBase.getRequestServerStateChangeMethodImplementation();
        if (serverTypeRequestServerStateChangeMethod != null) {
            serverTypeRequestServerStateChangeMethod.requestServerStateChange(serviceContext, (ServerTypeNode)this, serverState, dateTime, unsignedInteger, localizedText, bl);
        } else {
            this.onRequestServerStateChange(serviceContext, serverState, dateTime, unsignedInteger, localizedText, bl);
        }
    }

    public static ServerTypeRequestServerStateChangeMethod getRequestServerStateChangeMethodImplementation() {
        return Ol;
    }

    public static void setRequestServerStateChangeMethodImplementation(ServerTypeRequestServerStateChangeMethod serverTypeRequestServerStateChangeMethod) {
        Ol = serverTypeRequestServerStateChangeMethod;
    }

    @Override
    @Optional
    public UaMethod getResendDataNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ResendData");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onResendData(ServiceContext var1, UnsignedInteger var2) throws StatusException;

    @Override
    public void resendData(UnsignedInteger unsignedInteger) throws StatusException {
        this.d(ServiceContext.INTERNAL_OPERATION_CONTEXT, unsignedInteger);
    }

    private void d(ServiceContext serviceContext, UnsignedInteger unsignedInteger) throws StatusException {
        ServerTypeResendDataMethod serverTypeResendDataMethod = ServerTypeNodeBase.getResendDataMethodImplementation();
        if (serverTypeResendDataMethod != null) {
            serverTypeResendDataMethod.resendData(serviceContext, (ServerTypeNode)this, unsignedInteger);
        } else {
            this.onResendData(serviceContext, unsignedInteger);
        }
    }

    public static ServerTypeResendDataMethod getResendDataMethodImplementation() {
        return Om;
    }

    public static void setResendDataMethodImplementation(ServerTypeResendDataMethod serverTypeResendDataMethod) {
        Om = serverTypeResendDataMethod;
    }
}

