/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.types.opcua.RationalNumberType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.RationalNumberTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=17709")
public abstract class RationalNumberTypeNodeBase
extends BaseDataVariableTypeNode
implements RationalNumberType {
    private static GeneratedNodeInitializer<RationalNumberTypeNode> Nl;

    protected RationalNumberTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getDenominatorNode());
        this.callAfterCreateIfExists(this.getNumeratorNode());
        GeneratedNodeInitializer<RationalNumberTypeNode> generatedNodeInitializer = RationalNumberTypeNodeBase.getRationalNumberTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((RationalNumberTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<RationalNumberTypeNode> getRationalNumberTypeNodeInitializer() {
        return Nl;
    }

    public static void setRationalNumberTypeNodeInitializer(GeneratedNodeInitializer<RationalNumberTypeNode> generatedNodeInitializer) {
        Nl = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getDenominatorNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Denominator");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getDenominator() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getDenominatorNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node Denominator does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setDenominator(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getDenominatorNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting Denominator failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Denominator failed unexpectedly", statusException);
        }
    }

    public void setDenominator(long l2) {
        this.setDenominator(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getNumeratorNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Numerator");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public Integer getNumerator() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getNumeratorNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node Numerator does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (Integer)object;
    }

    @Override
    @Mandatory
    public void setNumerator(Integer n2) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getNumeratorNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting Numerator failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(n2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Numerator failed unexpectedly", statusException);
        }
    }
}

