/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.ConfigurationVersionDataType;
import com.prosysopc.ua.stack.core.ContentFilter;
import com.prosysopc.ua.stack.core.SimpleAttributeOperand;
import com.prosysopc.ua.types.opcua.PublishedEventsType;
import com.prosysopc.ua.types.opcua.server.PublishedDataSetTypeNode;
import com.prosysopc.ua.types.opcua.server.PublishedEventsTypeModifyFieldSelectionMethod;
import com.prosysopc.ua.types.opcua.server.PublishedEventsTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=14572")
public abstract class PublishedEventsTypeNodeBase
extends PublishedDataSetTypeNode
implements PublishedEventsType {
    private static GeneratedNodeInitializer<PublishedEventsTypeNode> Nh;
    private static PublishedEventsTypeModifyFieldSelectionMethod Ni;

    protected PublishedEventsTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<PublishedEventsTypeNode> generatedNodeInitializer = PublishedEventsTypeNodeBase.getPublishedEventsTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((PublishedEventsTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<PublishedEventsTypeNode> getPublishedEventsTypeNodeInitializer() {
        return Nh;
    }

    public static void setPublishedEventsTypeNodeInitializer(GeneratedNodeInitializer<PublishedEventsTypeNode> generatedNodeInitializer) {
        Nh = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getSelectedFieldsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SelectedFields");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public SimpleAttributeOperand[] getSelectedFields() {
        UaProperty uaProperty = this.getSelectedFieldsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node SelectedFields does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (SimpleAttributeOperand[])object;
    }

    @Override
    @Mandatory
    public void setSelectedFields(SimpleAttributeOperand[] simpleAttributeOperandArray) {
        UaProperty uaProperty = this.getSelectedFieldsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SelectedFields failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(simpleAttributeOperandArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SelectedFields failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getPubSubEventNotifierNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EventNotifier");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getPubSubEventNotifier() {
        UaProperty uaProperty = this.getPubSubEventNotifierNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node PubSubEventNotifier does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setPubSubEventNotifier(NodeId nodeId) {
        UaProperty uaProperty = this.getPubSubEventNotifierNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting PubSubEventNotifier failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(nodeId);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting PubSubEventNotifier failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getFilterNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Filter");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public ContentFilter getFilter() {
        UaProperty uaProperty = this.getFilterNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node Filter does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (ContentFilter)object;
    }

    @Override
    @Mandatory
    public void setFilter(ContentFilter contentFilter) {
        UaProperty uaProperty = this.getFilterNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Filter failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(contentFilter);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Filter failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "ModifyFieldSelection"), nodeId)) {
            return new Variant[]{new Variant(this.a(serviceContext, (ConfigurationVersionDataType)variantArray[0].getValue(), (String[])variantArray[1].getValue(), (Boolean[])variantArray[2].getValue(), (SimpleAttributeOperand[])variantArray[3].getValue()))};
        }
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    @Optional
    public UaMethod getModifyFieldSelectionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ModifyFieldSelection");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract ConfigurationVersionDataType onModifyFieldSelection(ServiceContext var1, ConfigurationVersionDataType var2, String[] var3, Boolean[] var4, SimpleAttributeOperand[] var5) throws StatusException;

    @Override
    public ConfigurationVersionDataType modifyFieldSelection(ConfigurationVersionDataType configurationVersionDataType, String[] stringArray, Boolean[] booleanArray, SimpleAttributeOperand[] simpleAttributeOperandArray) throws StatusException {
        return this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, configurationVersionDataType, stringArray, booleanArray, simpleAttributeOperandArray);
    }

    private ConfigurationVersionDataType a(ServiceContext serviceContext, ConfigurationVersionDataType configurationVersionDataType, String[] stringArray, Boolean[] booleanArray, SimpleAttributeOperand[] simpleAttributeOperandArray) throws StatusException {
        PublishedEventsTypeModifyFieldSelectionMethod publishedEventsTypeModifyFieldSelectionMethod = PublishedEventsTypeNodeBase.getModifyFieldSelectionMethodImplementation();
        if (publishedEventsTypeModifyFieldSelectionMethod != null) {
            return publishedEventsTypeModifyFieldSelectionMethod.modifyFieldSelection(serviceContext, (PublishedEventsTypeNode)this, configurationVersionDataType, stringArray, booleanArray, simpleAttributeOperandArray);
        }
        return this.onModifyFieldSelection(serviceContext, configurationVersionDataType, stringArray, booleanArray, simpleAttributeOperandArray);
    }

    public static PublishedEventsTypeModifyFieldSelectionMethod getModifyFieldSelectionMethodImplementation() {
        return Ni;
    }

    public static void setModifyFieldSelectionMethodImplementation(PublishedEventsTypeModifyFieldSelectionMethod publishedEventsTypeModifyFieldSelectionMethod) {
        Ni = publishedEventsTypeModifyFieldSelectionMethod;
    }
}

