/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.PubSubTransportLimitsExceedEventType;
import com.prosysopc.ua.types.opcua.server.PubSubStatusEventTypeNode;
import com.prosysopc.ua.types.opcua.server.PubSubTransportLimitsExceedEventTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=15548")
public abstract class PubSubTransportLimitsExceedEventTypeNodeBase
extends PubSubStatusEventTypeNode
implements PubSubTransportLimitsExceedEventType {
    private static GeneratedNodeInitializer<PubSubTransportLimitsExceedEventTypeNode> MY;

    protected PubSubTransportLimitsExceedEventTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<PubSubTransportLimitsExceedEventTypeNode> generatedNodeInitializer = PubSubTransportLimitsExceedEventTypeNodeBase.getPubSubTransportLimitsExceedEventTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((PubSubTransportLimitsExceedEventTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<PubSubTransportLimitsExceedEventTypeNode> getPubSubTransportLimitsExceedEventTypeNodeInitializer() {
        return MY;
    }

    public static void setPubSubTransportLimitsExceedEventTypeNodeInitializer(GeneratedNodeInitializer<PubSubTransportLimitsExceedEventTypeNode> generatedNodeInitializer) {
        MY = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getActualNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Actual");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getActual() {
        UaProperty uaProperty = this.getActualNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node Actual does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setActual(UnsignedInteger unsignedInteger) {
        UaProperty uaProperty = this.getActualNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Actual failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Actual failed unexpectedly", statusException);
        }
    }

    public void setActual(long l2) {
        this.setActual(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public UaProperty getMaximumNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Maximum");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getMaximum() {
        UaProperty uaProperty = this.getMaximumNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node Maximum does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setMaximum(UnsignedInteger unsignedInteger) {
        UaProperty uaProperty = this.getMaximumNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Maximum failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Maximum failed unexpectedly", statusException);
        }
    }

    public void setMaximum(long l2) {
        this.setMaximum(UnsignedInteger.valueOf(l2));
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

