/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.PubSubState;
import com.prosysopc.ua.types.opcua.PubSubStatusEventType;
import com.prosysopc.ua.types.opcua.server.PubSubStatusEventTypeNode;
import com.prosysopc.ua.types.opcua.server.SystemEventTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=15535")
public abstract class PubSubStatusEventTypeNodeBase
extends SystemEventTypeNode
implements PubSubStatusEventType {
    private static GeneratedNodeInitializer<PubSubStatusEventTypeNode> MU;

    protected PubSubStatusEventTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<PubSubStatusEventTypeNode> generatedNodeInitializer = PubSubStatusEventTypeNodeBase.getPubSubStatusEventTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((PubSubStatusEventTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<PubSubStatusEventTypeNode> getPubSubStatusEventTypeNodeInitializer() {
        return MU;
    }

    public static void setPubSubStatusEventTypeNodeInitializer(GeneratedNodeInitializer<PubSubStatusEventTypeNode> generatedNodeInitializer) {
        MU = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "State");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public PubSubState getState() {
        UaProperty uaProperty = this.getStateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node State does not exist");
        }
        Variant variant = uaProperty.getValue().getValue();
        return (PubSubState)variant.asEnum(PubSubState.class);
    }

    @Override
    @Mandatory
    public void setState(PubSubState pubSubState) {
        UaProperty uaProperty = this.getStateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting State failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(pubSubState);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting State failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getGroupIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "GroupId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getGroupId() {
        UaProperty uaProperty = this.getGroupIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node GroupId does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setGroupId(NodeId nodeId) {
        UaProperty uaProperty = this.getGroupIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting GroupId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(nodeId);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting GroupId failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getConnectionIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ConnectionId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getConnectionId() {
        UaProperty uaProperty = this.getConnectionIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ConnectionId does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setConnectionId(NodeId nodeId) {
        UaProperty uaProperty = this.getConnectionIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ConnectionId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(nodeId);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ConnectionId failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

