/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.DiagnosticsLevel;
import com.prosysopc.ua.types.opcua.PubSubDiagnosticsType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.PubSubDiagnosticsCounterTypeNode;
import com.prosysopc.ua.types.opcua.server.PubSubDiagnosticsTypeNode;
import com.prosysopc.ua.types.opcua.server.PubSubDiagnosticsTypeResetMethod;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=19677")
public abstract class PubSubDiagnosticsTypeNodeBase
extends BaseObjectTypeNode
implements PubSubDiagnosticsType {
    private static GeneratedNodeInitializer<PubSubDiagnosticsTypeNode> ME;
    private static PubSubDiagnosticsTypeResetMethod MF;

    protected PubSubDiagnosticsTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getDiagnosticsLevelNode());
        this.callAfterCreateIfExists(this.getTotalErrorNode());
        this.callAfterCreateIfExists(this.getSubErrorNode());
        this.callAfterCreateIfExists(this.getTotalInformationNode());
        this.callAfterCreateIfExists(this.getLiveValuesNode());
        this.callAfterCreateIfExists(this.getCountersNode());
        GeneratedNodeInitializer<PubSubDiagnosticsTypeNode> generatedNodeInitializer = PubSubDiagnosticsTypeNodeBase.getPubSubDiagnosticsTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((PubSubDiagnosticsTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<PubSubDiagnosticsTypeNode> getPubSubDiagnosticsTypeNodeInitializer() {
        return ME;
    }

    public static void setPubSubDiagnosticsTypeNodeInitializer(GeneratedNodeInitializer<PubSubDiagnosticsTypeNode> generatedNodeInitializer) {
        ME = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getDiagnosticsLevelNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DiagnosticsLevel");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public DiagnosticsLevel getDiagnosticsLevel() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getDiagnosticsLevelNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node DiagnosticsLevel does not exist");
        }
        Variant variant = baseDataVariableTypeNode.getValue().getValue();
        return (DiagnosticsLevel)variant.asEnum(DiagnosticsLevel.class);
    }

    @Override
    @Mandatory
    public void setDiagnosticsLevel(DiagnosticsLevel diagnosticsLevel) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getDiagnosticsLevelNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting DiagnosticsLevel failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(diagnosticsLevel);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DiagnosticsLevel failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public PubSubDiagnosticsCounterTypeNode getTotalErrorNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TotalError");
        return (PubSubDiagnosticsCounterTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getTotalError() {
        PubSubDiagnosticsCounterTypeNode pubSubDiagnosticsCounterTypeNode = this.getTotalErrorNode();
        if (pubSubDiagnosticsCounterTypeNode == null) {
            throw new RuntimeException("Mandatory node TotalError does not exist");
        }
        Object object = pubSubDiagnosticsCounterTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setTotalError(UnsignedInteger unsignedInteger) {
        PubSubDiagnosticsCounterTypeNode pubSubDiagnosticsCounterTypeNode = this.getTotalErrorNode();
        if (pubSubDiagnosticsCounterTypeNode == null) {
            throw new RuntimeException("Setting TotalError failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            pubSubDiagnosticsCounterTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting TotalError failed unexpectedly", statusException);
        }
    }

    public void setTotalError(long l2) {
        this.setTotalError(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getSubErrorNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SubError");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isSubError() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSubErrorNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node SubError does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setSubError(Boolean bl) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSubErrorNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting SubError failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(bl);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SubError failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public PubSubDiagnosticsCounterTypeNode getTotalInformationNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TotalInformation");
        return (PubSubDiagnosticsCounterTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getTotalInformation() {
        PubSubDiagnosticsCounterTypeNode pubSubDiagnosticsCounterTypeNode = this.getTotalInformationNode();
        if (pubSubDiagnosticsCounterTypeNode == null) {
            throw new RuntimeException("Mandatory node TotalInformation does not exist");
        }
        Object object = pubSubDiagnosticsCounterTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setTotalInformation(UnsignedInteger unsignedInteger) {
        PubSubDiagnosticsCounterTypeNode pubSubDiagnosticsCounterTypeNode = this.getTotalInformationNode();
        if (pubSubDiagnosticsCounterTypeNode == null) {
            throw new RuntimeException("Setting TotalInformation failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            pubSubDiagnosticsCounterTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting TotalInformation failed unexpectedly", statusException);
        }
    }

    public void setTotalInformation(long l2) {
        this.setTotalInformation(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseObjectTypeNode getLiveValuesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LiveValues");
        return (BaseObjectTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public BaseObjectTypeNode getCountersNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Counters");
        return (BaseObjectTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "Reset"), nodeId)) {
            this.h(serviceContext);
            return null;
        }
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    @Mandatory
    public UaMethod getResetNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Reset");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onReset(ServiceContext var1) throws StatusException;

    @Override
    public void reset() throws StatusException {
        this.h(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    private void h(ServiceContext serviceContext) throws StatusException {
        PubSubDiagnosticsTypeResetMethod pubSubDiagnosticsTypeResetMethod = PubSubDiagnosticsTypeNodeBase.getResetMethodImplementation();
        if (pubSubDiagnosticsTypeResetMethod != null) {
            pubSubDiagnosticsTypeResetMethod.reset(serviceContext, (PubSubDiagnosticsTypeNode)this);
        } else {
            this.onReset(serviceContext);
        }
    }

    public static PubSubDiagnosticsTypeResetMethod getResetMethodImplementation() {
        return MF;
    }

    public static void setResetMethodImplementation(PubSubDiagnosticsTypeResetMethod pubSubDiagnosticsTypeResetMethod) {
        MF = pubSubDiagnosticsTypeResetMethod;
    }
}

