/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.KeyValuePair;
import com.prosysopc.ua.stack.core.ReaderGroupDataType;
import com.prosysopc.ua.stack.core.WriterGroupDataType;
import com.prosysopc.ua.types.opcua.PubSubConnectionType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.ConnectionTransportTypeNode;
import com.prosysopc.ua.types.opcua.server.NetworkAddressTypeNode;
import com.prosysopc.ua.types.opcua.server.PubSubConnectionTypeAddReaderGroupMethod;
import com.prosysopc.ua.types.opcua.server.PubSubConnectionTypeAddWriterGroupMethod;
import com.prosysopc.ua.types.opcua.server.PubSubConnectionTypeNode;
import com.prosysopc.ua.types.opcua.server.PubSubConnectionTypeRemoveGroupMethod;
import com.prosysopc.ua.types.opcua.server.PubSubDiagnosticsConnectionTypeNode;
import com.prosysopc.ua.types.opcua.server.PubSubStatusTypeNode;
import com.prosysopc.ua.types.opcua.server.SelectionListTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=14209")
public abstract class PubSubConnectionTypeNodeBase
extends BaseObjectTypeNode
implements PubSubConnectionType {
    private static GeneratedNodeInitializer<PubSubConnectionTypeNode> Mu;
    private static PubSubConnectionTypeRemoveGroupMethod Mv;
    private static PubSubConnectionTypeAddWriterGroupMethod Mw;
    private static PubSubConnectionTypeAddReaderGroupMethod Mx;

    protected PubSubConnectionTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getTransportProfileUriNode());
        this.callAfterCreateIfExists(this.getStatusNode());
        this.callAfterCreateIfExists(this.getTransportSettingsNode());
        this.callAfterCreateIfExists(this.getAddressNode());
        this.callAfterCreateIfExists(this.getDiagnosticsNode());
        GeneratedNodeInitializer<PubSubConnectionTypeNode> generatedNodeInitializer = PubSubConnectionTypeNodeBase.getPubSubConnectionTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((PubSubConnectionTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<PubSubConnectionTypeNode> getPubSubConnectionTypeNodeInitializer() {
        return Mu;
    }

    public static void setPubSubConnectionTypeNodeInitializer(GeneratedNodeInitializer<PubSubConnectionTypeNode> generatedNodeInitializer) {
        Mu = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getPublisherIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "PublisherId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Object getPublisherId() {
        UaProperty uaProperty = this.getPublisherIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node PublisherId does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return object;
    }

    @Override
    @Mandatory
    public void setPublisherId(Object object) {
        UaProperty uaProperty = this.getPublisherIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting PublisherId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(object);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting PublisherId failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getConnectionPropertiesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ConnectionProperties");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public KeyValuePair[] getConnectionProperties() {
        UaProperty uaProperty = this.getConnectionPropertiesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ConnectionProperties does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (KeyValuePair[])object;
    }

    @Override
    @Mandatory
    public void setConnectionProperties(KeyValuePair[] keyValuePairArray) {
        UaProperty uaProperty = this.getConnectionPropertiesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ConnectionProperties failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(keyValuePairArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ConnectionProperties failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public SelectionListTypeNode getTransportProfileUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TransportProfileUri");
        return (SelectionListTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getTransportProfileUri() {
        SelectionListTypeNode selectionListTypeNode = this.getTransportProfileUriNode();
        if (selectionListTypeNode == null) {
            throw new RuntimeException("Mandatory node TransportProfileUri does not exist");
        }
        Object object = selectionListTypeNode.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setTransportProfileUri(String string) {
        SelectionListTypeNode selectionListTypeNode = this.getTransportProfileUriNode();
        if (selectionListTypeNode == null) {
            throw new RuntimeException("Setting TransportProfileUri failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            selectionListTypeNode.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting TransportProfileUri failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public PubSubStatusTypeNode getStatusNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Status");
        return (PubSubStatusTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public ConnectionTransportTypeNode getTransportSettingsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TransportSettings");
        return (ConnectionTransportTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public NetworkAddressTypeNode getAddressNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Address");
        return (NetworkAddressTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public PubSubDiagnosticsConnectionTypeNode getDiagnosticsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Diagnostics");
        return (PubSubDiagnosticsConnectionTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveGroup"), nodeId)) {
            this.h(serviceContext, (NodeId)variantArray[0].getValue());
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "AddWriterGroup"), nodeId)) {
            return new Variant[]{new Variant(this.a(serviceContext, (WriterGroupDataType)variantArray[0].getValue()))};
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "AddReaderGroup"), nodeId)) {
            return new Variant[]{new Variant(this.a(serviceContext, (ReaderGroupDataType)variantArray[0].getValue()))};
        }
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    @Optional
    public UaMethod getRemoveGroupNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveGroup");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onRemoveGroup(ServiceContext var1, NodeId var2) throws StatusException;

    @Override
    public void removeGroup(NodeId nodeId) throws StatusException {
        this.h(ServiceContext.INTERNAL_OPERATION_CONTEXT, nodeId);
    }

    private void h(ServiceContext serviceContext, NodeId nodeId) throws StatusException {
        PubSubConnectionTypeRemoveGroupMethod pubSubConnectionTypeRemoveGroupMethod = PubSubConnectionTypeNodeBase.getRemoveGroupMethodImplementation();
        if (pubSubConnectionTypeRemoveGroupMethod != null) {
            pubSubConnectionTypeRemoveGroupMethod.removeGroup(serviceContext, (PubSubConnectionTypeNode)this, nodeId);
        } else {
            this.onRemoveGroup(serviceContext, nodeId);
        }
    }

    public static PubSubConnectionTypeRemoveGroupMethod getRemoveGroupMethodImplementation() {
        return Mv;
    }

    public static void setRemoveGroupMethodImplementation(PubSubConnectionTypeRemoveGroupMethod pubSubConnectionTypeRemoveGroupMethod) {
        Mv = pubSubConnectionTypeRemoveGroupMethod;
    }

    @Override
    @Optional
    public UaMethod getAddWriterGroupNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AddWriterGroup");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract NodeId onAddWriterGroup(ServiceContext var1, WriterGroupDataType var2) throws StatusException;

    @Override
    public NodeId addWriterGroup(WriterGroupDataType writerGroupDataType) throws StatusException {
        return this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, writerGroupDataType);
    }

    private NodeId a(ServiceContext serviceContext, WriterGroupDataType writerGroupDataType) throws StatusException {
        PubSubConnectionTypeAddWriterGroupMethod pubSubConnectionTypeAddWriterGroupMethod = PubSubConnectionTypeNodeBase.getAddWriterGroupMethodImplementation();
        if (pubSubConnectionTypeAddWriterGroupMethod != null) {
            return pubSubConnectionTypeAddWriterGroupMethod.addWriterGroup(serviceContext, (PubSubConnectionTypeNode)this, writerGroupDataType);
        }
        return this.onAddWriterGroup(serviceContext, writerGroupDataType);
    }

    public static PubSubConnectionTypeAddWriterGroupMethod getAddWriterGroupMethodImplementation() {
        return Mw;
    }

    public static void setAddWriterGroupMethodImplementation(PubSubConnectionTypeAddWriterGroupMethod pubSubConnectionTypeAddWriterGroupMethod) {
        Mw = pubSubConnectionTypeAddWriterGroupMethod;
    }

    @Override
    @Optional
    public UaMethod getAddReaderGroupNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AddReaderGroup");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract NodeId onAddReaderGroup(ServiceContext var1, ReaderGroupDataType var2) throws StatusException;

    @Override
    public NodeId addReaderGroup(ReaderGroupDataType readerGroupDataType) throws StatusException {
        return this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, readerGroupDataType);
    }

    private NodeId a(ServiceContext serviceContext, ReaderGroupDataType readerGroupDataType) throws StatusException {
        PubSubConnectionTypeAddReaderGroupMethod pubSubConnectionTypeAddReaderGroupMethod = PubSubConnectionTypeNodeBase.getAddReaderGroupMethodImplementation();
        if (pubSubConnectionTypeAddReaderGroupMethod != null) {
            return pubSubConnectionTypeAddReaderGroupMethod.addReaderGroup(serviceContext, (PubSubConnectionTypeNode)this, readerGroupDataType);
        }
        return this.onAddReaderGroup(serviceContext, readerGroupDataType);
    }

    public static PubSubConnectionTypeAddReaderGroupMethod getAddReaderGroupMethodImplementation() {
        return Mx;
    }

    public static void setAddReaderGroupMethodImplementation(PubSubConnectionTypeAddReaderGroupMethod pubSubConnectionTypeAddReaderGroupMethod) {
        Mx = pubSubConnectionTypeAddReaderGroupMethod;
    }
}

