/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.ApplicationDescription;
import com.prosysopc.ua.types.opcua.ProvisionableDeviceType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.ProvisionableDeviceTypeNode;
import com.prosysopc.ua.types.opcua.server.ProvisionableDeviceTypeRequestTicketsMethod;
import com.prosysopc.ua.types.opcua.server.ProvisionableDeviceTypeSetRegistrarEndpointsMethod;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=26871")
public abstract class ProvisionableDeviceTypeNodeBase
extends BaseObjectTypeNode
implements ProvisionableDeviceType {
    private static GeneratedNodeInitializer<ProvisionableDeviceTypeNode> Mm;
    private static ProvisionableDeviceTypeRequestTicketsMethod Mn;
    private static ProvisionableDeviceTypeSetRegistrarEndpointsMethod Mo;

    protected ProvisionableDeviceTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<ProvisionableDeviceTypeNode> generatedNodeInitializer = ProvisionableDeviceTypeNodeBase.getProvisionableDeviceTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((ProvisionableDeviceTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<ProvisionableDeviceTypeNode> getProvisionableDeviceTypeNodeInitializer() {
        return Mm;
    }

    public static void setProvisionableDeviceTypeNodeInitializer(GeneratedNodeInitializer<ProvisionableDeviceTypeNode> generatedNodeInitializer) {
        Mm = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getIsSingletonNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "IsSingleton");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isIsSingleton() {
        UaProperty uaProperty = this.getIsSingletonNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node IsSingleton does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setIsSingleton(Boolean bl) {
        UaProperty uaProperty = this.getIsSingletonNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting IsSingleton failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(bl);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting IsSingleton failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "RequestTickets"), nodeId)) {
            return new Variant[]{new Variant(this.s(serviceContext))};
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "SetRegistrarEndpoints"), nodeId)) {
            this.a(serviceContext, (ApplicationDescription[])variantArray[0].getValue());
            return null;
        }
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    @Mandatory
    public UaMethod getRequestTicketsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RequestTickets");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract String[] onRequestTickets(ServiceContext var1) throws StatusException;

    @Override
    public String[] requestTickets() throws StatusException {
        return this.s(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    private String[] s(ServiceContext serviceContext) throws StatusException {
        ProvisionableDeviceTypeRequestTicketsMethod provisionableDeviceTypeRequestTicketsMethod = ProvisionableDeviceTypeNodeBase.getRequestTicketsMethodImplementation();
        if (provisionableDeviceTypeRequestTicketsMethod != null) {
            return provisionableDeviceTypeRequestTicketsMethod.requestTickets(serviceContext, (ProvisionableDeviceTypeNode)this);
        }
        return this.onRequestTickets(serviceContext);
    }

    public static ProvisionableDeviceTypeRequestTicketsMethod getRequestTicketsMethodImplementation() {
        return Mn;
    }

    public static void setRequestTicketsMethodImplementation(ProvisionableDeviceTypeRequestTicketsMethod provisionableDeviceTypeRequestTicketsMethod) {
        Mn = provisionableDeviceTypeRequestTicketsMethod;
    }

    @Override
    @Optional
    public UaMethod getSetRegistrarEndpointsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SetRegistrarEndpoints");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onSetRegistrarEndpoints(ServiceContext var1, ApplicationDescription[] var2) throws StatusException;

    @Override
    public void setRegistrarEndpoints(ApplicationDescription[] applicationDescriptionArray) throws StatusException {
        this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, applicationDescriptionArray);
    }

    private void a(ServiceContext serviceContext, ApplicationDescription[] applicationDescriptionArray) throws StatusException {
        ProvisionableDeviceTypeSetRegistrarEndpointsMethod provisionableDeviceTypeSetRegistrarEndpointsMethod = ProvisionableDeviceTypeNodeBase.getSetRegistrarEndpointsMethodImplementation();
        if (provisionableDeviceTypeSetRegistrarEndpointsMethod != null) {
            provisionableDeviceTypeSetRegistrarEndpointsMethod.setRegistrarEndpoints(serviceContext, (ProvisionableDeviceTypeNode)this, applicationDescriptionArray);
        } else {
            this.onSetRegistrarEndpoints(serviceContext, applicationDescriptionArray);
        }
    }

    public static ProvisionableDeviceTypeSetRegistrarEndpointsMethod getSetRegistrarEndpointsMethodImplementation() {
        return Mo;
    }

    public static void setSetRegistrarEndpointsMethodImplementation(ProvisionableDeviceTypeSetRegistrarEndpointsMethod provisionableDeviceTypeSetRegistrarEndpointsMethod) {
        Mo = provisionableDeviceTypeSetRegistrarEndpointsMethod;
    }
}

