/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.IPriorityMappingEntryType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.BaseInterfaceTypeNode;
import com.prosysopc.ua.types.opcua.server.IPriorityMappingEntryTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=24205")
public abstract class IPriorityMappingEntryTypeNodeBase
extends BaseInterfaceTypeNode
implements IPriorityMappingEntryType {
    private static GeneratedNodeInitializer<IPriorityMappingEntryTypeNode> Ld;

    protected IPriorityMappingEntryTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getMappingUriNode());
        this.callAfterCreateIfExists(this.getPriorityValue_DSCPNode());
        this.callAfterCreateIfExists(this.getPriorityValue_PCPNode());
        this.callAfterCreateIfExists(this.getPriorityLabelNode());
        GeneratedNodeInitializer<IPriorityMappingEntryTypeNode> generatedNodeInitializer = IPriorityMappingEntryTypeNodeBase.getIPriorityMappingEntryTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((IPriorityMappingEntryTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<IPriorityMappingEntryTypeNode> getIPriorityMappingEntryTypeNodeInitializer() {
        return Ld;
    }

    public static void setIPriorityMappingEntryTypeNodeInitializer(GeneratedNodeInitializer<IPriorityMappingEntryTypeNode> generatedNodeInitializer) {
        Ld = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getMappingUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MappingUri");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getMappingUri() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getMappingUriNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node MappingUri does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setMappingUri(String string) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getMappingUriNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting MappingUri failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MappingUri failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public BaseDataVariableTypeNode getPriorityValue_DSCPNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "PriorityValue_DSCP");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getPriorityValue_DSCP() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getPriorityValue_DSCPNode();
        if (baseDataVariableTypeNode == null) {
            return null;
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setPriorityValue_DSCP(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getPriorityValue_DSCPNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting PriorityValue_DSCP failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting PriorityValue_DSCP failed unexpectedly", statusException);
        }
    }

    public void setPriorityValue_DSCP(long l2) {
        this.setPriorityValue_DSCP(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Optional
    public BaseDataVariableTypeNode getPriorityValue_PCPNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "PriorityValue_PCP");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedByte getPriorityValue_PCP() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getPriorityValue_PCPNode();
        if (baseDataVariableTypeNode == null) {
            return null;
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedByte)object;
    }

    @Override
    @Optional
    public void setPriorityValue_PCP(UnsignedByte unsignedByte) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getPriorityValue_PCPNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting PriorityValue_PCP failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedByte);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting PriorityValue_PCP failed unexpectedly", statusException);
        }
    }

    public void setPriorityValue_PCP(int n2) {
        this.setPriorityValue_PCP(UnsignedByte.valueOf(n2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getPriorityLabelNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "PriorityLabel");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getPriorityLabel() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getPriorityLabelNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node PriorityLabel does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setPriorityLabel(String string) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getPriorityLabelNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting PriorityLabel failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting PriorityLabel failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

