/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.UnsignedRationalNumber;
import com.prosysopc.ua.types.opcua.IIeeeBaseTsnTrafficSpecificationType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.BaseInterfaceTypeNode;
import com.prosysopc.ua.types.opcua.server.IIeeeBaseTsnTrafficSpecificationTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=24179")
public abstract class IIeeeBaseTsnTrafficSpecificationTypeNodeBase
extends BaseInterfaceTypeNode
implements IIeeeBaseTsnTrafficSpecificationType {
    private static GeneratedNodeInitializer<IIeeeBaseTsnTrafficSpecificationTypeNode> KV;

    protected IIeeeBaseTsnTrafficSpecificationTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getMaxFrameSizeNode());
        this.callAfterCreateIfExists(this.getMaxIntervalFramesNode());
        this.callAfterCreateIfExists(this.getIntervalNode());
        GeneratedNodeInitializer<IIeeeBaseTsnTrafficSpecificationTypeNode> generatedNodeInitializer = IIeeeBaseTsnTrafficSpecificationTypeNodeBase.getIIeeeBaseTsnTrafficSpecificationTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((IIeeeBaseTsnTrafficSpecificationTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<IIeeeBaseTsnTrafficSpecificationTypeNode> getIIeeeBaseTsnTrafficSpecificationTypeNodeInitializer() {
        return KV;
    }

    public static void setIIeeeBaseTsnTrafficSpecificationTypeNodeInitializer(GeneratedNodeInitializer<IIeeeBaseTsnTrafficSpecificationTypeNode> generatedNodeInitializer) {
        KV = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getMaxFrameSizeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxFrameSize");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getMaxFrameSize() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getMaxFrameSizeNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node MaxFrameSize does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setMaxFrameSize(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getMaxFrameSizeNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting MaxFrameSize failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MaxFrameSize failed unexpectedly", statusException);
        }
    }

    public void setMaxFrameSize(long l2) {
        this.setMaxFrameSize(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getMaxIntervalFramesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxIntervalFrames");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getMaxIntervalFrames() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getMaxIntervalFramesNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node MaxIntervalFrames does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setMaxIntervalFrames(UnsignedShort unsignedShort) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getMaxIntervalFramesNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting MaxIntervalFrames failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedShort);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MaxIntervalFrames failed unexpectedly", statusException);
        }
    }

    public void setMaxIntervalFrames(int n2) {
        this.setMaxIntervalFrames(UnsignedShort.valueOf(n2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getIntervalNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Interval");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedRationalNumber getInterval() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getIntervalNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node Interval does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedRationalNumber)object;
    }

    @Override
    @Mandatory
    public void setInterval(UnsignedRationalNumber unsignedRationalNumber) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getIntervalNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting Interval failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedRationalNumber);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Interval failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

