/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.ExceptionDeviationFormat;
import com.prosysopc.ua.types.opcua.HistoricalDataConfigurationType;
import com.prosysopc.ua.types.opcua.server.AggregateConfigurationTypeNode;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.FolderTypeNode;
import com.prosysopc.ua.types.opcua.server.HistoricalDataConfigurationTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2318")
public abstract class HistoricalDataConfigurationTypeNodeBase
extends BaseObjectTypeNode
implements HistoricalDataConfigurationType {
    private static GeneratedNodeInitializer<HistoricalDataConfigurationTypeNode> KL;

    protected HistoricalDataConfigurationTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getAggregateConfigurationNode());
        this.callAfterCreateIfExists(this.getAggregateFunctionsNode());
        GeneratedNodeInitializer<HistoricalDataConfigurationTypeNode> generatedNodeInitializer = HistoricalDataConfigurationTypeNodeBase.getHistoricalDataConfigurationTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((HistoricalDataConfigurationTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<HistoricalDataConfigurationTypeNode> getHistoricalDataConfigurationTypeNodeInitializer() {
        return KL;
    }

    public static void setHistoricalDataConfigurationTypeNodeInitializer(GeneratedNodeInitializer<HistoricalDataConfigurationTypeNode> generatedNodeInitializer) {
        KL = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getSteppedNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Stepped");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isStepped() {
        UaProperty uaProperty = this.getSteppedNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node Stepped does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setStepped(Boolean bl) {
        UaProperty uaProperty = this.getSteppedNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Stepped failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(bl);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Stepped failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getStartOfOnlineArchiveNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "StartOfOnlineArchive");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public DateTime getStartOfOnlineArchive() {
        UaProperty uaProperty = this.getStartOfOnlineArchiveNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Optional
    public void setStartOfOnlineArchive(DateTime dateTime) {
        UaProperty uaProperty = this.getStartOfOnlineArchiveNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting StartOfOnlineArchive failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(dateTime);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting StartOfOnlineArchive failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getMaxTimeIntervalNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxTimeInterval");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Double getMaxTimeInterval() {
        UaProperty uaProperty = this.getMaxTimeIntervalNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Optional
    public void setMaxTimeInterval(Double d2) {
        UaProperty uaProperty = this.getMaxTimeIntervalNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxTimeInterval failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MaxTimeInterval failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getMaxCountStoredValuesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxCountStoredValues");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getMaxCountStoredValues() {
        UaProperty uaProperty = this.getMaxCountStoredValuesNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setMaxCountStoredValues(UnsignedInteger unsignedInteger) {
        UaProperty uaProperty = this.getMaxCountStoredValuesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxCountStoredValues failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MaxCountStoredValues failed unexpectedly", statusException);
        }
    }

    public void setMaxCountStoredValues(long l2) {
        this.setMaxCountStoredValues(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Optional
    public UaProperty getMinTimeIntervalNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MinTimeInterval");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Double getMinTimeInterval() {
        UaProperty uaProperty = this.getMinTimeIntervalNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Optional
    public void setMinTimeInterval(Double d2) {
        UaProperty uaProperty = this.getMinTimeIntervalNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MinTimeInterval failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MinTimeInterval failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getServerTimestampSupportedNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ServerTimestampSupported");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Boolean isServerTimestampSupported() {
        UaProperty uaProperty = this.getServerTimestampSupportedNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Optional
    public void setServerTimestampSupported(Boolean bl) {
        UaProperty uaProperty = this.getServerTimestampSupportedNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ServerTimestampSupported failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(bl);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ServerTimestampSupported failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getExceptionDeviationFormatNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ExceptionDeviationFormat");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public ExceptionDeviationFormat getExceptionDeviationFormat() {
        UaProperty uaProperty = this.getExceptionDeviationFormatNode();
        if (uaProperty == null) {
            return null;
        }
        Variant variant = uaProperty.getValue().getValue();
        return (ExceptionDeviationFormat)variant.asEnum(ExceptionDeviationFormat.class);
    }

    @Override
    @Optional
    public void setExceptionDeviationFormat(ExceptionDeviationFormat exceptionDeviationFormat) {
        UaProperty uaProperty = this.getExceptionDeviationFormatNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ExceptionDeviationFormat failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(exceptionDeviationFormat);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ExceptionDeviationFormat failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getStartOfArchiveNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "StartOfArchive");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public DateTime getStartOfArchive() {
        UaProperty uaProperty = this.getStartOfArchiveNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Optional
    public void setStartOfArchive(DateTime dateTime) {
        UaProperty uaProperty = this.getStartOfArchiveNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting StartOfArchive failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(dateTime);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting StartOfArchive failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getMaxTimeStoredValuesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxTimeStoredValues");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Double getMaxTimeStoredValues() {
        UaProperty uaProperty = this.getMaxTimeStoredValuesNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Optional
    public void setMaxTimeStoredValues(Double d2) {
        UaProperty uaProperty = this.getMaxTimeStoredValuesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxTimeStoredValues failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MaxTimeStoredValues failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getDefinitionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Definition");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getDefinition() {
        UaProperty uaProperty = this.getDefinitionNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setDefinition(String string) {
        UaProperty uaProperty = this.getDefinitionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Definition failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Definition failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getExceptionDeviationNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ExceptionDeviation");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Double getExceptionDeviation() {
        UaProperty uaProperty = this.getExceptionDeviationNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Optional
    public void setExceptionDeviation(Double d2) {
        UaProperty uaProperty = this.getExceptionDeviationNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ExceptionDeviation failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ExceptionDeviation failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public AggregateConfigurationTypeNode getAggregateConfigurationNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AggregateConfiguration");
        return (AggregateConfigurationTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public FolderTypeNode getAggregateFunctionsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AggregateFunctions");
        return (FolderTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

