/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.types.opcua.FiniteTransitionVariableType;
import com.prosysopc.ua.types.opcua.server.FiniteTransitionVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.TransitionVariableTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2767")
public abstract class FiniteTransitionVariableTypeNodeBase
extends TransitionVariableTypeNode
implements FiniteTransitionVariableType {
    private static GeneratedNodeInitializer<FiniteTransitionVariableTypeNode> KF;

    protected FiniteTransitionVariableTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<FiniteTransitionVariableTypeNode> generatedNodeInitializer = FiniteTransitionVariableTypeNodeBase.getFiniteTransitionVariableTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((FiniteTransitionVariableTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<FiniteTransitionVariableTypeNode> getFiniteTransitionVariableTypeNodeInitializer() {
        return KF;
    }

    public static void setFiniteTransitionVariableTypeNodeInitializer(GeneratedNodeInitializer<FiniteTransitionVariableTypeNode> generatedNodeInitializer) {
        KF = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Id");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getId() {
        UaProperty uaProperty = this.getIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node Id does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setId(NodeId nodeId) {
        UaProperty uaProperty = this.getIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Id failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(nodeId);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Id failed unexpectedly", statusException);
        }
    }
}

