/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedLong;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.FileType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.FileTypeCloseMethod;
import com.prosysopc.ua.types.opcua.server.FileTypeGetPositionMethod;
import com.prosysopc.ua.types.opcua.server.FileTypeNode;
import com.prosysopc.ua.types.opcua.server.FileTypeOpenMethod;
import com.prosysopc.ua.types.opcua.server.FileTypeReadMethod;
import com.prosysopc.ua.types.opcua.server.FileTypeSetPositionMethod;
import com.prosysopc.ua.types.opcua.server.FileTypeWriteMethod;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=11575")
public abstract class FileTypeNodeBase
extends BaseObjectTypeNode
implements FileType {
    private static GeneratedNodeInitializer<FileTypeNode> Kv;
    private static FileTypeReadMethod Kw;
    private static FileTypeSetPositionMethod Kx;
    private static FileTypeOpenMethod Ky;
    private static FileTypeGetPositionMethod Kz;
    private static FileTypeCloseMethod KA;
    private static FileTypeWriteMethod KB;

    protected FileTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<FileTypeNode> generatedNodeInitializer = FileTypeNodeBase.getFileTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((FileTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<FileTypeNode> getFileTypeNodeInitializer() {
        return Kv;
    }

    public static void setFileTypeNodeInitializer(GeneratedNodeInitializer<FileTypeNode> generatedNodeInitializer) {
        Kv = generatedNodeInitializer;
    }

    @Override
    @Optional
    public UaProperty getMaxByteStringLengthNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxByteStringLength");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getMaxByteStringLength() {
        UaProperty uaProperty = this.getMaxByteStringLengthNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setMaxByteStringLength(UnsignedInteger unsignedInteger) {
        UaProperty uaProperty = this.getMaxByteStringLengthNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxByteStringLength failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MaxByteStringLength failed unexpectedly", statusException);
        }
    }

    public void setMaxByteStringLength(long l2) {
        this.setMaxByteStringLength(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public UaProperty getOpenCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "OpenCount");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getOpenCount() {
        UaProperty uaProperty = this.getOpenCountNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node OpenCount does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setOpenCount(UnsignedShort unsignedShort) {
        UaProperty uaProperty = this.getOpenCountNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting OpenCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedShort);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting OpenCount failed unexpectedly", statusException);
        }
    }

    public void setOpenCount(int n2) {
        this.setOpenCount(UnsignedShort.valueOf(n2));
    }

    @Override
    @Optional
    public UaProperty getLastModifiedTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LastModifiedTime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public DateTime getLastModifiedTime() {
        UaProperty uaProperty = this.getLastModifiedTimeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Optional
    public void setLastModifiedTime(DateTime dateTime) {
        UaProperty uaProperty = this.getLastModifiedTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting LastModifiedTime failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(dateTime);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting LastModifiedTime failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getWritableNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Writable");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isWritable() {
        UaProperty uaProperty = this.getWritableNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node Writable does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setWritable(Boolean bl) {
        UaProperty uaProperty = this.getWritableNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Writable failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(bl);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Writable failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getMimeTypeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MimeType");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getMimeType() {
        UaProperty uaProperty = this.getMimeTypeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setMimeType(String string) {
        UaProperty uaProperty = this.getMimeTypeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MimeType failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MimeType failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getSizeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Size");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedLong getSize() {
        UaProperty uaProperty = this.getSizeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node Size does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedLong)object;
    }

    @Override
    @Mandatory
    public void setSize(UnsignedLong unsignedLong) {
        UaProperty uaProperty = this.getSizeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Size failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedLong);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Size failed unexpectedly", statusException);
        }
    }

    public void setSize(long l2) {
        this.setSize(UnsignedLong.valueOf(l2));
    }

    @Override
    @Mandatory
    public UaProperty getUserWritableNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "UserWritable");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isUserWritable() {
        UaProperty uaProperty = this.getUserWritableNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node UserWritable does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setUserWritable(Boolean bl) {
        UaProperty uaProperty = this.getUserWritableNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting UserWritable failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(bl);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting UserWritable failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "Read"), nodeId)) {
            return new Variant[]{new Variant(this.a(serviceContext, (UnsignedInteger)variantArray[0].getValue(), (Integer)variantArray[1].getValue()))};
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "SetPosition"), nodeId)) {
            this.a(serviceContext, (UnsignedInteger)variantArray[0].getValue(), (UnsignedLong)variantArray[1].getValue());
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "Open"), nodeId)) {
            return new Variant[]{new Variant(this.a(serviceContext, (UnsignedByte)variantArray[0].getValue()))};
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "GetPosition"), nodeId)) {
            return new Variant[]{new Variant(this.a(serviceContext, (UnsignedInteger)variantArray[0].getValue()))};
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "Close"), nodeId)) {
            this.b(serviceContext, (UnsignedInteger)variantArray[0].getValue());
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "Write"), nodeId)) {
            this.a(serviceContext, (UnsignedInteger)variantArray[0].getValue(), (ByteString)variantArray[1].getValue());
            return null;
        }
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    @Mandatory
    public UaMethod getReadNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Read");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract ByteString onRead(ServiceContext var1, UnsignedInteger var2, Integer var3) throws StatusException;

    @Override
    public ByteString read(UnsignedInteger unsignedInteger, Integer n2) throws StatusException {
        return this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, unsignedInteger, n2);
    }

    private ByteString a(ServiceContext serviceContext, UnsignedInteger unsignedInteger, Integer n2) throws StatusException {
        FileTypeReadMethod fileTypeReadMethod = FileTypeNodeBase.getReadMethodImplementation();
        if (fileTypeReadMethod != null) {
            return fileTypeReadMethod.read(serviceContext, (FileTypeNode)this, unsignedInteger, n2);
        }
        return this.onRead(serviceContext, unsignedInteger, n2);
    }

    public static FileTypeReadMethod getReadMethodImplementation() {
        return Kw;
    }

    public static void setReadMethodImplementation(FileTypeReadMethod fileTypeReadMethod) {
        Kw = fileTypeReadMethod;
    }

    @Override
    @Mandatory
    public UaMethod getSetPositionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SetPosition");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onSetPosition(ServiceContext var1, UnsignedInteger var2, UnsignedLong var3) throws StatusException;

    @Override
    public void setPosition(UnsignedInteger unsignedInteger, UnsignedLong unsignedLong) throws StatusException {
        this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, unsignedInteger, unsignedLong);
    }

    private void a(ServiceContext serviceContext, UnsignedInteger unsignedInteger, UnsignedLong unsignedLong) throws StatusException {
        FileTypeSetPositionMethod fileTypeSetPositionMethod = FileTypeNodeBase.getSetPositionMethodImplementation();
        if (fileTypeSetPositionMethod != null) {
            fileTypeSetPositionMethod.setPosition(serviceContext, (FileTypeNode)this, unsignedInteger, unsignedLong);
        } else {
            this.onSetPosition(serviceContext, unsignedInteger, unsignedLong);
        }
    }

    public static FileTypeSetPositionMethod getSetPositionMethodImplementation() {
        return Kx;
    }

    public static void setSetPositionMethodImplementation(FileTypeSetPositionMethod fileTypeSetPositionMethod) {
        Kx = fileTypeSetPositionMethod;
    }

    @Override
    @Mandatory
    public UaMethod getOpenNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Open");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract UnsignedInteger onOpen(ServiceContext var1, UnsignedByte var2) throws StatusException;

    @Override
    public UnsignedInteger open(UnsignedByte unsignedByte) throws StatusException {
        return this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, unsignedByte);
    }

    private UnsignedInteger a(ServiceContext serviceContext, UnsignedByte unsignedByte) throws StatusException {
        FileTypeOpenMethod fileTypeOpenMethod = FileTypeNodeBase.getOpenMethodImplementation();
        if (fileTypeOpenMethod != null) {
            return fileTypeOpenMethod.open(serviceContext, (FileTypeNode)this, unsignedByte);
        }
        return this.onOpen(serviceContext, unsignedByte);
    }

    public static FileTypeOpenMethod getOpenMethodImplementation() {
        return Ky;
    }

    public static void setOpenMethodImplementation(FileTypeOpenMethod fileTypeOpenMethod) {
        Ky = fileTypeOpenMethod;
    }

    @Override
    @Mandatory
    public UaMethod getGetPositionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "GetPosition");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract UnsignedLong onGetPosition(ServiceContext var1, UnsignedInteger var2) throws StatusException;

    @Override
    public UnsignedLong getPosition(UnsignedInteger unsignedInteger) throws StatusException {
        return this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, unsignedInteger);
    }

    private UnsignedLong a(ServiceContext serviceContext, UnsignedInteger unsignedInteger) throws StatusException {
        FileTypeGetPositionMethod fileTypeGetPositionMethod = FileTypeNodeBase.getGetPositionMethodImplementation();
        if (fileTypeGetPositionMethod != null) {
            return fileTypeGetPositionMethod.getPosition(serviceContext, (FileTypeNode)this, unsignedInteger);
        }
        return this.onGetPosition(serviceContext, unsignedInteger);
    }

    public static FileTypeGetPositionMethod getGetPositionMethodImplementation() {
        return Kz;
    }

    public static void setGetPositionMethodImplementation(FileTypeGetPositionMethod fileTypeGetPositionMethod) {
        Kz = fileTypeGetPositionMethod;
    }

    @Override
    @Mandatory
    public UaMethod getCloseNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Close");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onClose(ServiceContext var1, UnsignedInteger var2) throws StatusException;

    @Override
    public void close(UnsignedInteger unsignedInteger) throws StatusException {
        this.b(ServiceContext.INTERNAL_OPERATION_CONTEXT, unsignedInteger);
    }

    private void b(ServiceContext serviceContext, UnsignedInteger unsignedInteger) throws StatusException {
        FileTypeCloseMethod fileTypeCloseMethod = FileTypeNodeBase.getCloseMethodImplementation();
        if (fileTypeCloseMethod != null) {
            fileTypeCloseMethod.close(serviceContext, (FileTypeNode)this, unsignedInteger);
        } else {
            this.onClose(serviceContext, unsignedInteger);
        }
    }

    public static FileTypeCloseMethod getCloseMethodImplementation() {
        return KA;
    }

    public static void setCloseMethodImplementation(FileTypeCloseMethod fileTypeCloseMethod) {
        KA = fileTypeCloseMethod;
    }

    @Override
    @Mandatory
    public UaMethod getWriteNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Write");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onWrite(ServiceContext var1, UnsignedInteger var2, ByteString var3) throws StatusException;

    @Override
    public void write(UnsignedInteger unsignedInteger, ByteString byteString) throws StatusException {
        this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, unsignedInteger, byteString);
    }

    private void a(ServiceContext serviceContext, UnsignedInteger unsignedInteger, ByteString byteString) throws StatusException {
        FileTypeWriteMethod fileTypeWriteMethod = FileTypeNodeBase.getWriteMethodImplementation();
        if (fileTypeWriteMethod != null) {
            fileTypeWriteMethod.write(serviceContext, (FileTypeNode)this, unsignedInteger, byteString);
        } else {
            this.onWrite(serviceContext, unsignedInteger, byteString);
        }
    }

    public static FileTypeWriteMethod getWriteMethodImplementation() {
        return KB;
    }

    public static void setWriteMethodImplementation(FileTypeWriteMethod fileTypeWriteMethod) {
        KB = fileTypeWriteMethod;
    }
}

