/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.types.opcua.DataTypeDescriptionType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.DataTypeDescriptionTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=69")
public abstract class DataTypeDescriptionTypeNodeBase
extends BaseDataVariableTypeNode
implements DataTypeDescriptionType {
    private static GeneratedNodeInitializer<DataTypeDescriptionTypeNode> JA;

    protected DataTypeDescriptionTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<DataTypeDescriptionTypeNode> generatedNodeInitializer = DataTypeDescriptionTypeNodeBase.getDataTypeDescriptionTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((DataTypeDescriptionTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<DataTypeDescriptionTypeNode> getDataTypeDescriptionTypeNodeInitializer() {
        return JA;
    }

    public static void setDataTypeDescriptionTypeNodeInitializer(GeneratedNodeInitializer<DataTypeDescriptionTypeNode> generatedNodeInitializer) {
        JA = generatedNodeInitializer;
    }

    @Override
    @Optional
    public UaProperty getDataTypeVersionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DataTypeVersion");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getDataTypeVersion() {
        UaProperty uaProperty = this.getDataTypeVersionNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setDataTypeVersion(String string) {
        UaProperty uaProperty = this.getDataTypeVersionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DataTypeVersion failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DataTypeVersion failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getDictionaryFragmentNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DictionaryFragment");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public ByteString getDictionaryFragment() {
        UaProperty uaProperty = this.getDictionaryFragmentNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (ByteString)object;
    }

    @Override
    @Optional
    public void setDictionaryFragment(ByteString byteString) {
        UaProperty uaProperty = this.getDictionaryFragmentNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DictionaryFragment failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(byteString);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DictionaryFragment failed unexpectedly", statusException);
        }
    }
}

