/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.CertificateGroupFolderType;
import com.prosysopc.ua.types.opcua.server.CertificateGroupFolderTypeNode;
import com.prosysopc.ua.types.opcua.server.CertificateGroupTypeNode;
import com.prosysopc.ua.types.opcua.server.FolderTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=13813")
public abstract class CertificateGroupFolderTypeNodeBase
extends FolderTypeNode
implements CertificateGroupFolderType {
    private static GeneratedNodeInitializer<CertificateGroupFolderTypeNode> IU;

    protected CertificateGroupFolderTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getDefaultHttpsGroupNode());
        this.callAfterCreateIfExists(this.getDefaultUserTokenGroupNode());
        this.callAfterCreateIfExists(this.getDefaultApplicationGroupNode());
        GeneratedNodeInitializer<CertificateGroupFolderTypeNode> generatedNodeInitializer = CertificateGroupFolderTypeNodeBase.getCertificateGroupFolderTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((CertificateGroupFolderTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<CertificateGroupFolderTypeNode> getCertificateGroupFolderTypeNodeInitializer() {
        return IU;
    }

    public static void setCertificateGroupFolderTypeNodeInitializer(GeneratedNodeInitializer<CertificateGroupFolderTypeNode> generatedNodeInitializer) {
        IU = generatedNodeInitializer;
    }

    @Override
    @Optional
    public CertificateGroupTypeNode getDefaultHttpsGroupNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DefaultHttpsGroup");
        return (CertificateGroupTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public CertificateGroupTypeNode getDefaultUserTokenGroupNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DefaultUserTokenGroup");
        return (CertificateGroupTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public CertificateGroupTypeNode getDefaultApplicationGroupNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DefaultApplicationGroup");
        return (CertificateGroupTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

