/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.AuditConditionRespondEventType;
import com.prosysopc.ua.types.opcua.server.AuditConditionEventTypeNode;
import com.prosysopc.ua.types.opcua.server.AuditConditionRespondEventTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=8927")
public abstract class AuditConditionRespondEventTypeNodeBase
extends AuditConditionEventTypeNode
implements AuditConditionRespondEventType {
    private static GeneratedNodeInitializer<AuditConditionRespondEventTypeNode> HV;

    protected AuditConditionRespondEventTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<AuditConditionRespondEventTypeNode> generatedNodeInitializer = AuditConditionRespondEventTypeNodeBase.getAuditConditionRespondEventTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((AuditConditionRespondEventTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<AuditConditionRespondEventTypeNode> getAuditConditionRespondEventTypeNodeInitializer() {
        return HV;
    }

    public static void setAuditConditionRespondEventTypeNodeInitializer(GeneratedNodeInitializer<AuditConditionRespondEventTypeNode> generatedNodeInitializer) {
        HV = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getSelectedResponseNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SelectedResponse");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getSelectedResponse() {
        UaProperty uaProperty = this.getSelectedResponseNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node SelectedResponse does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setSelectedResponse(UnsignedInteger unsignedInteger) {
        UaProperty uaProperty = this.getSelectedResponseNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SelectedResponse failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SelectedResponse failed unexpectedly", statusException);
        }
    }

    public void setSelectedResponse(long l2) {
        this.setSelectedResponse(UnsignedInteger.valueOf(l2));
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

