/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.MethodArgumentTransformer;
import com.prosysopc.ua.MethodCallStatusException;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.ConfigurationVersionDataType;
import com.prosysopc.ua.stack.core.FieldTargetDataType;
import com.prosysopc.ua.stack.transport.AsyncResult;
import com.prosysopc.ua.types.opcua.TargetVariablesType;
import com.prosysopc.ua.types.opcua.client.SubscribedDataSetTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=15111")
public abstract class TargetVariablesTypeImplBase
extends SubscribedDataSetTypeImpl
implements TargetVariablesType {
    protected TargetVariablesTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Mandatory
    public UaProperty getTargetVariablesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TargetVariables");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public FieldTargetDataType[] getTargetVariables() {
        UaProperty uaProperty = this.getTargetVariablesNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (FieldTargetDataType[])object;
    }

    @Override
    @Mandatory
    public void setTargetVariables(FieldTargetDataType[] fieldTargetDataTypeArray) throws StatusException {
        UaProperty uaProperty = this.getTargetVariablesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting TargetVariables failed, the Optional node does not exist)");
        }
        uaProperty.setValue(fieldTargetDataTypeArray);
    }

    @Override
    @Optional
    public UaMethod getAddTargetVariablesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AddTargetVariables");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    @Override
    public StatusCode[] addTargetVariables(ConfigurationVersionDataType configurationVersionDataType, FieldTargetDataType[] fieldTargetDataTypeArray) throws MethodCallStatusException, ServiceException {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "AddTargetVariables"));
        return this.call(nodeId, new MethodArgumentTransformer<StatusCode[]>(){

            public StatusCode[] u(Variant[] variantArray) {
                return (StatusCode[])variantArray[0].getValue();
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.u(variantArray);
            }
        }, configurationVersionDataType, fieldTargetDataTypeArray);
    }

    public AsyncResult<? extends StatusCode[]> addTargetVariablesAsync(ConfigurationVersionDataType configurationVersionDataType, FieldTargetDataType[] fieldTargetDataTypeArray) {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "AddTargetVariables"));
        return this.callAsync(nodeId, new MethodArgumentTransformer<StatusCode[]>(){

            public StatusCode[] u(Variant[] variantArray) {
                return (StatusCode[])variantArray[0].getValue();
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.u(variantArray);
            }
        }, configurationVersionDataType, fieldTargetDataTypeArray);
    }

    @Override
    @Optional
    public UaMethod getRemoveTargetVariablesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveTargetVariables");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    @Override
    public StatusCode[] removeTargetVariables(ConfigurationVersionDataType configurationVersionDataType, UnsignedInteger[] unsignedIntegerArray) throws MethodCallStatusException, ServiceException {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveTargetVariables"));
        return this.call(nodeId, new MethodArgumentTransformer<StatusCode[]>(){

            public StatusCode[] u(Variant[] variantArray) {
                return (StatusCode[])variantArray[0].getValue();
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.u(variantArray);
            }
        }, configurationVersionDataType, unsignedIntegerArray);
    }

    public AsyncResult<? extends StatusCode[]> removeTargetVariablesAsync(ConfigurationVersionDataType configurationVersionDataType, UnsignedInteger[] unsignedIntegerArray) {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveTargetVariables"));
        return this.callAsync(nodeId, new MethodArgumentTransformer<StatusCode[]>(){

            public StatusCode[] u(Variant[] variantArray) {
                return (StatusCode[])variantArray[0].getValue();
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.u(variantArray);
            }
        }, configurationVersionDataType, unsignedIntegerArray);
    }
}

