/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.PubSubState;
import com.prosysopc.ua.types.opcua.PubSubStatusEventType;
import com.prosysopc.ua.types.opcua.client.SystemEventTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=15535")
public abstract class PubSubStatusEventTypeImplBase
extends SystemEventTypeImpl
implements PubSubStatusEventType {
    protected PubSubStatusEventTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Mandatory
    public UaProperty getStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "State");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public PubSubState getState() {
        UaProperty uaProperty = this.getStateNode();
        if (uaProperty == null) {
            return null;
        }
        Variant variant = uaProperty.getValue().getValue();
        return (PubSubState)variant.asEnum(PubSubState.class);
    }

    @Override
    @Mandatory
    public void setState(PubSubState pubSubState) throws StatusException {
        UaProperty uaProperty = this.getStateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting State failed, the Optional node does not exist)");
        }
        uaProperty.setValue(pubSubState);
    }

    @Override
    @Mandatory
    public UaProperty getGroupIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "GroupId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getGroupId() {
        UaProperty uaProperty = this.getGroupIdNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setGroupId(NodeId nodeId) throws StatusException {
        UaProperty uaProperty = this.getGroupIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting GroupId failed, the Optional node does not exist)");
        }
        uaProperty.setValue(nodeId);
    }

    @Override
    @Mandatory
    public UaProperty getConnectionIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ConnectionId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getConnectionId() {
        UaProperty uaProperty = this.getConnectionIdNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setConnectionId(NodeId nodeId) throws StatusException {
        UaProperty uaProperty = this.getConnectionIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ConnectionId failed, the Optional node does not exist)");
        }
        uaProperty.setValue(nodeId);
    }
}

