/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.DiagnosticsLevel;
import com.prosysopc.ua.stack.core.PubSubDiagnosticsCounterClassification;
import com.prosysopc.ua.types.opcua.PubSubDiagnosticsCounterType;
import com.prosysopc.ua.types.opcua.client.BaseDataVariableTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=19725")
public abstract class PubSubDiagnosticsCounterTypeImplBase
extends BaseDataVariableTypeImpl
implements PubSubDiagnosticsCounterType {
    protected PubSubDiagnosticsCounterTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Optional
    public UaProperty getTimeFirstChangeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TimeFirstChange");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public DateTime getTimeFirstChange() {
        UaProperty uaProperty = this.getTimeFirstChangeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Optional
    public void setTimeFirstChange(DateTime dateTime) throws StatusException {
        UaProperty uaProperty = this.getTimeFirstChangeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting TimeFirstChange failed, the Optional node does not exist)");
        }
        uaProperty.setValue(dateTime);
    }

    @Override
    @Mandatory
    public UaProperty getActiveNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Active");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isActive() {
        UaProperty uaProperty = this.getActiveNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setActive(Boolean bl) throws StatusException {
        UaProperty uaProperty = this.getActiveNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Active failed, the Optional node does not exist)");
        }
        uaProperty.setValue(bl);
    }

    @Override
    @Mandatory
    public UaProperty getDiagnosticsLevelNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DiagnosticsLevel");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DiagnosticsLevel getDiagnosticsLevel() {
        UaProperty uaProperty = this.getDiagnosticsLevelNode();
        if (uaProperty == null) {
            return null;
        }
        Variant variant = uaProperty.getValue().getValue();
        return (DiagnosticsLevel)variant.asEnum(DiagnosticsLevel.class);
    }

    @Override
    @Mandatory
    public void setDiagnosticsLevel(DiagnosticsLevel diagnosticsLevel) throws StatusException {
        UaProperty uaProperty = this.getDiagnosticsLevelNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DiagnosticsLevel failed, the Optional node does not exist)");
        }
        uaProperty.setValue(diagnosticsLevel);
    }

    @Override
    @Mandatory
    public UaProperty getClassificationNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Classification");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public PubSubDiagnosticsCounterClassification getClassification() {
        UaProperty uaProperty = this.getClassificationNode();
        if (uaProperty == null) {
            return null;
        }
        Variant variant = uaProperty.getValue().getValue();
        return (PubSubDiagnosticsCounterClassification)variant.asEnum(PubSubDiagnosticsCounterClassification.class);
    }

    @Override
    @Mandatory
    public void setClassification(PubSubDiagnosticsCounterClassification pubSubDiagnosticsCounterClassification) throws StatusException {
        UaProperty uaProperty = this.getClassificationNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Classification failed, the Optional node does not exist)");
        }
        uaProperty.setValue(pubSubDiagnosticsCounterClassification);
    }
}

