/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.types.opcua.ProgressEventType;
import com.prosysopc.ua.types.opcua.client.BaseEventTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=11436")
public abstract class ProgressEventTypeImplBase
extends BaseEventTypeImpl
implements ProgressEventType {
    protected ProgressEventTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Mandatory
    public UaProperty getProgressNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Progress");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getProgress() {
        UaProperty uaProperty = this.getProgressNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setProgress(UnsignedShort unsignedShort) throws StatusException {
        UaProperty uaProperty = this.getProgressNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Progress failed, the Optional node does not exist)");
        }
        uaProperty.setValue(unsignedShort);
    }

    @Override
    @Mandatory
    public UaProperty getContextNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Context");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Object getContext() {
        UaProperty uaProperty = this.getContextNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return object;
    }

    @Override
    @Mandatory
    public void setContext(Object object) throws StatusException {
        UaProperty uaProperty = this.getContextNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Context failed, the Optional node does not exist)");
        }
        uaProperty.setValue(object);
    }
}

