/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedLong;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.Duplex;
import com.prosysopc.ua.types.opcua.AnalogUnitType;
import com.prosysopc.ua.types.opcua.BaseDataVariableType;
import com.prosysopc.ua.types.opcua.IIeeeBaseEthernetPortType;
import com.prosysopc.ua.types.opcua.client.BaseInterfaceTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=24158")
public abstract class IIeeeBaseEthernetPortTypeImplBase
extends BaseInterfaceTypeImpl
implements IIeeeBaseEthernetPortType {
    protected IIeeeBaseEthernetPortTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Mandatory
    public AnalogUnitType getSpeedNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Speed");
        return (AnalogUnitType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedLong getSpeed() {
        AnalogUnitType analogUnitType = this.getSpeedNode();
        if (analogUnitType == null) {
            return null;
        }
        Object object = analogUnitType.getValue().getValue().getValue();
        return (UnsignedLong)object;
    }

    @Override
    @Mandatory
    public void setSpeed(UnsignedLong unsignedLong) throws StatusException {
        AnalogUnitType analogUnitType = this.getSpeedNode();
        if (analogUnitType == null) {
            throw new RuntimeException("Setting Speed failed, the Optional node does not exist)");
        }
        analogUnitType.setValue(unsignedLong);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getDuplexNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Duplex");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public Duplex getDuplex() {
        BaseDataVariableType baseDataVariableType = this.getDuplexNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Variant variant = baseDataVariableType.getValue().getValue();
        return (Duplex)variant.asEnum(Duplex.class);
    }

    @Override
    @Mandatory
    public void setDuplex(Duplex duplex) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getDuplexNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting Duplex failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(duplex);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getMaxFrameLengthNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxFrameLength");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getMaxFrameLength() {
        BaseDataVariableType baseDataVariableType = this.getMaxFrameLengthNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Object object = baseDataVariableType.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setMaxFrameLength(UnsignedShort unsignedShort) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getMaxFrameLengthNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting MaxFrameLength failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(unsignedShort);
    }
}

