/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.types.opcua.BaseDataVariableType;
import com.prosysopc.ua.types.opcua.BuildInfoType;
import com.prosysopc.ua.types.opcua.client.BaseDataVariableTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=3051")
public abstract class BuildInfoTypeImplBase
extends BaseDataVariableTypeImpl
implements BuildInfoType {
    protected BuildInfoTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getBuildDateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "BuildDate");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getBuildDate() {
        BaseDataVariableType baseDataVariableType = this.getBuildDateNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Object object = baseDataVariableType.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setBuildDate(DateTime dateTime) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getBuildDateNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting BuildDate failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(dateTime);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getProductUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ProductUri");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getProductUri() {
        BaseDataVariableType baseDataVariableType = this.getProductUriNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Object object = baseDataVariableType.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setProductUri(String string) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getProductUriNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting ProductUri failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(string);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getManufacturerNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ManufacturerName");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getManufacturerName() {
        BaseDataVariableType baseDataVariableType = this.getManufacturerNameNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Object object = baseDataVariableType.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setManufacturerName(String string) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getManufacturerNameNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting ManufacturerName failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(string);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getProductNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ProductName");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getProductName() {
        BaseDataVariableType baseDataVariableType = this.getProductNameNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Object object = baseDataVariableType.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setProductName(String string) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getProductNameNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting ProductName failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(string);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getSoftwareVersionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SoftwareVersion");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getSoftwareVersion() {
        BaseDataVariableType baseDataVariableType = this.getSoftwareVersionNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Object object = baseDataVariableType.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setSoftwareVersion(String string) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getSoftwareVersionNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting SoftwareVersion failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(string);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getBuildNumberNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "BuildNumber");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getBuildNumber() {
        BaseDataVariableType baseDataVariableType = this.getBuildNumberNode();
        if (baseDataVariableType == null) {
            return null;
        }
        Object object = baseDataVariableType.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setBuildNumber(String string) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getBuildNumberNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting BuildNumber failed, the Optional node does not exist)");
        }
        baseDataVariableType.setValue(string);
    }
}

