/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.BrokerTransportQualityOfService;
import com.prosysopc.ua.types.opcua.BrokerDataSetReaderTransportType;
import com.prosysopc.ua.types.opcua.client.DataSetReaderTransportTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=21142")
public abstract class BrokerDataSetReaderTransportTypeImplBase
extends DataSetReaderTransportTypeImpl
implements BrokerDataSetReaderTransportType {
    protected BrokerDataSetReaderTransportTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Mandatory
    public UaProperty getResourceUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ResourceUri");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getResourceUri() {
        UaProperty uaProperty = this.getResourceUriNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setResourceUri(String string) throws StatusException {
        UaProperty uaProperty = this.getResourceUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ResourceUri failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Mandatory
    public UaProperty getAuthenticationProfileUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AuthenticationProfileUri");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getAuthenticationProfileUri() {
        UaProperty uaProperty = this.getAuthenticationProfileUriNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setAuthenticationProfileUri(String string) throws StatusException {
        UaProperty uaProperty = this.getAuthenticationProfileUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting AuthenticationProfileUri failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Mandatory
    public UaProperty getRequestedDeliveryGuaranteeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RequestedDeliveryGuarantee");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public BrokerTransportQualityOfService getRequestedDeliveryGuarantee() {
        UaProperty uaProperty = this.getRequestedDeliveryGuaranteeNode();
        if (uaProperty == null) {
            return null;
        }
        Variant variant = uaProperty.getValue().getValue();
        return (BrokerTransportQualityOfService)variant.asEnum(BrokerTransportQualityOfService.class);
    }

    @Override
    @Mandatory
    public void setRequestedDeliveryGuarantee(BrokerTransportQualityOfService brokerTransportQualityOfService) throws StatusException {
        UaProperty uaProperty = this.getRequestedDeliveryGuaranteeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting RequestedDeliveryGuarantee failed, the Optional node does not exist)");
        }
        uaProperty.setValue(brokerTransportQualityOfService);
    }

    @Override
    @Mandatory
    public UaProperty getMetaDataQueueNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MetaDataQueueName");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getMetaDataQueueName() {
        UaProperty uaProperty = this.getMetaDataQueueNameNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setMetaDataQueueName(String string) throws StatusException {
        UaProperty uaProperty = this.getMetaDataQueueNameNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MetaDataQueueName failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Mandatory
    public UaProperty getQueueNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "QueueName");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getQueueName() {
        UaProperty uaProperty = this.getQueueNameNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setQueueName(String string) throws StatusException {
        UaProperty uaProperty = this.getQueueNameNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting QueueName failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }
}

