/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.EventFilter;
import com.prosysopc.ua.stack.core.HistoryEventFieldList;
import com.prosysopc.ua.stack.core.PerformUpdateType;
import com.prosysopc.ua.types.opcua.AuditHistoryEventUpdateEventType;
import com.prosysopc.ua.types.opcua.client.AuditHistoryUpdateEventTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2999")
public abstract class AuditHistoryEventUpdateEventTypeImplBase
extends AuditHistoryUpdateEventTypeImpl
implements AuditHistoryEventUpdateEventType {
    protected AuditHistoryEventUpdateEventTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Mandatory
    public UaProperty getUpdatedNodeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "UpdatedNode");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getUpdatedNode() {
        UaProperty uaProperty = this.getUpdatedNodeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setUpdatedNode(NodeId nodeId) throws StatusException {
        UaProperty uaProperty = this.getUpdatedNodeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting UpdatedNode failed, the Optional node does not exist)");
        }
        uaProperty.setValue(nodeId);
    }

    @Override
    @Mandatory
    public UaProperty getNewValuesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "NewValues");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public HistoryEventFieldList[] getNewValues() {
        UaProperty uaProperty = this.getNewValuesNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (HistoryEventFieldList[])object;
    }

    @Override
    @Mandatory
    public void setNewValues(HistoryEventFieldList[] historyEventFieldListArray) throws StatusException {
        UaProperty uaProperty = this.getNewValuesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting NewValues failed, the Optional node does not exist)");
        }
        uaProperty.setValue(historyEventFieldListArray);
    }

    @Override
    @Mandatory
    public UaProperty getPerformInsertReplaceNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "PerformInsertReplace");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public PerformUpdateType getPerformInsertReplace() {
        UaProperty uaProperty = this.getPerformInsertReplaceNode();
        if (uaProperty == null) {
            return null;
        }
        Variant variant = uaProperty.getValue().getValue();
        return (PerformUpdateType)variant.asEnum(PerformUpdateType.class);
    }

    @Override
    @Mandatory
    public void setPerformInsertReplace(PerformUpdateType performUpdateType) throws StatusException {
        UaProperty uaProperty = this.getPerformInsertReplaceNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting PerformInsertReplace failed, the Optional node does not exist)");
        }
        uaProperty.setValue(performUpdateType);
    }

    @Override
    @Mandatory
    public UaProperty getFilterNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Filter");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public EventFilter getFilter() {
        UaProperty uaProperty = this.getFilterNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (EventFilter)object;
    }

    @Override
    @Mandatory
    public void setFilter(EventFilter eventFilter) throws StatusException {
        UaProperty uaProperty = this.getFilterNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Filter failed, the Optional node does not exist)");
        }
        uaProperty.setValue(eventFilter);
    }

    @Override
    @Mandatory
    public UaProperty getOldValuesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "OldValues");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public HistoryEventFieldList[] getOldValues() {
        UaProperty uaProperty = this.getOldValuesNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (HistoryEventFieldList[])object;
    }

    @Override
    @Mandatory
    public void setOldValues(HistoryEventFieldList[] historyEventFieldListArray) throws StatusException {
        UaProperty uaProperty = this.getOldValuesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting OldValues failed, the Optional node does not exist)");
        }
        uaProperty.setValue(historyEventFieldListArray);
    }
}

