/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.gds;

import com.prosysopc.ua.MethodOutputArguments;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.BaseObjectType;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/GDS/;i=1020")
public interface KeyCredentialServiceType
extends BaseObjectType {
    public static final String RESOURCE_URI = "ResourceUri";
    public static final String PROFILE_URIS = "ProfileUris";
    public static final String SECURITY_POLICY_URIS = "SecurityPolicyUris";
    public static final String START_REQUEST = "StartRequest";
    public static final String FINISH_REQUEST = "FinishRequest";
    public static final String REVOKE = "Revoke";

    @Mandatory
    public UaProperty getResourceUriNode();

    @Mandatory
    public String getResourceUri();

    @Mandatory
    public void setResourceUri(String var1) throws StatusException;

    @Mandatory
    public UaProperty getProfileUrisNode();

    @Mandatory
    public String[] getProfileUris();

    @Mandatory
    public void setProfileUris(String[] var1) throws StatusException;

    @Optional
    public UaProperty getSecurityPolicyUrisNode();

    @Optional
    public String[] getSecurityPolicyUris();

    @Optional
    public void setSecurityPolicyUris(String[] var1) throws StatusException;

    @Mandatory
    public UaMethod getStartRequestNode();

    public NodeId startRequest(String var1, ByteString var2, String var3, NodeId[] var4) throws StatusException, ServiceException;

    @Mandatory
    public UaMethod getFinishRequestNode();

    public FinishRequestMethodOutputs finishRequest(NodeId var1, Boolean var2) throws StatusException, ServiceException;

    @Optional
    public UaMethod getRevokeNode();

    public void revoke(String var1) throws StatusException, ServiceException;

    public static class FinishRequestMethodOutputs
    implements MethodOutputArguments {
        protected String f_credentialId;
        protected ByteString f_credentialSecret;
        protected String f_certificateThumbprint;
        protected String f_securityPolicyUri;
        protected NodeId[] f_grantedRoles;

        public FinishRequestMethodOutputs(String string, ByteString byteString, String string2, String string3, NodeId[] nodeIdArray) {
            this.f_credentialId = string;
            this.f_credentialSecret = byteString;
            this.f_certificateThumbprint = string2;
            this.f_securityPolicyUri = string3;
            this.f_grantedRoles = nodeIdArray;
        }

        public String getCredentialId() {
            return this.f_credentialId;
        }

        public ByteString getCredentialSecret() {
            return this.f_credentialSecret;
        }

        public String getCertificateThumbprint() {
            return this.f_certificateThumbprint;
        }

        public String getSecurityPolicyUri() {
            return this.f_securityPolicyUri;
        }

        public NodeId[] getGrantedRoles() {
            return this.f_grantedRoles;
        }

        @Override
        public final Variant[] asVariantArray() {
            return new Variant[]{new Variant(this.f_credentialId), new Variant(this.f_credentialSecret), new Variant(this.f_certificateThumbprint), new Variant(this.f_securityPolicyUri), new Variant(this.f_grantedRoles)};
        }
    }
}

