/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.typedictionary;

import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaException;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNamespace;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.UaOptionSet;
import com.prosysopc.ua.UaQualifiedName;
import com.prosysopc.ua.client.AddressSpaceException;
import com.prosysopc.ua.client.InternalAddressSpaceAccessHelper;
import com.prosysopc.ua.client.InternalBrowseResults;
import com.prosysopc.ua.client.InternalGetNodesResults;
import com.prosysopc.ua.client.UaClient;
import com.prosysopc.ua.client.nodes.InternalClientNodesAccessHelper;
import com.prosysopc.ua.client.nodes.UaDataTypeImpl;
import com.prosysopc.ua.client.nodes.UaTypeImpl;
import com.prosysopc.ua.nodes.UaDataType;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.BrowseDirection;
import com.prosysopc.ua.stack.core.BrowseResultMask;
import com.prosysopc.ua.stack.core.DataTypeDefinition;
import com.prosysopc.ua.stack.core.DataTypeIdentifiers;
import com.prosysopc.ua.stack.core.EnumDefinition;
import com.prosysopc.ua.stack.core.EnumField;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.NodeClass;
import com.prosysopc.ua.stack.core.ObjectTypeIdentifiers;
import com.prosysopc.ua.stack.core.OptionSet;
import com.prosysopc.ua.stack.core.ReferenceDescription;
import com.prosysopc.ua.stack.core.ReferenceTypeIdentifiers;
import com.prosysopc.ua.stack.core.StructureDefinition;
import com.prosysopc.ua.stack.core.StructureField;
import com.prosysopc.ua.stack.core.VariableTypeIdentifiers;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.encoding.EncodeType;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.stack.utils.XMLFactoryCache;
import com.prosysopc.ua.typedictionary.DataTypeDictionary;
import com.prosysopc.ua.typedictionary.DynamicEnumeration;
import com.prosysopc.ua.typedictionary.DynamicStructure;
import com.prosysopc.ua.typedictionary.EnumerationSpecification;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.OptionSetSpecification;
import com.prosysopc.ua.typedictionary.OptionSetStructureSpecification;
import com.prosysopc.ua.typedictionary.OptionSpecification;
import com.prosysopc.ua.typedictionary.SimpleTypeSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.typedictionary.TypeDictionaryException;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import com.prosysopc.ua.typedictionary.c;
import com.prosysopc.ua.typedictionary.d;
import com.prosysopc.ua.typedictionary.f;
import com.prosysopc.ua.typedictionary.j;
import com.prosysopc.ua.typedictionary.l;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.xml.parsers.DocumentBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TypeDictionary {
    private static final Logger logger = LoggerFactory.getLogger(TypeDictionary.class);
    private static final Set<NodeId> EU;
    final Map<NodeId, String> EV = new ConcurrentHashMap<NodeId, String>();
    private final Map<UaNodeId, UaDataTypeSpecification> EW = new ConcurrentHashMap<UaNodeId, UaDataTypeSpecification>();
    private final Map<UaQualifiedName, EnumerationSpecification> EX = new ConcurrentHashMap<UaQualifiedName, EnumerationSpecification>();
    private final Map<String, UaNamespace> EY = new ConcurrentHashMap<String, UaNamespace>();
    private final Map<UaNodeId, Map<EncodeType, UaNodeId>> EZ = new ConcurrentHashMap<UaNodeId, Map<EncodeType, UaNodeId>>();
    private final Map<UaNodeId, UaNodeId> Fa = new ConcurrentHashMap<UaNodeId, UaNodeId>();
    private final UaClient em;
    private boolean Fb = false;
    private boolean Fc = true;
    private boolean Fd = false;
    private boolean Fe = false;

    static EnumerationSpecification a(UaNodeId uaNodeId, d d2) {
        EnumerationSpecification.Builder builder = EnumerationSpecification.builder();
        builder.setName(d2.getName());
        builder.setMappings(d2.euj());
        builder.setTypeId(uaNodeId);
        return builder.build();
    }

    static c a(String string, NodeId nodeId, NamespaceTable namespaceTable, Map<String, UaNamespace> map) throws UaException {
        try {
            String string2;
            Object object;
            Object object2;
            Object object3;
            DocumentBuilder documentBuilder = XMLFactoryCache.getDocumentBuilderFactory().newDocumentBuilder();
            InputSource inputSource = new InputSource(new StringReader(string));
            Document document = documentBuilder.parse(inputSource);
            String string3 = null;
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
            NamedNodeMap namedNodeMap = document.getDocumentElement().getAttributes();
            for (int i2 = 0; i2 < namedNodeMap.getLength(); ++i2) {
                object3 = namedNodeMap.item(i2);
                if (!(object3 instanceof Attr)) continue;
                Attr attr = (Attr)object3;
                object2 = attr.getName();
                object = attr.getValue();
                if ("TargetNamespace".equals(object2)) {
                    string3 = object;
                    string2 = namespaceTable.getUri(nodeId.getNamespaceIndex());
                    if (string2 == null) {
                        throw new TypeDictionaryException("Cannot find the NamespaceUri of the dictionary NodeId: " + nodeId + ", in the NamespaceArray");
                    }
                    if (!string2.equals(string3)) {
                        logger.debug("The (XML) TargetNamespace: {} of DataTypeDictionary node: {} does not match the node's (OPC UA) Namespace: {}, using UA namespace when resolving Enumerations", new Object[]{string3, nodeId, string2});
                    }
                    map.put(string3, UaNamespace.from(string2));
                    continue;
                }
                if (!((String)object2).startsWith("xmlns:")) continue;
                object2 = ((String)object2).substring(((String)object2).indexOf(":") + 1);
                if ("http://opcfoundation.org/BinarySchema/".equals(object)) {
                    object = "http://opcfoundation.org/UA/";
                }
                hashMap.put(object2, object);
            }
            if (string3 == null) {
                throw new TypeDictionaryException("The dictionary does not define TargetNamespace XML Attribute");
            }
            c c2 = new c(string3);
            object3 = document.getDocumentElement().getChildNodes();
            for (int i3 = 0; i3 < object3.getLength(); ++i3) {
                int n2;
                String string4;
                Object object4;
                Element element;
                Node node;
                int n3;
                NodeList nodeList;
                Object object5;
                object2 = object3.item(i3);
                if (!(object2 instanceof Element)) continue;
                object = (Element)object2;
                string2 = object.getTagName();
                if ("opc:StructuredType".equals(string2)) {
                    object5 = new l();
                    ((l)object5).aN(object.getAttribute("Name"));
                    ((l)object5).setNamespaceURI(string3);
                    nodeList = object.getChildNodes();
                    for (n3 = 0; n3 < nodeList.getLength(); ++n3) {
                        node = nodeList.item(n3);
                        if (!(node instanceof Element) || !"opc:Field".equals((element = (Element)node).getTagName())) continue;
                        object4 = new f();
                        ((f)object4).aD(element.getAttribute("Length"));
                        ((f)object4).aC(element.getAttribute("Name"));
                        ((f)object4).aF(element.getAttribute("SourceType"));
                        ((f)object4).aG(element.getAttribute("SwitchField"));
                        ((f)object4).aE(element.getAttribute("LengthField"));
                        string4 = element.getAttribute("TypeName");
                        n2 = string4.indexOf(":");
                        String string5 = string4.substring(0, n2);
                        String string6 = (String)hashMap.get(string5);
                        String string7 = string4.substring(n2 + 1);
                        ((f)object4).aH(string7);
                        ((f)object4).aI(string6);
                        ((l)object5).getFields().add((f)object4);
                    }
                    c2.euh().add((l)object5);
                    continue;
                }
                if (!"opc:EnumeratedType".equals(string2)) continue;
                object5 = new d();
                ((d)object5).setName(object.getAttribute("Name"));
                ((d)object5).setNamespaceURI(string3);
                nodeList = object.getChildNodes();
                for (n3 = 0; n3 < nodeList.getLength(); ++n3) {
                    node = nodeList.item(n3);
                    if (!(node instanceof Element) || !"opc:EnumeratedValue".equals((element = (Element)node).getTagName())) continue;
                    object4 = element.getAttribute("Name");
                    string4 = element.getAttribute("Value");
                    n2 = Integer.parseInt(string4);
                    ((d)object5).euj().put(n2, (String)object4);
                }
                c2.eug().add((d)object5);
            }
            return c2;
        }
        catch (Exception exception) {
            throw new TypeDictionaryException("Cannot parse TypeDictionary", exception);
        }
    }

    public TypeDictionary(UaClient uaClient) {
        this.em = uaClient;
    }

    public synchronized ExtensionObject binaryEncode(DynamicStructure dynamicStructure) throws EncodingException {
        if (!this.Fb) {
            try {
                this.init();
            }
            catch (Exception exception) {
                throw new EncodingException("Cannot init typedictionaries", exception);
            }
        }
        EncoderContext encoderContext = this.em.getEncoderContext();
        if (!this.em.isInitTypeDictionaryAutoUsage()) {
            encoderContext = encoderContext.shallowCopy();
            encoderContext.setDynamicDataTypeSpecificationProvider(uaNodeId -> {
                logger.debug("Trying to resolve id {} DataTypeSpecification", uaNodeId);
                UaDataTypeSpecification uaDataTypeSpecification = this.getDataTypeSpecification((UaNodeId)uaNodeId);
                if (uaDataTypeSpecification == null) {
                    logger.debug("Could not resolve id {} DataTypeSpecification", uaNodeId);
                } else {
                    logger.debug("Resolved id {} DataTypeSpecification to: {}", uaNodeId, (Object)uaDataTypeSpecification);
                }
                return uaDataTypeSpecification;
            });
        }
        return ExtensionObject.binaryEncode(dynamicStructure, encoderContext);
    }

    public synchronized void clearCaches() {
        this.EV.clear();
        this.EX.clear();
        this.EW.clear();
        this.EY.clear();
        this.EZ.clear();
        this.Fa.clear();
        this.Fb = false;
    }

    public synchronized DynamicStructure decode(ExtensionObject extensionObject) throws DecodingException {
        if (extensionObject.getEncodeType() != EncodeType.Binary) {
            throw new DecodingException("TypeDictionary currently only supports Binary decoding");
        }
        try {
            this.init();
        }
        catch (TypeDictionaryException typeDictionaryException) {
            throw new DecodingException(typeDictionaryException);
        }
        EncoderContext encoderContext = this.em.getEncoderContext();
        if (!this.em.isInitTypeDictionaryAutoUsage()) {
            encoderContext = encoderContext.shallowCopy();
            encoderContext.setDynamicDataTypeSpecificationProvider(uaNodeId -> {
                logger.debug("Trying to resolve id {} DataTypeSpecification", uaNodeId);
                UaDataTypeSpecification uaDataTypeSpecification = this.getDataTypeSpecification((UaNodeId)uaNodeId);
                if (uaDataTypeSpecification == null) {
                    logger.debug("Could not resolve id {} DataTypeSpecification", uaNodeId);
                } else {
                    logger.debug("Resolved id {} DataTypeSpecification to: {}", uaNodeId, (Object)uaDataTypeSpecification);
                }
                return uaDataTypeSpecification;
            });
        }
        return (DynamicStructure)extensionObject.decode(encoderContext, this.em.getNamespaceTable());
    }

    public UaDataTypeSpecification getDataTypeSpecification(UaNodeId uaNodeId) {
        UaDataTypeSpecification uaDataTypeSpecification = this.getStructureSpecification(uaNodeId);
        if (uaDataTypeSpecification != null) {
            return uaDataTypeSpecification;
        }
        uaDataTypeSpecification = this.getEnumerationSpecification(uaNodeId);
        if (uaDataTypeSpecification != null) {
            return uaDataTypeSpecification;
        }
        uaDataTypeSpecification = this.getOptionSetSpecification(uaNodeId);
        if (uaDataTypeSpecification != null) {
            return uaDataTypeSpecification;
        }
        return this.getSimpleTypeSpecification(uaNodeId);
    }

    public EnumerationSpecification getEnumerationSpecification(UaNodeId uaNodeId) {
        UaDataTypeSpecification uaDataTypeSpecification = this.EW.get(uaNodeId);
        if (uaDataTypeSpecification != null && !(uaDataTypeSpecification instanceof EnumerationSpecification)) {
            logger.debug("cache contained non-null UaDataTypeSpecification for type: {} that was not EnumerationSpecification, but: {}", (Object)uaNodeId, (Object)uaDataTypeSpecification);
            uaDataTypeSpecification = null;
        }
        if (uaDataTypeSpecification == null) {
            return this.z(uaNodeId);
        }
        return (EnumerationSpecification)uaDataTypeSpecification;
    }

    public OptionSetSpecification getOptionSetSpecification(UaNodeId uaNodeId) {
        UaDataTypeSpecification uaDataTypeSpecification = this.EW.get(uaNodeId);
        if (uaDataTypeSpecification != null && !(uaDataTypeSpecification instanceof OptionSetSpecification)) {
            logger.debug("cache contained non-null UaDataTypeSpecification for type: {} that was not OptionSetSpecification, but: {}", (Object)uaNodeId, (Object)uaDataTypeSpecification);
            uaDataTypeSpecification = null;
        }
        if (uaDataTypeSpecification == null) {
            return this.A(uaNodeId);
        }
        return (OptionSetSpecification)uaDataTypeSpecification;
    }

    public SimpleTypeSpecification getSimpleTypeSpecification(UaNodeId uaNodeId) {
        UaDataTypeSpecification uaDataTypeSpecification = this.EW.get(uaNodeId);
        if (uaDataTypeSpecification != null && !(uaDataTypeSpecification instanceof SimpleTypeSpecification)) {
            logger.debug("cache contained non-null UaDataTypeSpecification for type: {} that was not SimpleTypeSpecification, but: {}", (Object)uaNodeId, (Object)uaDataTypeSpecification);
            uaDataTypeSpecification = null;
        }
        if (uaDataTypeSpecification == null) {
            return this.B(uaNodeId);
        }
        return (SimpleTypeSpecification)uaDataTypeSpecification;
    }

    public StructureSpecification getStructureSpecification(UaNodeId uaNodeId) {
        UaDataTypeSpecification uaDataTypeSpecification = this.EW.get(uaNodeId);
        if (uaDataTypeSpecification != null && !(uaDataTypeSpecification instanceof StructureSpecification)) {
            logger.debug("cache contained non-null UaDataTypeSpecification for type: {} that was not StructureSpecification, but: {}", (Object)uaNodeId, (Object)uaDataTypeSpecification);
            uaDataTypeSpecification = null;
        }
        if (uaDataTypeSpecification == null) {
            return this.C(uaNodeId);
        }
        return (StructureSpecification)uaDataTypeSpecification;
    }

    public synchronized void init() throws TypeDictionaryException {
        if (!this.Fb) {
            try {
                Set<Object> set = new HashSet();
                Set<Object> set2 = new HashSet();
                this.euD();
                this.euH();
                if (this.em.getAddressSpace().isRead104Attributes()) {
                    logger.trace("1.04 attributes is true, trying resolving via DataTypeDefinition attribute");
                    set = this.euE();
                    set2 = this.euG();
                    this.euF();
                }
                if (this.em.getAddressSpace().isRead104Attributes() && set.isEmpty() && set2.isEmpty()) {
                    logger.debug("Resolved all Structure and Enumeration DataTypes via DataTypeDefinition, skipping DataTypeDictionaries");
                    this.Fb = true;
                } else {
                    HashSet<UaNamespace> hashSet = new HashSet<UaNamespace>();
                    for (UaNodeId uaNodeId : set) {
                        hashSet.add(uaNodeId.getNamespace());
                    }
                    for (UaNodeId uaNodeId : set2) {
                        hashSet.add(uaNodeId.getNamespace());
                    }
                    this.c(hashSet);
                    this.Fb = true;
                }
            }
            catch (Exception exception) {
                throw new TypeDictionaryException("Cannot init typedictionaries", exception);
            }
            logger.info("TypeDictionary initialized successfully");
        }
    }

    public boolean isUseParallelCalls() {
        return this.Fe;
    }

    public synchronized void refresh() throws TypeDictionaryException {
        this.clearCaches();
        this.init();
    }

    public void setTreatOpcStringAsOpcCharArray(boolean bl) {
        this.Fc = bl;
    }

    public void setUseParallelCalls(boolean bl) {
        this.Fe = bl;
    }

    public void setWarnOnlyOnErroneousDictionaries(boolean bl) {
        this.Fd = bl;
    }

    private void addDataTypeSpecification(UaDataTypeSpecification uaDataTypeSpecification) {
        logger.debug("Adding specification: {}", (Object)uaDataTypeSpecification);
        if (uaDataTypeSpecification instanceof StructureSpecification) {
            StructureSpecification structureSpecification = (StructureSpecification)uaDataTypeSpecification;
            if (structureSpecification.getBinaryEncodeId() == null) {
                logger.error("Encountered a StructureSpecification without binary encoding id, skipping: {}", (Object)structureSpecification);
                return;
            }
            this.EW.put(structureSpecification.getBinaryEncodeId(), structureSpecification);
            if (structureSpecification.getXmlEncodeId() != null) {
                this.EW.put(structureSpecification.getXmlEncodeId(), structureSpecification);
            }
            if (structureSpecification.getJsonEncodeId() != null) {
                this.EW.put(structureSpecification.getJsonEncodeId(), structureSpecification);
            }
        }
        this.EW.put(uaDataTypeSpecification.getTypeId(), uaDataTypeSpecification);
    }

    private EnumerationSpecification n(UaNode uaNode) {
        DataTypeDefinition dataTypeDefinition = ((UaDataType)uaNode).getDataTypeDefinition();
        if (!(dataTypeDefinition instanceof EnumDefinition)) {
            logger.debug("Did not receive EnumDefinition for the DataTypeDefinition Attribute value, got: {}", (Object)dataTypeDefinition);
            return null;
        }
        EnumDefinition enumDefinition = (EnumDefinition)dataTypeDefinition;
        EnumerationSpecification.Builder builder = EnumerationSpecification.builder();
        builder.setName(uaNode.getBrowseName().getName());
        builder.setTypeId(UaNodeId.fromLocal(uaNode.getNodeId(), this.em.getNamespaceTable()));
        for (EnumField enumField : enumDefinition.getFields()) {
            String string = enumField.getName();
            Long l2 = enumField.getValue();
            if (l2 > Long.valueOf(Integer.MAX_VALUE) && l2 < Long.valueOf(Integer.MIN_VALUE)) {
                logger.error("Encountered invalid enum value (outside of Int32 range) in type: {}, name:{}, value:{}, skipping", new Object[]{uaNode.getBrowseName().getName(), string, l2});
                continue;
            }
            builder.addMapping(l2.intValue(), string);
        }
        EnumerationSpecification enumerationSpecification = builder.build();
        this.addDataTypeSpecification(enumerationSpecification);
        return enumerationSpecification;
    }

    private OptionSetSpecification a(UaNode uaNode, UaNodeId uaNodeId) {
        DataTypeDefinition dataTypeDefinition = ((UaDataType)uaNode).getDataTypeDefinition();
        if (!(dataTypeDefinition instanceof EnumDefinition)) {
            logger.debug("Did not receive EnumDefinition for the DataTypeDefinition Attribute value, got: {}, this type might not be an OptionSet type", (Object)dataTypeDefinition);
            return null;
        }
        OptionSetSpecification.Builder<UaOptionSet.Builder> builder = OptionSetSpecification.builder();
        builder.setName(uaNode.getBrowseName().getName());
        builder.setTypeId(UaNodeId.fromLocal(uaNode.getNodeId(), this.em.getNamespaceTable()));
        builder.setBaseTypeId(uaNodeId);
        EnumDefinition enumDefinition = (EnumDefinition)dataTypeDefinition;
        for (EnumField enumField : enumDefinition.getFields()) {
            this.a(builder, enumField);
        }
        OptionSetSpecification optionSetSpecification = builder.build();
        this.addDataTypeSpecification(optionSetSpecification);
        return optionSetSpecification;
    }

    private SimpleTypeSpecification a(UaDataType uaDataType) {
        SimpleTypeSpecification simpleTypeSpecification = null;
        for (UaDataType uaDataType2 = (UaDataType)uaDataType.getSuperType(); uaDataType2 != null && (uaDataType2.getNodeId().getNamespaceIndex() != 0 || (simpleTypeSpecification = this.em.getEncoderContext().getSimpleTypeSpecification(UaNodeId.fromLocal(uaDataType2.getNodeId(), this.em.getNamespaceTable()))) == null); uaDataType2 = (UaDataType)uaDataType2.getSuperType()) {
        }
        if (simpleTypeSpecification == null) {
            logger.warn("Cannot resolve super type SimpleTypeSpecification for type: {}", (Object)uaDataType.getNodeId());
            return null;
        }
        SimpleTypeSpecification.Builder builder = SimpleTypeSpecification.builder();
        builder.setName(uaDataType.getBrowseName().getName());
        builder.setTypeId(UaNodeId.fromLocal(uaDataType.getNodeId(), this.em.getNamespaceTable()));
        builder.setJavaClass(simpleTypeSpecification.getJavaClass());
        builder.setBaseTypeId(simpleTypeSpecification.getBaseTypeId());
        SimpleTypeSpecification simpleTypeSpecification2 = builder.build();
        this.addDataTypeSpecification(simpleTypeSpecification2);
        return simpleTypeSpecification2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private StructureSpecification b(UaDataType uaDataType) throws ServiceException, AddressSpaceException {
        Object object;
        Object object2;
        boolean bl;
        DataTypeDefinition dataTypeDefinition = uaDataType.getDataTypeDefinition();
        if (dataTypeDefinition instanceof StructureDefinition) {
            bl = false;
        } else {
            if (!(dataTypeDefinition instanceof EnumDefinition)) {
                logger.debug("Did not receive StructureDefinition (or EnumDefinition for 'OptionSet'-style Structures) for the DataTypeDefinition Attribute value, got: {}", (Object)dataTypeDefinition);
                return null;
            }
            if (uaDataType.inheritsFromAny(UaIds.OptionSet) == null) {
                logger.debug("Got EnumDefinition for Structure type: {}, but it doesn't inherit from 'OptionSet' Structure type, skipping", (Object)uaDataType.getNodeId());
                return null;
            }
            bl = true;
        }
        Map<EncodeType, UaNodeId> map = this.c(uaDataType);
        if (!bl) {
            object2 = StructureSpecification.builder();
            object = (StructureDefinition)dataTypeDefinition;
            if (!map.containsKey((Object)EncodeType.Binary)) {
                logger.debug("Could not find Default Binary encoding node for node: {}, assuming DefaultEncoding is Binary", (Object)uaDataType.getNodeId());
                map.put(EncodeType.Binary, UaNodeId.fromLocal(((StructureDefinition)object).getDefaultEncodingId(), this.em.getNamespaceTable()));
            }
            switch (((StructureDefinition)object).getStructureType()) {
                case Structure: {
                    object2.setStructureType(StructureSpecification.StructureType.NORMAL);
                    break;
                }
                case StructureWithOptionalFields: {
                    object2.setStructureType(StructureSpecification.StructureType.OPTIONAL);
                    break;
                }
                case Union: {
                    object2.setStructureType(StructureSpecification.StructureType.UNION);
                    break;
                }
                case StructureWithSubtypedValues: {
                    object2.setStructureType(StructureSpecification.StructureType.SUBTYPES);
                    break;
                }
                case UnionWithSubtypedValues: {
                    object2.setStructureType(StructureSpecification.StructureType.UNION_SUBTYPES);
                    break;
                }
                default: {
                    logger.error("Unknown enum constant: {}", (Object)((StructureDefinition)object).getStructureType());
                    return null;
                }
            }
            for (StructureField structureField : ((StructureDefinition)object).getFields()) {
                this.a((StructureDefinition)object, (StructureSpecification.Builder<?>)object2, structureField);
            }
        } else {
            object = OptionSetStructureSpecification.builder();
            object.setStructureType(StructureSpecification.StructureType.NORMAL);
            object.setBaseTypeId(UaIds.OptionSet);
            object.addField(OptionSet.Fields.Value);
            object.addField(OptionSet.Fields.ValidBits);
            EnumDefinition enumDefinition = (EnumDefinition)dataTypeDefinition;
            for (EnumField enumField : enumDefinition.getFields()) {
                this.a((OptionSetSpecification.Builder<?>)object, enumField);
            }
            object2 = object;
        }
        object2.setName(uaDataType.getBrowseName().getName());
        object2.setTypeId(UaNodeId.fromLocal(uaDataType.getNodeId(), this.em.getNamespaceTable()));
        object2.setBinaryEncodeId(map.get((Object)EncodeType.Binary));
        object2.setXmlEncodeId(map.get((Object)EncodeType.Xml));
        object2.setJsonEncodeId(map.get((Object)EncodeType.Json));
        object = object2.build();
        this.addDataTypeSpecification((UaDataTypeSpecification)object);
        return object;
    }

    private EnumerationSpecification z(UaNodeId uaNodeId) {
        try {
            UaNode uaNode = this.em.getAddressSpace().getNode(uaNodeId.asNodeId(this.em.getNamespaceTable()));
            if (uaNode instanceof UaDataType) {
                if (((UaDataType)uaNode).inheritsFrom(Identifiers.Enumeration)) {
                    return this.n(uaNode);
                }
                logger.debug("Skipping resolving id {} to EnumerationSpecification via DataTypeDefinition Attribute, since it is not an Enumeration type", (Object)uaNodeId);
                return null;
            }
            logger.debug("Could not resolve id {} to EnumerationSpecification via DataTypeDefinition Attribute, it is not a DataType node", (Object)uaNodeId);
        }
        catch (Exception exception) {
            logger.debug("Could not resolve id {} to EnumerationSpecification via DataTypeDefinition Attribute", (Object)uaNodeId, (Object)exception);
        }
        return null;
    }

    private String p(NodeId nodeId) throws UaException {
        try {
            ByteString byteString = (ByteString)this.em.readValue(nodeId).getValue().getValue();
            if (byteString == null || byteString.getLength() == 0) {
                return null;
            }
            String string = new String(ByteString.asByteArray(byteString), "UTF-8");
            return string;
        }
        catch (Exception exception) {
            throw new TypeDictionaryException("Cannot read DataTypeDictionary", exception);
        }
    }

    private OptionSetSpecification A(UaNodeId uaNodeId) {
        try {
            UaNode uaNode = this.em.getAddressSpace().getNode(uaNodeId.asNodeId(this.em.getNamespaceTable()));
            if (uaNode instanceof UaDataType) {
                UaNodeId uaNodeId2 = ((UaDataType)uaNode).inheritsFromAny(UaIds.Byte, UaIds.UInt16, UaIds.UInt32, UaIds.UInt64);
                if (uaNodeId2 != null) {
                    return this.a(uaNode, uaNodeId2);
                }
                logger.debug("Skipping resolving id {} to OptionSetSpecification via DataTypeDefinition Attribute, since it is not an OptionSetSpecification type", (Object)uaNodeId);
                return null;
            }
            logger.debug("Could not resolve id {} to OptionSetSpecification via DataTypeDefinition Attribute, it is not a DataType node", (Object)uaNodeId);
        }
        catch (Exception exception) {
            logger.debug("Could not resolve id {} to OptionSetSpecification via DataTypeDefinition Attribute", (Object)uaNodeId, (Object)exception);
        }
        return null;
    }

    private void a(OptionSetSpecification.Builder<?> builder, EnumField enumField) {
        Long l2 = enumField.getValue();
        OptionSpecification.Builder builder2 = OptionSpecification.builder();
        builder2.setBitPosition(l2.intValue());
        builder2.setDescription(enumField.getDescription());
        builder2.setName(enumField.getName());
        builder.addOptions(builder2.build());
    }

    private void a(StructureDefinition structureDefinition, StructureSpecification.Builder<?> builder, StructureField structureField) throws ServiceException, AddressSpaceException {
        Object object;
        FieldSpecification.Builder builder2 = FieldSpecification.builder();
        if (structureField.getArrayDimensions() != null) {
            long[] lArray = new long[structureField.getArrayDimensions().length];
            for (int i2 = 0; i2 < structureField.getArrayDimensions().length; ++i2) {
                object = structureField.getArrayDimensions()[i2];
                lArray[i2] = ((UnsignedInteger)object).longValue() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (long)((UnsignedInteger)object).intValue();
            }
            builder2.setArrayDimensions(UaArrayDimensions.valueOf(lArray));
        }
        builder2.setDataTypeId(UaNodeId.fromLocal(structureField.getDataType(), this.em.getNamespaceTable()));
        builder2.setDescription(structureField.getDescription() == null ? null : structureField.getDescription().getText());
        boolean bl = false;
        switch (structureDefinition.getStructureType()) {
            case StructureWithSubtypedValues: 
            case UnionWithSubtypedValues: {
                builder2.setIsOptional(false);
                bl = structureField.getIsOptional();
                builder2.setAllowSubTypes(bl);
                break;
            }
            default: {
                builder2.setIsOptional(structureField.getIsOptional());
                builder2.setAllowSubTypes(false);
            }
        }
        builder2.setMaxStringLength(structureField.getMaxStringLength().intValue());
        builder2.setName(structureField.getName());
        builder2.setValueRank(structureField.getValueRank());
        UaDataType uaDataType = this.em.getAddressSpace().getDataType(structureField.getDataType());
        object = bl ? (uaDataType.inheritsFrom(Identifiers.Structure) ? ExtensionObject.class : Object.class) : uaDataType.getJavaClass();
        if (object == null) {
            throw new RuntimeException("Cannot resolve Java Class for DataType node: " + uaDataType);
        }
        logger.trace("class: {}, for id: {}", object, (Object)structureField.getDataType());
        if (structureField.getValueRank() != -1) {
            if (structureField.getValueRank() < 1) {
                logger.error("Encountered non-valid ValueRank while processing DataTypeDefinition {}", (Object)structureDefinition);
            } else {
                object = MultiDimensionArrayUtils.arrayClassOf(object, structureField.getValueRank());
            }
        }
        builder2.setJavaClass((Class<?>)object);
        builder.addField(builder2.build());
    }

    /*
     * WARNING - void declaration
     */
    private void c(Set<UaNamespace> set) throws Exception {
        boolean bl;
        Object object;
        boolean bl2;
        if (set.isEmpty()) {
            logger.debug("Resolving all DataTypeDictionaries");
            bl2 = true;
        } else {
            logger.debug("Resolving DataTypeDictionaries for namespaces: {}", set);
            bl2 = false;
        }
        HashMap<UaQualifiedName, l> hashMap = new HashMap<UaQualifiedName, l>();
        HashMap<UaQualifiedName, d> hashMap2 = new HashMap<UaQualifiedName, d>();
        HashMap<NodeId, String> hashMap3 = new HashMap<NodeId, String>();
        InternalBrowseResults internalBrowseResults = InternalAddressSpaceAccessHelper.internalBrowseWithNodeIds(this.Fe, this.em.getAddressSpace(), new HashSet<NodeId>(Arrays.asList(Identifiers.OPCBinarySchema_TypeSystem)), BrowseDirection.Forward, ReferenceTypeIdentifiers.HasComponent, true, NodeClass.ALL, BrowseResultMask.ALL);
        HashSet<NodeId> hashSet = new HashSet<NodeId>();
        for (ReferenceDescription collection2 : internalBrowseResults.getReferences(Identifiers.OPCBinarySchema_TypeSystem)) {
            NodeId nodeId;
            try {
                nodeId = this.em.getNamespaceTable().toNodeId(collection2.getNodeId());
            }
            catch (Exception exception) {
                logger.error("Cannot convert DataTypeDictionary node reference target {} to NodeId, skipping dictionary", (Object)collection2.getNodeId());
                continue;
            }
            String string = this.em.getNamespaceTable().getUri(nodeId.getNamespaceIndex());
            UaNamespace uaNamespace = UaNamespace.from(string);
            if (!this.em.getKnownDataTypeDictionary().knownAddressSpaceNamespaces().contains(string)) {
                if (!bl2 && !set.contains(uaNamespace)) {
                    logger.debug("Skipping dictionary for ns: {}, already resolved via DataTypeDefinitions", (Object)uaNamespace);
                    continue;
                }
                object = this.p(nodeId);
                if (object == null) {
                    logger.warn("Encountered null or empty DataTypeDictionary NodeId: {}, skipping", (Object)nodeId);
                    continue;
                }
                this.EV.put(nodeId, (String)object);
                c c2 = TypeDictionary.a((String)object, nodeId, this.em.getNamespaceTable(), this.EY);
                hashMap3.put(nodeId, c2.euf());
                for (l l2 : c2.euh()) {
                    hashMap.put(UaQualifiedName.from(l2.getNamespaceURI(), l2.euC()), l2);
                }
                for (d d2 : c2.eug()) {
                    hashMap2.put(UaQualifiedName.from(d2.getNamespaceURI(), d2.getName()), d2);
                }
                hashSet.add(nodeId);
                continue;
            }
            logger.debug("Skipping dictionary for ns: {}, already known via codegen", (Object)uaNamespace);
        }
        if (hashSet.isEmpty()) {
            logger.debug("Didn't find any dictionary, whose data would be unknown");
            return;
        }
        HashMap hashMap4 = new HashMap();
        if (!hashMap2.isEmpty()) {
            Set<UaTypeImpl> set2 = this.a((UaTypeImpl)this.em.getAddressSpace().getType(DataTypeIdentifiers.Enumeration));
            for (UaTypeImpl uaTypeImpl : set2) {
                UaNodeId uaNodeId = UaNodeId.fromLocal(uaTypeImpl.getNodeId(), this.em.getNamespaceTable());
                object = UaQualifiedName.from(uaNodeId.getNamespaceUri(), uaTypeImpl.getBrowseName().getName());
                hashMap4.put(object, uaNodeId);
            }
        }
        for (Map.Entry entry : hashMap2.entrySet()) {
            void var12_35;
            d d3 = (d)entry.getValue();
            UaNodeId uaNodeId = (UaNodeId)hashMap4.get(entry.getKey());
            if (uaNodeId == null) {
                object = this.EY.get(((UaQualifiedName)entry.getKey()).getNamespaceUri());
                if (object != null) {
                    UaQualifiedName uaQualifiedName = UaQualifiedName.from((UaNamespace)object, ((UaQualifiedName)entry.getKey()).getName());
                    UaNodeId uaNodeId2 = (UaNodeId)hashMap4.get(uaQualifiedName);
                    if (uaNodeId2 != null) {
                        logger.debug("Fallback-resolved: {} as {} and obtained Enumeration type id: {}", new Object[]{entry.getKey(), uaQualifiedName, uaNodeId2});
                    }
                } else {
                    logger.debug("The XML -> UA namespace mapping for: {} is null", (Object)((UaQualifiedName)entry.getKey()).getNamespaceUri());
                }
            }
            if (var12_35 == null) {
                logger.warn("Skipping Dictionary enum: {}, as matching NodeId for the type could not be resolved", entry.getKey());
                continue;
            }
            object = TypeDictionary.a((UaNodeId)var12_35, d3);
            this.EX.put((UaQualifiedName)entry.getKey(), (EnumerationSpecification)object);
            this.addDataTypeSpecification((UaDataTypeSpecification)object);
        }
        CopyOnWriteArrayList<j> copyOnWriteArrayList = new CopyOnWriteArrayList<j>();
        InternalBrowseResults internalBrowseResults2 = InternalAddressSpaceAccessHelper.internalBrowseWithNodeIds(this.Fe, this.em.getAddressSpace(), hashSet, BrowseDirection.Forward, ReferenceTypeIdentifiers.HasComponent, true, EnumSet.of(NodeClass.Variable), EnumSet.allOf(BrowseResultMask.class));
        for (NodeId nodeId : hashSet) {
            Object object2;
            Object object3;
            Comparable<UaNodeId> comparable;
            Comparable<NodeId> comparable2;
            List<ReferenceDescription> list;
            List<ExpandedNodeId> list2;
            Object object42;
            Object object52;
            object = (String)hashMap3.get(nodeId);
            List<ReferenceDescription> list3 = internalBrowseResults2.getReferences(nodeId);
            HashSet<NodeId> hashSet2 = new HashSet<NodeId>();
            for (Object object52 : list3) {
                try {
                    hashSet2.add(this.em.getNamespaceTable().toNodeId(((ReferenceDescription)object52).getNodeId()));
                }
                catch (Exception exception) {
                    logger.error("Cannot convert ExpandedNodeId for a DataTypeDictionary Description node to NodeId, ignoring", (Throwable)exception);
                }
            }
            if (hashSet2.isEmpty()) {
                logger.warn("Skipping dictionary node {} with NameSpaceUri Property Value: {}, as it does not contain any Descriptions nodes", (Object)nodeId, object);
                continue;
            }
            logger.debug("Resolving all references of Description nodes: {}", hashSet2);
            InternalBrowseResults internalBrowseResults3 = InternalAddressSpaceAccessHelper.internalBrowseAllDataWithNodeIds(this.Fe, this.em.getAddressSpace(), hashSet2);
            logger.debug("Number of ServiceRequests needed, Browse: {}, BrowseNext: {}", (Object)internalBrowseResults3.getNumberOfBrowseRequests(), (Object)internalBrowseResults3.getNumberOfBrowseNextRequests());
            logger.debug("Resolving all Description nodes: {}", hashSet2);
            object52 = InternalAddressSpaceAccessHelper.internalGetNodesWithNodeIdsAndPreBrowseData(this.Fe, this.em.getAddressSpace(), hashSet2, internalBrowseResults3);
            logger.debug("Number of ServiceRequests needed, Read: {}, Browse: {}, BrowseNext: {}", new Object[]{((InternalGetNodesResults)object52).getReadCalls(), ((InternalGetNodesResults)object52).getBrowseCalls(), ((InternalGetNodesResults)object52).getBrowseNextCalls()});
            HashSet<NodeId> hashSet3 = new HashSet<NodeId>();
            HashMap<Iterator<UaNode>, NodeId> hashMap5 = new HashMap<Iterator<UaNode>, NodeId>();
            HashMap<NodeId, Comparable<NodeId>> hashMap6 = new HashMap<NodeId, Comparable<NodeId>>();
            HashSet<NodeId> hashSet4 = new HashSet<NodeId>();
            for (Object object42 : hashSet2) {
                void var24_75;
                list2 = internalBrowseResults3.findExactMatchesAsList((NodeId)object42, NodeClass.Object, Boolean.FALSE, ReferenceTypeIdentifiers.HasDescription);
                if (list2 == null || list2.size() == 0) {
                    Object var24_72 = null;
                } else if (list2.size() == 1) {
                    ExpandedNodeId expandedNodeId = list2.get(0);
                } else {
                    logger.warn("Description node {} has more than one inverse HasDescription references: {}, selecting first one", object42, list2);
                    ExpandedNodeId expandedNodeId = list2.get(0);
                }
                if (var24_75 == null) {
                    if (this.Fd) {
                        logger.warn("Ignoring DataTypeDescription node {}, it does not have an inverse HasDescription reference", object42);
                        continue;
                    }
                    throw new TypeDictionaryException("Cannot initialize, node: " + object42 + " , does not have inverse HasDescription Reference");
                }
                list = var24_75;
                comparable2 = this.em.getNamespaceTable().toNodeId((ExpandedNodeId)((Object)list));
                comparable = UaNodeId.fromLocal((ExpandedNodeId)((Object)list), this.em.getNamespaceTable());
                object3 = this.Fa.get(comparable);
                if (object3 != null) {
                    NodeId nodeId2 = ((UaNodeId)object3).asNodeId(this.em.getNamespaceTable());
                    hashMap6.put((NodeId)comparable2, nodeId2);
                    hashSet4.add(nodeId2);
                } else {
                    hashSet3.add((NodeId)comparable2);
                }
                hashMap5.put((Iterator<UaNode>)object42, (NodeId)comparable2);
            }
            if (hashSet3.isEmpty()) {
                logger.debug("All EncodingsIds were found in cache");
            } else {
                logger.debug("Number Encodings to resolve: {}, ids: {}", (Object)hashSet3.size(), hashSet3);
                object2 = InternalAddressSpaceAccessHelper.internalBrowseWithNodeIds(this.Fe, this.em.getAddressSpace(), hashSet3, BrowseDirection.Inverse, Identifiers.HasEncoding, true, EnumSet.of(NodeClass.DataType), EnumSet.allOf(BrowseResultMask.class));
                logger.debug("Number of ServiceRequests needed, Browse: {}, BrowseNext: {}", (Object)((InternalBrowseResults)object2).getNumberOfBrowseRequests(), (Object)((InternalBrowseResults)object2).getNumberOfBrowseNextRequests());
                for (NodeId nodeId3 : hashSet3) {
                    list = ((InternalBrowseResults)object2).getReferences(nodeId3);
                    if (list == null || list.size() == 0) {
                        list2 = null;
                    } else if (list.size() == 1) {
                        list2 = list.get(0);
                    } else {
                        logger.warn("Encoding node {} has more than one inverse HasEncoding references: {}, selecting first one", (Object)nodeId3, list);
                        list2 = (ReferenceDescription)list.get(0);
                    }
                    if (list2 == null) {
                        if (this.Fd) {
                            logger.warn("Ignoring Encoding node {}, it does not have an inverse HasEncoding reference", (Object)nodeId3);
                            continue;
                        }
                        throw new TypeDictionaryException("Cannot initialize, node: " + nodeId3 + " , does not have inverse HasEncoding Reference");
                    }
                    comparable2 = ((ReferenceDescription)((Object)list2)).getNodeId();
                    comparable = this.em.getNamespaceTable().toNodeId((ExpandedNodeId)comparable2);
                    hashSet4.add((NodeId)comparable);
                    hashMap6.put(nodeId3, comparable);
                }
            }
            logger.debug("Resolving all needed DataTypes: {}", hashSet4);
            object2 = InternalAddressSpaceAccessHelper.internalGetNodesWithNodeIds(this.Fe, this.em.getAddressSpace(), hashSet4);
            logger.debug("Number of ServiceRequests needed, Read: {}, Browse: {}, BrowseNext: {}", new Object[]{((InternalGetNodesResults)object2).getReadCalls(), ((InternalGetNodesResults)object2).getBrowseCalls(), ((InternalGetNodesResults)object2).getBrowseNextCalls()});
            object42 = ((InternalGetNodesResults)object52).getRawMap().values().iterator();
            while (object42.hasNext()) {
                UaNode uaNode = object42.next();
                list2 = (UaVariable)uaNode;
                list = (String)list2.getValue().getValue().getValue();
                comparable2 = (NodeId)hashMap5.get(uaNode.getNodeId());
                if (comparable2 == null) {
                    if (this.Fd) {
                        logger.warn("Could not find Encoding node from Description node: {}, it does not have an inverse HasDescription reference", (Object)uaNode.getNodeId());
                        continue;
                    }
                    throw new TypeDictionaryException("Cannot initialize, node: " + list2 + " , does not have inverse HasDescription Reference");
                }
                comparable = (NodeId)hashMap6.get(comparable2);
                if (comparable == null) {
                    if (this.Fd) {
                        logger.warn("Could not find DataType node from Encoding node: {}, it does not have an inverse HasEncoding reference", (Object)comparable2);
                        continue;
                    }
                    throw new TypeDictionaryException("Cannot initialize, node: " + comparable2 + " , does not have inverse HasEncoding Reference");
                }
                object3 = (UaDataType)((InternalGetNodesResults)object2).getNode((NodeId)comparable);
                if (object3 == null) {
                    if (this.Fd) {
                        logger.warn("Could not get the DataType node: {},", (Object)comparable);
                        continue;
                    }
                    throw new TypeDictionaryException("Cannot initialize, could not get the DataType node: " + comparable);
                }
                boolean bl3 = object3.inheritsFrom(Identifiers.Union);
                l l3 = (l)hashMap.get(UaQualifiedName.from((String)object, (String)((Object)list)));
                UaNodeId uaNodeId = UaNodeId.fromLocal(object3.getNodeId(), this.em.getNamespaceTable());
                UaNodeId uaNodeId3 = UaNodeId.fromLocal(comparable2, this.em.getNamespaceTable());
                UaNodeId uaNodeId4 = null;
                DataTypeDictionary dataTypeDictionary = this.em.getKnownDataTypeDictionary();
                Object object6 = object;
                if (l3 == null) {
                    if (Boolean.TRUE.equals(object3.getIsAbstract())) {
                        logger.warn("DataTypeDictionary contains Description and Encoding nodes for an abstract type {}, but does not contain dictionary XML data for it, skipping type", (Object)uaNodeId);
                        continue;
                    }
                    logger.error("DataTypeDictionary contains Description and Encoding nodes for a type {}, but does not contain dictionary XML data for it", (Object)uaNodeId);
                }
                j j2 = new j(l3, uaNodeId, uaNodeId3, uaNodeId4, dataTypeDictionary, bl3, (String)((Object)list), (String)object6);
                copyOnWriteArrayList.add(j2);
            }
        }
        HashMap<UaQualifiedName, StructureSpecification> hashMap7 = new HashMap<UaQualifiedName, StructureSpecification>();
        boolean bl4 = true;
        while (bl) {
            bl = false;
            for (j j3 : copyOnWriteArrayList) {
                try {
                    this.a(j3, hashMap7, hashMap4);
                    bl = true;
                    copyOnWriteArrayList.remove(j3);
                }
                catch (Exception exception) {}
            }
        }
        if (!copyOnWriteArrayList.isEmpty()) {
            object = new ArrayList();
            for (j j4 : copyOnWriteArrayList) {
                object.add(j4.typeId);
            }
            logger.warn("Could not parse the following Structure definitions from typedictionaries: {}", object);
        }
    }

    private void a(UaNodeId uaNodeId, Set<UaDataTypeImpl> set) throws Exception {
        this.b(uaNodeId, set);
    }

    private void b(UaNodeId uaNodeId, Set<UaDataTypeImpl> set) throws ServiceResultException, UaException {
        UaDataTypeImpl uaDataTypeImpl = (UaDataTypeImpl)this.em.getAddressSpace().getType(uaNodeId.asNodeId(this.em.getNamespaceTable()));
        for (UaTypeImpl uaTypeImpl : this.a(uaDataTypeImpl)) {
            set.add((UaDataTypeImpl)uaTypeImpl);
        }
    }

    private void d(Set<UaDataTypeImpl> set) throws ServiceException, StatusException {
        HashMap<EncodeType, UaNodeId> hashMap;
        HashSet<NodeId> hashSet = new HashSet<NodeId>();
        for (UaDataTypeImpl object22 : set) {
            UaNodeId uaNodeId = InternalClientNodesAccessHelper.internalGetCachedEncodingsIdFromUaDataTypeImpl(object22, EncodeType.Binary);
            if (uaNodeId == null) {
                hashSet.add(object22.getNodeId());
                continue;
            }
            UaNodeId uaNodeId2 = UaNodeId.fromLocal(object22.getNodeId(), this.em.getNamespaceTable());
            hashMap = new HashMap<EncodeType, UaNodeId>();
            hashMap.put(EncodeType.Binary, uaNodeId);
            hashMap.put(EncodeType.Xml, InternalClientNodesAccessHelper.internalGetCachedEncodingsIdFromUaDataTypeImpl(object22, EncodeType.Xml));
            hashMap.put(EncodeType.Json, InternalClientNodesAccessHelper.internalGetCachedEncodingsIdFromUaDataTypeImpl(object22, EncodeType.Json));
            this.EZ.put(uaNodeId2, hashMap);
            for (Map.Entry entry : hashMap.entrySet()) {
                if (entry.getValue() == null) continue;
                this.Fa.put((UaNodeId)entry.getValue(), uaNodeId2);
            }
        }
        if (hashSet.isEmpty()) {
            logger.debug("All encodings were cached as part DataType getNodes, can skip Browsing of EncodingIds");
            return;
        }
        HashSet hashSet2 = new HashSet();
        for (NodeId nodeId : hashSet) {
            StructureSpecification structureSpecification = this.em.getEncoderContext().getStructureSpecification(UaNodeId.fromLocal(nodeId, this.em.getNamespaceTable()));
            if (structureSpecification == null) continue;
            hashSet2.add(structureSpecification.getTypeId().asNodeId(this.em.getNamespaceTable()));
        }
        if (!hashSet2.isEmpty()) {
            hashSet.removeAll(hashSet2);
        }
        if (hashSet.isEmpty()) {
            logger.debug("Didn't find all encodings from DataType getNodes, but missing ones were found from existing StructureSpecifications, ids: {}", (Object)hashSet2);
            return;
        }
        logger.debug("Resolving encoding ids of Structures, number of datatypes with non-cached encodings: {}, ids: {}", (Object)hashSet.size(), hashSet);
        InternalBrowseResults internalBrowseResults = InternalAddressSpaceAccessHelper.internalBrowseWithNodeIds(this.Fe, this.em.getAddressSpace(), hashSet, BrowseDirection.Forward, ReferenceTypeIdentifiers.HasEncoding, true, EnumSet.of(NodeClass.Object), BrowseResultMask.ALL);
        logger.debug("Number of ServiceRequests needed, Browse: {}, BrowseNext: {}", (Object)internalBrowseResults.getNumberOfBrowseRequests(), (Object)internalBrowseResults.getNumberOfBrowseNextRequests());
        for (NodeId nodeId : internalBrowseResults.getGoodResults().keySet()) {
            hashMap = new HashMap();
            for (ReferenceDescription referenceDescription : internalBrowseResults.getReferences(nodeId)) {
                if (referenceDescription.getNodeId() != null && !referenceDescription.getNodeId().isLocal()) continue;
                Object object = referenceDescription.getBrowseName();
                UaNodeId uaNodeId = UaNodeId.fromLocal(referenceDescription.getNodeId(), this.em.getNamespaceTable());
                if ("Default Binary".equals(((QualifiedName)object).getName())) {
                    hashMap.put(EncodeType.Binary, uaNodeId);
                }
                if ("Default XML".equals(((QualifiedName)object).getName())) {
                    hashMap.put(EncodeType.Xml, uaNodeId);
                }
                if (!"Default JSON".equals(((QualifiedName)object).getName())) continue;
                hashMap.put(EncodeType.Json, uaNodeId);
            }
            UaNodeId uaNodeId = UaNodeId.fromLocal(nodeId, this.em.getNamespaceTable());
            this.EZ.put(uaNodeId, hashMap);
            for (Object object : hashMap.entrySet()) {
                this.Fa.put((UaNodeId)object.getValue(), uaNodeId);
            }
        }
    }

    private void euD() throws Exception {
        InternalBrowseResults internalBrowseResults;
        logger.debug("Resolving all types, starting ids size: {}, ids: {}", (Object)EU.size(), EU);
        HashSet<NodeId> hashSet = new HashSet<NodeId>(EU);
        HashSet<NodeId> hashSet2 = new HashSet<NodeId>();
        ArrayList<InternalBrowseResults> arrayList = new ArrayList<InternalBrowseResults>();
        while (!hashSet.isEmpty()) {
            logger.trace("Unvisited count: {}, nodes: {}", (Object)hashSet.size(), hashSet);
            hashSet2.addAll(hashSet);
            internalBrowseResults = InternalAddressSpaceAccessHelper.internalBrowseAllDataWithNodeIds(this.Fe, this.em.getAddressSpace(), hashSet);
            arrayList.add(internalBrowseResults);
            hashSet.clear();
            for (List list : internalBrowseResults.asRawMap().values()) {
                for (ReferenceDescription referenceDescription : list) {
                    NodeId nodeId;
                    if (!ReferenceTypeIdentifiers.HasSubtype.equals(referenceDescription.getReferenceTypeId()) || referenceDescription.getNodeId() == null || !referenceDescription.getNodeId().isLocal() || !Boolean.TRUE.equals(referenceDescription.getIsForward()) || hashSet2.contains(nodeId = this.em.getNamespaceTable().toNodeId(referenceDescription.getNodeId()))) continue;
                    hashSet.add(nodeId);
                }
            }
        }
        logger.debug("Number of Types for getNodes: {}, initialset: {}", (Object)hashSet2.size(), EU);
        internalBrowseResults = InternalBrowseResults.mergeOf(arrayList);
        logger.debug("Number of ServiceRequests needed, Browse: {}, BrowseNext: {}", (Object)internalBrowseResults.getNumberOfBrowseRequests(), (Object)internalBrowseResults.getNumberOfBrowseNextRequests());
        InternalGetNodesResults internalGetNodesResults = InternalAddressSpaceAccessHelper.internalGetNodesWithNodeIdsAndPreBrowseData(this.Fe, this.em.getAddressSpace(), internalBrowseResults.getGoodResults().keySet(), internalBrowseResults);
        logger.debug("Number of Types found: {}, types : {}", (Object)internalGetNodesResults.getRawMap().keySet().size(), internalGetNodesResults.getRawMap().keySet());
        logger.debug("Number of ServiceRequests needed, Read: {}, Browse: {}, BrowseNext: {}", new Object[]{internalGetNodesResults.getReadCalls(), internalGetNodesResults.getBrowseCalls(), internalGetNodesResults.getBrowseNextCalls()});
    }

    private Map<EncodeType, UaNodeId> c(UaDataType uaDataType) {
        UaNodeId uaNodeId = UaNodeId.fromLocal(uaDataType.getNodeId(), this.em.getNamespaceTable());
        Map<EncodeType, UaNodeId> map = this.EZ.get(uaNodeId);
        if (map != null) {
            return map;
        }
        UaReference[] uaReferenceArray = uaDataType.getReferences(Identifiers.HasEncoding, false);
        HashMap<EncodeType, UaNodeId> hashMap = new HashMap<EncodeType, UaNodeId>();
        for (UaReference uaReference : uaReferenceArray) {
            UaNode uaNode = uaReference.getOppositeNode(uaDataType);
            if ("Default Binary".equals(uaNode.getBrowseName().getName())) {
                hashMap.put(EncodeType.Binary, UaNodeId.fromLocal(uaNode.getNodeId(), this.em.getNamespaceTable()));
            }
            if ("Default XML".equals(uaNode.getBrowseName().getName())) {
                hashMap.put(EncodeType.Xml, UaNodeId.fromLocal(uaNode.getNodeId(), this.em.getNamespaceTable()));
            }
            if (!"Default JSON".equals(uaNode.getBrowseName().getName())) continue;
            hashMap.put(EncodeType.Json, UaNodeId.fromLocal(uaNode.getNodeId(), this.em.getNamespaceTable()));
        }
        this.EZ.put(uaNodeId, hashMap);
        for (Map.Entry entry : hashMap.entrySet()) {
            this.Fa.put((UaNodeId)entry.getValue(), uaNodeId);
        }
        return hashMap;
    }

    private Set<UaNodeId> euE() throws Exception {
        logger.debug("Resolving all Enumeration DataTypes");
        HashSet<UaDataTypeImpl> hashSet = new HashSet<UaDataTypeImpl>();
        HashSet<UaNodeId> hashSet2 = new HashSet<UaNodeId>();
        HashSet<UaNodeId> hashSet3 = new HashSet<UaNodeId>();
        this.a(UaNodeId.fromStandard(Identifiers.Enumeration), hashSet);
        logger.debug("Number of Enumerations: {}", (Object)hashSet.size());
        for (UaDataTypeImpl uaDataTypeImpl : hashSet) {
            if (uaDataTypeImpl.getIsAbstract().booleanValue()) continue;
            UaNodeId uaNodeId = UaNodeId.fromLocal(uaDataTypeImpl.getNodeId(), this.em.getNamespaceTable());
            EnumerationSpecification enumerationSpecification = this.em.getEncoderContext().getEnumerationSpecification(uaNodeId);
            if (enumerationSpecification == null && uaDataTypeImpl.getDataTypeDefinition() != null) {
                enumerationSpecification = this.z(uaNodeId);
            }
            if (enumerationSpecification == null) {
                hashSet3.add(uaNodeId);
                continue;
            }
            hashSet2.add(uaNodeId);
        }
        logger.debug("Unknown Enumerations (via DataTypeDefinition): {}", hashSet3);
        logger.debug("Known Enumerations (via DataTypeDefinition): {}", hashSet2);
        return hashSet3;
    }

    private void euF() throws Exception {
        logger.debug("Resolving all numeric OptionSet DataTypes");
        HashSet<UaDataTypeImpl> hashSet = new HashSet<UaDataTypeImpl>();
        this.a(UaIds.Byte, hashSet);
        this.a(UaIds.UInt16, hashSet);
        this.a(UaIds.UInt32, hashSet);
        this.a(UaIds.UInt64, hashSet);
        logger.debug("Number of numeric OptionSet candidates (can also be simpletypes): {}", (Object)hashSet.size());
        HashSet<UaNodeId> hashSet2 = new HashSet<UaNodeId>();
        for (UaDataTypeImpl uaDataTypeImpl : hashSet) {
            if (uaDataTypeImpl.getIsAbstract().booleanValue()) continue;
            UaNodeId uaNodeId = UaNodeId.fromLocal(uaDataTypeImpl.getNodeId(), this.em.getNamespaceTable());
            UaDataTypeSpecification uaDataTypeSpecification = this.em.getEncoderContext().getDataTypeSpecification(uaNodeId);
            if (uaDataTypeSpecification == null && uaDataTypeImpl.getDataTypeDefinition() != null) {
                uaDataTypeSpecification = this.A(uaNodeId);
            }
            if (uaDataTypeSpecification == null) continue;
            hashSet2.add(uaNodeId);
        }
        logger.debug("Known (numeric) OptionSets (via DataTypeDefinition): {}", hashSet2);
    }

    private Set<UaNodeId> euG() throws Exception {
        logger.debug("Resolving all Structure DataTypes");
        HashSet<UaDataTypeImpl> hashSet = new HashSet<UaDataTypeImpl>();
        this.a(UaNodeId.fromStandard(Identifiers.Structure), hashSet);
        this.d(hashSet);
        HashSet<UaNodeId> hashSet2 = new HashSet<UaNodeId>();
        HashSet<UaNodeId> hashSet3 = new HashSet<UaNodeId>();
        for (UaDataTypeImpl uaDataTypeImpl : hashSet) {
            if (uaDataTypeImpl.getIsAbstract().booleanValue()) continue;
            UaNodeId uaNodeId = UaNodeId.fromLocal(uaDataTypeImpl.getNodeId(), this.em.getNamespaceTable());
            StructureSpecification structureSpecification = this.em.getEncoderContext().getStructureSpecification(uaNodeId);
            if (structureSpecification == null && uaDataTypeImpl.getDataTypeDefinition() != null) {
                structureSpecification = this.C(uaNodeId);
            }
            if (structureSpecification == null) {
                hashSet3.add(uaNodeId);
                continue;
            }
            hashSet2.add(uaNodeId);
        }
        logger.debug("Unknown Structures (via DataTypeDefinition): {}", hashSet3);
        logger.debug("Known Structures (via DataTypeDefinition): {}", hashSet2);
        return hashSet3;
    }

    private void euH() throws Exception {
        logger.debug("Resolving all SimpleTypes DataTypes");
        HashSet<UaDataTypeImpl> hashSet = new HashSet<UaDataTypeImpl>();
        this.a(UaIds.Boolean, hashSet);
        this.a(UaIds.SByte, hashSet);
        this.a(UaIds.Byte, hashSet);
        this.a(UaIds.Int16, hashSet);
        this.a(UaIds.UInt16, hashSet);
        this.a(UaIds.Int32, hashSet);
        this.a(UaIds.UInt32, hashSet);
        this.a(UaIds.Int64, hashSet);
        this.a(UaIds.UInt64, hashSet);
        this.a(UaIds.Float, hashSet);
        this.a(UaIds.Double, hashSet);
        this.a(UaIds.String, hashSet);
        this.a(UaIds.DateTime, hashSet);
        this.a(UaIds.Guid, hashSet);
        this.a(UaIds.ByteString, hashSet);
        this.a(UaIds.XmlElement, hashSet);
        this.a(UaIds.NodeId, hashSet);
        this.a(UaIds.ExpandedNodeId, hashSet);
        this.a(UaIds.StatusCode, hashSet);
        this.a(UaIds.QualifiedName, hashSet);
        this.a(UaIds.LocalizedText, hashSet);
        this.a(UaIds.DataValue, hashSet);
        this.a(UaIds.DiagnosticInfo, hashSet);
        QualifiedName qualifiedName = new QualifiedName("BrowseName OptionSetValues");
        hashSet.removeIf(uaDataTypeImpl -> uaDataTypeImpl.hasProperty(qualifiedName));
        for (UaDataTypeImpl uaDataTypeImpl2 : hashSet) {
            logger.trace("Resolving {}", (Object)uaDataTypeImpl2.getNodeId());
            UaDataTypeSpecification uaDataTypeSpecification = this.em.getEncoderContext().getDataTypeSpecification(UaNodeId.fromLocal(uaDataTypeImpl2.getNodeId(), this.em.getNamespaceTable()));
            if (uaDataTypeSpecification != null) continue;
            this.a(uaDataTypeImpl2);
            logger.trace("Existing resolving: {}", (Object)uaDataTypeImpl2.getNodeId());
        }
        logger.trace("Exiting resolvePotentiallyAllSimpleTypes");
    }

    private SimpleTypeSpecification B(UaNodeId uaNodeId) {
        try {
            UaNode uaNode = this.em.getAddressSpace().getNode(uaNodeId.asNodeId(this.em.getNamespaceTable()));
            if (uaNode instanceof UaDataType) {
                UaDataType uaDataType = (UaDataType)uaNode;
                UaNodeId uaNodeId2 = UaNodeId.fromLocal(uaNode.getNodeId(), this.em.getNamespaceTable());
                UaDataTypeSpecification uaDataTypeSpecification = this.em.getEncoderContext().getDataTypeSpecifications().get(uaNodeId2);
                if (uaDataTypeSpecification instanceof SimpleTypeSpecification) {
                    return (SimpleTypeSpecification)uaDataTypeSpecification;
                }
                DataTypeDefinition dataTypeDefinition = uaDataType.getDataTypeDefinition();
                if (dataTypeDefinition != null) {
                    return null;
                }
                if (uaDataType.inheritsFromAny(UaIds.Enumeration, UaIds.Structure) != null) {
                    return null;
                }
                SimpleTypeSpecification simpleTypeSpecification = null;
                for (UaDataType uaDataType2 = (UaDataType)uaDataType.getSuperType(); uaDataType2 != null; uaDataType2 = (UaDataType)uaDataType2.getSuperType()) {
                    uaDataTypeSpecification = this.em.getEncoderContext().getDataTypeSpecification(UaNodeId.fromLocal(uaDataType2.getNodeId(), this.em.getNamespaceTable()));
                    if (!(uaDataTypeSpecification instanceof SimpleTypeSpecification)) continue;
                    simpleTypeSpecification = (SimpleTypeSpecification)uaDataTypeSpecification;
                    break;
                }
                if (simpleTypeSpecification == null) {
                    logger.debug("Cannot find a supertype for {} that would have a SimpleTypeSpeficiation", (Object)uaNodeId);
                    return null;
                }
                SimpleTypeSpecification.Builder builder = SimpleTypeSpecification.builder();
                builder.setBaseTypeId(simpleTypeSpecification.getBaseTypeId());
                builder.setJavaClass(simpleTypeSpecification.getJavaClass());
                builder.setTypeId(uaNodeId2);
                builder.setName(uaNode.getBrowseName().getName());
                return builder.build();
            }
            logger.debug("Could not resolve id {} as SimpleTypeSpecification, it is not a DataType node", (Object)uaNodeId);
        }
        catch (Exception exception) {
            logger.debug("Could not resolve id {} to SimpleTypeSpecification", (Object)uaNodeId, (Object)exception);
        }
        return null;
    }

    private StructureSpecification C(UaNodeId uaNodeId) {
        try {
            UaNode uaNode = this.em.getAddressSpace().getNode(uaNodeId.asNodeId(this.em.getNamespaceTable()));
            if (uaNode instanceof UaDataType) {
                return this.b((UaDataType)uaNode);
            }
            UaReference uaReference = uaNode.getReference(Identifiers.HasEncoding, true);
            if (uaReference == null) {
                logger.error("Could not find reverse HasEncoding reference from node {}", (Object)uaNodeId);
                return null;
            }
            if ((uaNode = uaReference.getOppositeNode(uaNode)) instanceof UaDataType) {
                return this.b((UaDataType)uaNode);
            }
            logger.error("Target of reverse HasEncoding from {} was not a DataType node", (Object)uaNodeId);
            return null;
        }
        catch (Exception exception) {
            logger.debug("Could not resolve id {} to StructureSpecification via DataTypeDefinition Attribute", (Object)uaNodeId, (Object)exception);
            return null;
        }
    }

    StructureSpecification a(j j2, Map<UaQualifiedName, StructureSpecification> map, Map<UaQualifiedName, UaNodeId> map2) throws Exception {
        l l2 = j2.EH;
        UaNodeId uaNodeId = j2.typeId;
        UaNodeId uaNodeId2 = j2.EI;
        UaNodeId uaNodeId3 = j2.EJ;
        DataTypeDictionary dataTypeDictionary = j2.EK;
        boolean bl = j2.isUnion;
        ArrayList<FieldSpecification> arrayList = new ArrayList<FieldSpecification>();
        StructureSpecification.StructureType structureType = StructureSpecification.StructureType.NORMAL;
        List<f> list = l2.getFields();
        if (bl) {
            list = list.subList(1, list.size());
        }
        for (f f2 : list) {
            if (this.Fc && "http://opcfoundation.org/UA/".equals(f2.eus()) && "String".equals(f2.eur())) {
                f2.aH("CharArray");
            }
            Class<Object> clazz = dataTypeDictionary.javaClassForType(f2.eus(), f2.eur());
            UaNodeId uaNodeId4 = dataTypeDictionary.dataTypeIdForType(f2.eus(), f2.eur());
            if (!"http://opcfoundation.org/UA/".equals(f2.eus()) && !"Bit".equals(f2.eur()) && clazz == null) {
                UaQualifiedName uaQualifiedName = UaQualifiedName.from(f2.eus(), f2.eur());
                StructureSpecification structureSpecification = map.get(uaQualifiedName);
                if (structureSpecification == null) {
                    EnumerationSpecification enumerationSpecification = this.EX.get(uaQualifiedName);
                    if (enumerationSpecification == null) {
                        throw new DecodingException("Unknown type: " + f2.eus() + ":" + f2.eur());
                    }
                    clazz = DynamicEnumeration.class;
                    UaQualifiedName uaQualifiedName2 = UaQualifiedName.from(f2.eus(), f2.eur());
                    uaNodeId4 = map2.get(uaQualifiedName2);
                } else {
                    clazz = DynamicStructure.class;
                    uaNodeId4 = structureSpecification.getTypeId();
                }
            }
            if (clazz == null) continue;
            boolean bl2 = false;
            int n2 = -1;
            if (f2.euo() != null && !f2.euo().isEmpty()) {
                bl2 = true;
                n2 = 1;
                clazz = MultiDimensionArrayUtils.arrayClassOf(clazz, 1);
            }
            if (bl2) {
                arrayList.remove(arrayList.size() - 1);
            }
            if (f2.euq() != null && !f2.euq().isEmpty()) {
                arrayList.add(FieldSpecification.builder().setName(f2.getFieldName()).setJavaClass(clazz).setIsOptional(true).setValueRank(n2).setDataTypeId(uaNodeId4).build());
                structureType = StructureSpecification.StructureType.OPTIONAL;
                continue;
            }
            arrayList.add(FieldSpecification.builder().setName(f2.getFieldName()).setJavaClass(clazz).setIsOptional(false).setValueRank(n2).setDataTypeId(uaNodeId4).build());
        }
        if (bl) {
            structureType = StructureSpecification.StructureType.UNION;
        }
        StructureSpecification structureSpecification = StructureSpecification.builder().setName(l2.euC()).setTypeId(uaNodeId).setBinaryEncodeId(uaNodeId2).setXmlEncodeId(uaNodeId3).setFields(arrayList).setStructureType(structureType).build();
        this.addDataTypeSpecification(structureSpecification);
        map.put(UaQualifiedName.from(j2.EL, j2.typeName), structureSpecification);
        return structureSpecification;
    }

    Set<UaTypeImpl> a(UaTypeImpl uaTypeImpl) throws UaException {
        HashSet<UaTypeImpl> hashSet = new HashSet<UaTypeImpl>();
        CopyOnWriteArraySet<NodeId> copyOnWriteArraySet = new CopyOnWriteArraySet<NodeId>();
        CopyOnWriteArraySet<NodeId> copyOnWriteArraySet2 = new CopyOnWriteArraySet<NodeId>();
        copyOnWriteArraySet.add(uaTypeImpl.getNodeId());
        while (!copyOnWriteArraySet.isEmpty()) {
            for (NodeId nodeId : copyOnWriteArraySet) {
                UaTypeImpl uaTypeImpl2 = (UaTypeImpl)this.em.getAddressSpace().getType(nodeId);
                Set<UaTypeImpl> set = this.b(uaTypeImpl2);
                copyOnWriteArraySet.remove(nodeId);
                copyOnWriteArraySet2.add(nodeId);
                for (UaTypeImpl uaTypeImpl3 : set) {
                    if (copyOnWriteArraySet2.contains(uaTypeImpl3.getNodeId())) continue;
                    copyOnWriteArraySet.add(uaTypeImpl3.getNodeId());
                    hashSet.add(uaTypeImpl3);
                }
            }
        }
        return Collections.unmodifiableSet(hashSet);
    }

    Set<UaTypeImpl> b(UaTypeImpl uaTypeImpl) {
        HashSet<UaTypeImpl> hashSet = new HashSet<UaTypeImpl>();
        for (UaReference uaReference : uaTypeImpl.getReferences(Identifiers.HasSubtype, false)) {
            hashSet.add((UaTypeImpl)uaReference.getOppositeNode(uaTypeImpl));
        }
        return Collections.unmodifiableSet(hashSet);
    }

    static {
        HashSet<NodeId> hashSet = new HashSet<NodeId>();
        hashSet.addAll(ReferenceTypeIdentifiers.allReferenceTypeIdentifiers());
        hashSet.addAll(DataTypeIdentifiers.allDataTypeIdentifiers(false));
        hashSet.addAll(VariableTypeIdentifiers.allVariableTypeIdentifiers());
        hashSet.addAll(ObjectTypeIdentifiers.allObjectTypeIdentifiers());
        EU = Collections.unmodifiableSet(hashSet);
    }
}

