/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.typedictionary;

import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.Enumeration;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.typedictionary.DynamicEnumeration;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumerationSpecification
implements UaDataTypeSpecification {
    private static final Logger logger = LoggerFactory.getLogger(EnumerationSpecification.class);
    private final UaNodeId typeId;
    private final String name;
    private final Map<Integer, String> Ei;
    private final Class<? extends Enumeration> javaClass;
    private final Map<String, Integer> Ej;
    private final Map<Integer, Enumeration> Ek;
    private final Map<String, Enumeration> El;
    private final SortedSet<Enumeration> Em;
    private final EnumerationBuilderSupplier En;

    public static Builder builder() {
        return new Builder();
    }

    private EnumerationSpecification(UaNodeId uaNodeId, String string, Class<? extends Enumeration> clazz, Map<Integer, String> map, Map<String, Integer> map2, EnumerationBuilderSupplier enumerationBuilderSupplier) {
        this.typeId = uaNodeId;
        this.name = string;
        this.javaClass = clazz == null ? DynamicEnumeration.class : clazz;
        this.Ei = new HashMap<Integer, String>(map);
        this.Ej = new HashMap<String, Integer>(map2);
        this.En = enumerationBuilderSupplier;
        this.Ek = new HashMap<Integer, Enumeration>();
        this.El = new HashMap<String, Enumeration>();
        this.Em = new TreeSet<Enumeration>(new Comparator<Enumeration>(){

            public int a(Enumeration enumeration, Enumeration enumeration2) {
                int n2;
                int n3 = enumeration == null ? 0 : enumeration.getValue();
                int n4 = n2 = enumeration2 == null ? 0 : enumeration2.getValue();
                return n3 < n2 ? -1 : (n3 == n2 ? 0 : 1);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((Enumeration)object, (Enumeration)object2);
            }
        });
        this.eui();
    }

    @Deprecated
    public DynamicEnumeration createEnumerationFromInteger(int n2) {
        return DynamicEnumeration.builder(this).setValue(n2).build();
    }

    @Deprecated
    public DynamicEnumeration createEnumerationFromString(String string) {
        Integer n2 = this.Ej.get(string);
        if (n2 == null) {
            throw new IllegalArgumentException("This enumeration does not have value: " + string);
        }
        return DynamicEnumeration.builder(this).setValue(n2).build();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EnumerationSpecification enumerationSpecification = (EnumerationSpecification)object;
        return !(this.typeId == null ? enumerationSpecification.typeId != null : !this.typeId.equals(enumerationSpecification.typeId));
    }

    public SortedSet<Enumeration> getAllEnumValues() {
        return Collections.unmodifiableSortedSet(this.Em);
    }

    public Set<Integer> getAllIntegerValues() {
        return Collections.unmodifiableSet(this.Ei.keySet());
    }

    public Set<String> getAllStringValues() {
        return Collections.unmodifiableSet(this.Ej.keySet());
    }

    public Enumeration getByName(String string) {
        if (string == null) {
            return null;
        }
        return this.El.get(string);
    }

    public Enumeration getByValue(Integer n2) {
        if (n2 == null) {
            return null;
        }
        return this.Ek.get(n2);
    }

    public Map<Integer, String> getIntToStringMappings() {
        return Collections.unmodifiableMap(this.Ei);
    }

    public Class<? extends Enumeration> getJavaClass() {
        return this.javaClass;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Map<String, Integer> getStringToIntMappings() {
        return Collections.unmodifiableMap(this.Ej);
    }

    @Override
    public UaNodeId getTypeId() {
        if (this.typeId == null && "IdType".equals(this.name)) {
            return UaNodeId.from("http://opcfoundation.org/UA/", Identifiers.IdType.getValue());
        }
        return this.typeId;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.typeId == null ? 0 : this.typeId.hashCode());
        return n3;
    }

    public Builder toBuilder() {
        Builder builder = EnumerationSpecification.builder();
        builder.setTypeId(this.typeId);
        builder.setName(this.name);
        builder.setMappings(this.Ei);
        return builder;
    }

    public Enumeration.Builder toEnumerationBuilder() {
        if (this.En == null) {
            return DynamicEnumeration.builder(this);
        }
        return this.En.get();
    }

    public String toString() {
        return "EnumerationSpecification [typeId=" + this.typeId + ", name=" + this.name + ", values=" + this.Ei + "]";
    }

    private void eui() {
        for (Integer n2 : this.getAllIntegerValues()) {
            Enumeration enumeration;
            String string = this.getIntToStringMappings().get(n2);
            Enumeration.Builder builder = this.toEnumerationBuilder();
            builder.setValue(n2);
            Enumeration enumeration2 = builder.build();
            Enumeration enumeration3 = this.Ek.put(n2, enumeration2);
            if (enumeration3 != null) {
                logger.warn("More than one Enumeration mapping for: {} in specification: {}", (Object)n2, (Object)this);
            }
            if ((enumeration = this.El.put(string, enumeration2)) != null) {
                logger.warn("More than one Enumeration mapping for: {} in specification: {}", (Object)string, (Object)this);
            }
            this.Em.add(enumeration2);
        }
    }

    public static interface EnumerationBuilderSupplier {
        public Enumeration.Builder get();
    }

    public static class Builder {
        private UaNodeId typeId = null;
        private String name = null;
        private final Map<Integer, String> Ei = new HashMap<Integer, String>();
        private final Map<String, Integer> Ej = new HashMap<String, Integer>();
        private EnumerationBuilderSupplier En = null;
        private Class<? extends Enumeration> javaClass = null;

        private Builder() {
        }

        public Builder addMapping(int n2, String string) {
            this.Ei.put(n2, string);
            if (this.Ej.put(string, n2) != null) {
                logger.warn("Duplicate String mapping '{}' for given Enumeration {} Integer value '{}'", new Object[]{string, this.name, n2});
            }
            return this;
        }

        public EnumerationSpecification build() {
            return new EnumerationSpecification(this.typeId, this.name, this.javaClass, this.Ei, this.Ej, this.En);
        }

        public Builder setBuilderSupplier(EnumerationBuilderSupplier enumerationBuilderSupplier) {
            this.En = enumerationBuilderSupplier;
            return this;
        }

        public Builder setJavaClass(Class<? extends Enumeration> clazz) {
            this.javaClass = clazz;
            return this;
        }

        public Builder setMappings(Map<Integer, String> map) {
            this.Ei.clear();
            this.Ej.clear();
            for (Map.Entry<Integer, String> entry : map.entrySet()) {
                this.addMapping(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public Builder setName(String string) {
            this.name = string;
            return this;
        }

        public Builder setTypeId(UaNodeId uaNodeId) {
            this.typeId = uaNodeId;
            return this;
        }
    }
}

