/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.typedictionary;

import com.prosysopc.ua.AbstractOptionSetDataType;
import com.prosysopc.ua.BitField;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.UaOptionSet;
import com.prosysopc.ua.typedictionary.OptionSetSpecification;
import com.prosysopc.ua.typedictionary.OptionSetStructureSpecification;
import com.prosysopc.ua.typedictionary.OptionSpecification;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Objects;

public class DynamicUIntOptionSet
implements BitField,
UaOptionSet {
    private final BitField delegate;
    private final OptionSetSpecification specification;

    public static Builder builder(OptionSetSpecification optionSetSpecification) {
        if (optionSetSpecification == null) {
            throw new IllegalArgumentException("The given specification cannot be null");
        }
        if (optionSetSpecification instanceof OptionSetStructureSpecification) {
            throw new IllegalArgumentException("This Builder only works for 'UInteger-based' OptionSets, use DynamicOptionSetStructure.builder(specification) instead");
        }
        return new Builder(optionSetSpecification);
    }

    private DynamicUIntOptionSet(OptionSetSpecification optionSetSpecification, BitField bitField) {
        if (bitField == null) {
            throw new IllegalStateException("The given delegate should not be null");
        }
        this.specification = optionSetSpecification;
        this.delegate = bitField;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DynamicUIntOptionSet)) {
            return false;
        }
        DynamicUIntOptionSet dynamicUIntOptionSet = (DynamicUIntOptionSet)object;
        return Objects.equals(this.delegate, dynamicUIntOptionSet.delegate) && Objects.equals(this.specification.getTypeId(), dynamicUIntOptionSet.specification.getTypeId());
    }

    @Override
    public Number getValue() {
        return (Number)((Object)this.delegate);
    }

    public int hashCode() {
        return Objects.hash(this.delegate, this.specification.getTypeId());
    }

    @Override
    public boolean isBitSet(int n2) {
        return this.delegate.isBitSet(n2);
    }

    @Override
    public OptionSetSpecification specification() {
        return this.specification;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this.specification(), this.toBitSet());
    }

    public String toString() {
        return this.delegate.toString();
    }

    private static class a
    extends AbstractOptionSetDataType {
        static BitField a(BitSet bitSet, int n2) {
            return a.computeBitFieldFixedSize(n2, bitSet.stream().toArray());
        }

        protected a(BitField bitField, Class clazz, Class clazz2, UaNodeId uaNodeId, int n2) {
            super(bitField, clazz, clazz2, uaNodeId, n2);
            throw new IllegalStateException("This internal Helper class should never be instantiated");
        }

        @Override
        public OptionSetSpecification specification() {
            throw new IllegalStateException("This internal Helper class should never be instantiated");
        }
    }

    public static class Builder
    implements UaOptionSet.Builder {
        private final OptionSetSpecification specification;
        private final BitSet data = new BitSet();
        private final int sizeInBits;

        private Builder(OptionSetSpecification optionSetSpecification) {
            this(optionSetSpecification, (BitSet)null);
        }

        private Builder(OptionSetSpecification optionSetSpecification, BitSet bitSet) {
            this.specification = optionSetSpecification;
            if (bitSet != null) {
                this.data.or(bitSet);
            }
            if (UaIds.Byte.equals(optionSetSpecification.getBaseTypeId())) {
                this.sizeInBits = 8;
            } else if (UaIds.UInt16.equals(optionSetSpecification.getBaseTypeId())) {
                this.sizeInBits = 16;
            } else if (UaIds.UInt32.equals(optionSetSpecification.getBaseTypeId())) {
                this.sizeInBits = 32;
            } else if (UaIds.UInt64.equals(optionSetSpecification.getBaseTypeId())) {
                this.sizeInBits = 64;
            } else {
                throw new IllegalStateException("The BaseTypeId of the given specification was not one of: Byte, UInt16, UInt32 or UInt64, specification: " + optionSetSpecification);
            }
        }

        @Override
        public Builder add(OptionSpecification ... optionSpecificationArray) {
            if (optionSpecificationArray == null || optionSpecificationArray.length == 0) {
                return this;
            }
            return this.addAll(Arrays.asList(optionSpecificationArray));
        }

        @Override
        public Builder addAll(Iterable<? extends OptionSpecification> iterable) {
            if (iterable == null) {
                return this;
            }
            iterable.forEach(optionSpecification -> {
                if (this.specification.getOptions().contains(optionSpecification)) {
                    this.data.set(optionSpecification.getBitPosition());
                }
            });
            return this;
        }

        @Override
        public DynamicUIntOptionSet build() {
            return new DynamicUIntOptionSet(this.specification, a.a(this.data, this.sizeInBits));
        }

        @Override
        public Builder clear() {
            this.data.clear();
            return this;
        }

        @Override
        public boolean contains(OptionSpecification ... optionSpecificationArray) {
            if (optionSpecificationArray == null) {
                throw new IllegalArgumentException("Null array is not permitted");
            }
            return this.containsAll(Arrays.asList(optionSpecificationArray));
        }

        @Override
        public boolean containsAll(Iterable<? extends OptionSpecification> iterable) {
            if (iterable == null) {
                throw new IllegalArgumentException("Null Iterable not permitted");
            }
            for (OptionSpecification optionSpecification : iterable) {
                if (this.specification.getOptions().contains(optionSpecification)) {
                    if (this.data.get(optionSpecification.getBitPosition())) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        @Override
        public Builder remove(OptionSpecification ... optionSpecificationArray) {
            if (optionSpecificationArray == null || optionSpecificationArray.length == 0) {
                return this;
            }
            return this.removeAll(Arrays.asList(optionSpecificationArray));
        }

        @Override
        public Builder removeAll(Iterable<? extends OptionSpecification> iterable) {
            if (iterable == null) {
                return this;
            }
            iterable.forEach(optionSpecification -> {
                if (this.specification.getOptions().contains(optionSpecification)) {
                    this.data.clear(optionSpecification.getBitPosition());
                }
            });
            return this;
        }

        @Override
        public OptionSetSpecification specification() {
            return this.specification;
        }
    }
}

