/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.typedictionary;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicStructure
extends AbstractStructure {
    private static final Logger logger = LoggerFactory.getLogger(DynamicStructure.class);
    private final StructureSpecification Eh;
    private Map<String, Object> aa = new HashMap<String, Object>();

    public static Builder builder(StructureSpecification structureSpecification) {
        return new Builder(new DynamicStructure(structureSpecification));
    }

    public DynamicStructure(StructureSpecification structureSpecification) {
        if (structureSpecification == null) {
            throw new IllegalArgumentException("Given specification cannot be null");
        }
        this.Eh = structureSpecification;
    }

    @Override
    public void clear() {
        this.aa.clear();
    }

    @Override
    public DynamicStructure clone() {
        DynamicStructure dynamicStructure = (DynamicStructure)super.clone();
        dynamicStructure.aa = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.aa.entrySet()) {
            dynamicStructure.aa.put(entry.getKey(), StructureUtils.clone(entry.getValue()));
        }
        return dynamicStructure;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DynamicStructure dynamicStructure = (DynamicStructure)object;
        if (!this.Eh.equals(dynamicStructure.Eh)) {
            return false;
        }
        if (!this.aa.keySet().equals(dynamicStructure.aa.keySet())) {
            return false;
        }
        for (Map.Entry<String, Object> entry : this.aa.entrySet()) {
            if (StructureUtils.scalarOrArrayEquals(entry.getValue(), dynamicStructure.aa.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        this.e(fieldSpecification);
        return this.aa.get(fieldSpecification.getName());
    }

    @Override
    public Object get(String string) {
        FieldSpecification fieldSpecification = this.az(string);
        return this.aa.get(fieldSpecification.getName());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        if (this.Eh.getBinaryEncodeId() == null) {
            logger.warn("DynamicStructure with Specification {} does not support binary encoding", (Object)this.Eh);
            return null;
        }
        return this.Eh.getBinaryEncodeId().asExpandedNodeId();
    }

    public List<String> getFieldNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (FieldSpecification fieldSpecification : this.getFields()) {
            arrayList.add(fieldSpecification.getName());
        }
        return Collections.unmodifiableList(arrayList);
    }

    public List<FieldSpecification> getFields() {
        return Collections.unmodifiableList(this.Eh.getFields());
    }

    @Deprecated
    public StructureSpecification getSpecification() {
        return this.Eh;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return this.Eh.getTypeId().asExpandedNodeId();
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        if (this.Eh.getXmlEncodeId() == null) {
            return null;
        }
        return this.Eh.getXmlEncodeId().asExpandedNodeId();
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + this.Eh.hashCode();
        Object[] objectArray = this.aa.values().toArray();
        n3 = 31 * n3 + StructureUtils.hashCode(objectArray);
        return n3;
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        this.e(fieldSpecification);
        this.a(fieldSpecification, object);
        if (StructureSpecification.StructureType.UNION == this.Eh.getStructureType() || StructureSpecification.StructureType.UNION_SUBTYPES == this.Eh.getStructureType()) {
            this.aa.clear();
        }
        this.aa.put(fieldSpecification.getName(), object);
    }

    @Override
    public void set(String string, Object object) {
        FieldSpecification fieldSpecification = this.az(string);
        this.set(fieldSpecification, object);
    }

    @Override
    public StructureSpecification specification() {
        return this.Eh;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this.clone());
    }

    private void e(FieldSpecification fieldSpecification) {
        if (!this.getFields().contains(fieldSpecification)) {
            throw new IllegalArgumentException("The " + this.Eh + " of this Structure does not contain: " + fieldSpecification);
        }
    }

    private FieldSpecification az(String string) {
        for (FieldSpecification fieldSpecification : this.getFields()) {
            if (!fieldSpecification.getName().equals(string)) continue;
            return fieldSpecification;
        }
        throw new IllegalArgumentException("This Structure does not contain field named: " + string);
    }

    private void a(FieldSpecification fieldSpecification, Object object) {
        if (object == null) {
            return;
        }
        if (!fieldSpecification.getJavaClass().isAssignableFrom(object.getClass())) {
            throw new IllegalArgumentException("For field:" + fieldSpecification + ", the given value:" + object + ", does not have correct type:" + fieldSpecification.getJavaClass() + ", instead it is:" + object.getClass());
        }
    }

    public static class Builder
    extends AbstractStructure.Builder {
        protected final DynamicStructure delegate;

        protected Builder(DynamicStructure dynamicStructure) {
            this.delegate = dynamicStructure;
        }

        @Override
        public DynamicStructure build() {
            return this.delegate.clone();
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            return this.delegate.get(fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            this.delegate.set(fieldSpecification, object);
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return this.delegate.specification();
        }
    }
}

