/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils.bytebuffer;

import com.prosysopc.ua.stack.encoding.binary.ByteUtils;
import com.prosysopc.ua.stack.utils.bytebuffer.IBinaryReadable;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class InputStreamReadable
implements IBinaryReadable {
    private ByteOrder DM = ByteOrder.LITTLE_ENDIAN;
    private final InputStream is;
    private final long limit;
    private long DX;

    public InputStreamReadable(InputStream inputStream, long l2) {
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        this.is = inputStream;
        this.limit = l2;
    }

    @Override
    public byte get() throws IOException {
        return (byte)this.euc();
    }

    @Override
    public void get(byte[] byArray) throws IOException {
        this.get(byArray, 0, byArray.length);
    }

    @Override
    public void get(byte[] byArray, int n2, int n3) throws IOException {
        while (n3 > 0) {
            int n4 = this.is.read(byArray, n2, n3);
            if (n4 == -1) {
                throw new EOFException();
            }
            this.DX += (long)n4;
            n2 += n4;
            n3 -= n4;
        }
    }

    @Override
    public void get(ByteBuffer byteBuffer) throws IOException {
        while (byteBuffer.hasRemaining()) {
            byteBuffer.put((byte)this.euc());
        }
    }

    @Override
    public void get(ByteBuffer byteBuffer, int n2) throws IOException {
        byte[] byArray = new byte[n2];
        this.get(byArray, 0, n2);
        byteBuffer.put(byArray);
    }

    @Override
    public double getDouble() throws IOException {
        return Double.longBitsToDouble(this.getLong());
    }

    @Override
    public float getFloat() throws IOException {
        return Float.intBitsToFloat(this.getInt());
    }

    @Override
    public int getInt() throws IOException {
        byte[] byArray = new byte[4];
        this.get(byArray);
        return ByteUtils.bytesToInt(byArray, this.DM);
    }

    @Override
    public long getLong() throws IOException {
        byte[] byArray = new byte[8];
        this.get(byArray);
        return ByteUtils.bytesToLong(byArray, this.DM);
    }

    @Override
    public short getShort() throws IOException {
        byte[] byArray = new byte[2];
        this.get(byArray);
        return ByteUtils.bytesToShort(byArray, this.DM);
    }

    @Override
    public long limit() {
        return this.limit;
    }

    @Override
    public ByteOrder order() {
        return this.DM;
    }

    @Override
    public void order(ByteOrder byteOrder) {
        this.DM = byteOrder;
    }

    @Override
    public long position() {
        return this.DX;
    }

    public void skip(long l2) throws IOException {
        this.is.skip(l2);
    }

    private int euc() throws IOException {
        int n2 = this.is.read();
        if (n2 == -1) {
            throw new EOFException();
        }
        ++this.DX;
        return n2 & 0xFF;
    }
}

