/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils.bytebuffer;

import com.prosysopc.ua.stack.utils.bytebuffer.ByteQueue;
import com.prosysopc.ua.stack.utils.bytebuffer.IBinaryWriteable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ByteBufferArrayWriteable
implements IBinaryWriteable {
    ByteQueue Dh;
    ByteBuffer DJ = ByteBuffer.allocate(8);

    public ByteBufferArrayWriteable(ByteBuffer[] byteBufferArray) {
        if (byteBufferArray == null) {
            throw new IllegalArgumentException("null");
        }
        this.Dh = new ByteQueue();
        this.DJ.order(this.Dh.order());
        for (ByteBuffer byteBuffer : byteBufferArray) {
            this.Dh.offer(byteBuffer);
        }
    }

    public ByteBufferArrayWriteable(ByteQueue byteQueue) {
        if (byteQueue == null) {
            throw new IllegalArgumentException("null");
        }
        this.Dh = byteQueue;
        this.DJ.order(byteQueue.order());
    }

    @Override
    public void flush() {
    }

    @Override
    public ByteOrder order() {
        return this.Dh.order();
    }

    @Override
    public void order(ByteOrder byteOrder) {
        this.DJ.order(byteOrder);
        this.Dh.order(byteOrder);
    }

    @Override
    public void put(byte by) throws IOException {
        this.Dh.getWriteChunk().put(by);
    }

    @Override
    public void put(byte[] byArray) throws IOException {
        this.Dh.put(byArray);
    }

    @Override
    public void put(byte[] byArray, int n2, int n3) throws IOException {
        this.Dh.put(byArray, n2, n3);
    }

    @Override
    public void put(ByteBuffer byteBuffer) throws IOException {
        this.Dh.put(byteBuffer);
    }

    @Override
    public void put(ByteBuffer byteBuffer, int n2) throws IOException {
        this.Dh.put(byteBuffer, n2);
    }

    @Override
    public void putDouble(double d2) throws IOException {
        if (this.Dh.getWriteChunk().remaining() > 8) {
            this.Dh.getWriteChunk().putDouble(d2);
        } else {
            this.DJ.rewind();
            this.DJ.putDouble(d2);
            this.DJ.rewind();
            this.Dh.put(this.DJ, 8);
        }
    }

    @Override
    public void putFloat(float f2) throws IOException {
        if (this.Dh.getWriteChunk().remaining() > 4) {
            this.Dh.getWriteChunk().putFloat(f2);
        } else {
            this.DJ.rewind();
            this.DJ.putFloat(f2);
            this.DJ.rewind();
            this.Dh.put(this.DJ, 4);
        }
    }

    @Override
    public void putInt(int n2) throws IOException {
        if (this.Dh.getWriteChunk().remaining() > 4) {
            this.Dh.getWriteChunk().putInt(n2);
        } else {
            this.DJ.rewind();
            this.DJ.putInt(n2);
            this.DJ.rewind();
            this.Dh.put(this.DJ, 4);
        }
    }

    @Override
    public void putLong(long l2) throws IOException {
        if (this.Dh.getWriteChunk().remaining() > 8) {
            this.Dh.getWriteChunk().putLong(l2);
        } else {
            this.DJ.rewind();
            this.DJ.putLong(l2);
            this.DJ.rewind();
            this.Dh.put(this.DJ, 8);
        }
    }

    @Override
    public void putShort(short s2) throws IOException {
        if (this.Dh.getWriteChunk().remaining() > 2) {
            this.Dh.getWriteChunk().putShort(s2);
        } else {
            this.DJ.rewind();
            this.DJ.putShort(s2);
            this.DJ.rewind();
            this.Dh.put(this.DJ, 2);
        }
    }
}

