/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils.asyncsocket;

import com.prosysopc.ua.stack.utils.AbstractState;
import com.prosysopc.ua.stack.utils.asyncsocket.AsyncSelector;
import com.prosysopc.ua.stack.utils.asyncsocket.AsyncSocketImpl;
import com.prosysopc.ua.stack.utils.asyncsocket.ListenableServerSocketChannel;
import com.prosysopc.ua.stack.utils.asyncsocket.ServerSocketState;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncServerSocket
extends AbstractState<ServerSocketState, IOException> {
    static Logger logger = LoggerFactory.getLogger(AsyncServerSocket.class);
    ServerSocketChannel CR;
    ListenableServerSocketChannel CS;
    Executor executor;
    CopyOnWriteArrayList<ConnectListener> we = new CopyOnWriteArrayList();
    ListenableServerSocketChannel.ServerSocketAcceptable CT = new ListenableServerSocketChannel.ServerSocketAcceptable(){

        @Override
        public void onConnectionAcceptable(ListenableServerSocketChannel listenableServerSocketChannel) {
            try {
                SocketChannel socketChannel = listenableServerSocketChannel.getChannel().accept();
                socketChannel.configureBlocking(false);
                AsyncSocketImpl asyncSocketImpl = new AsyncSocketImpl(socketChannel, AsyncServerSocket.this.executor, AsyncServerSocket.this.CS.getSelectorThread());
                AsyncServerSocket.this.a(asyncSocketImpl);
            }
            catch (ClosedChannelException closedChannelException) {
                AsyncServerSocket.this.setState((Object)ServerSocketState.Closed);
            }
            catch (IOException iOException) {
                AsyncServerSocket.this.setError(iOException);
            }
        }
    };

    public AsyncServerSocket(ServerSocketChannel serverSocketChannel, Executor executor) throws IOException {
        super(ServerSocketState.Ready, ServerSocketState.Error);
        this.CS = new ListenableServerSocketChannel(serverSocketChannel, executor);
        this.executor = executor;
        this.CR = serverSocketChannel;
    }

    public AsyncServerSocket(ServerSocketChannel serverSocketChannel, Executor executor, AsyncSelector asyncSelector) throws ClosedChannelException {
        super(ServerSocketState.Ready, ServerSocketState.Error);
        this.CS = new ListenableServerSocketChannel(serverSocketChannel, executor, asyncSelector);
        this.executor = executor;
        this.CR = serverSocketChannel;
    }

    public void addListener(ConnectListener connectListener) {
        this.we.add(connectListener);
    }

    public AsyncServerSocket bind(SocketAddress socketAddress, int n2) throws IOException {
        ServerSocketState serverSocketState = (ServerSocketState)((Object)this.getState());
        if (serverSocketState == ServerSocketState.Closed) {
            throw new ClosedChannelException();
        }
        this.throwIfError();
        this.CS.bind(socketAddress, n2);
        this.setState(ServerSocketState.Bound);
        this.CS.setAcceptableListener(this.CT);
        return this;
    }

    public ServerSocketChannel channel() {
        return this.CR;
    }

    public AsyncServerSocket close() {
        logger.debug("close");
        try {
            this.CS.close();
            this.setState(ServerSocketState.Closed);
        }
        catch (IOException iOException) {
            logger.error("close", (Throwable)iOException);
            this.setError(iOException);
        }
        return this;
    }

    public void removeListener(ConnectListener connectListener) {
        this.we.remove(connectListener);
    }

    public ServerSocket socket() {
        return this.CR.socket();
    }

    public String toString() {
        if (!this.CR.socket().isBound()) {
            return "unbound";
        }
        return this.CR.socket().getLocalSocketAddress().toString();
    }

    void a(final AsyncSocketImpl asyncSocketImpl) {
        for (final ConnectListener connectListener : this.we) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    connectListener.onConnected(AsyncServerSocket.this, asyncSocketImpl);
                }
            });
        }
    }

    public static interface ConnectListener {
        public void onConnected(AsyncServerSocket var1, AsyncSocketImpl var2);
    }
}

