/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils;

import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.utils.EncodingLimitsExceededIoException;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class LimitedByteArrayOutputStream
extends OutputStream {
    private final ByteArrayOutputStream Ca;
    private final int limit;

    public static LimitedByteArrayOutputStream withSizeLimit(int n2) {
        return new LimitedByteArrayOutputStream(n2);
    }

    private LimitedByteArrayOutputStream(int n2) {
        this.limit = n2;
        this.Ca = new ByteArrayOutputStream();
    }

    public void reset() {
        this.Ca.reset();
    }

    public byte[] toByteArray() {
        return this.Ca.toByteArray();
    }

    public String toString() {
        return ByteString.from(this.Ca).toHex();
    }

    @Override
    public void write(byte[] byArray) throws EncodingLimitsExceededIoException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws EncodingLimitsExceededIoException {
        if (this.Ca.size() >= this.limit - n3) {
            throw new EncodingLimitsExceededIoException("Stream size is " + this.Ca.size() + " limit is " + this.limit + ", cannot write " + n3 + " bytes");
        }
        this.Ca.write(byArray, n2, n3);
    }

    @Override
    public void write(int n2) throws EncodingLimitsExceededIoException {
        if (this.Ca.size() >= this.limit) {
            throw new EncodingLimitsExceededIoException("Stream is at max capasity, " + this.limit + ", cannot write more.");
        }
        this.Ca.write(n2);
    }
}

