/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.tcp.nio;

import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.IEncodeable;
import com.prosysopc.ua.stack.encoding.binary.BinaryDecoder;
import com.prosysopc.ua.stack.transport.security.SecurityConfiguration;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkAsymmDecryptVerifier;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkSymmDecryptVerifier;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkUtils;
import com.prosysopc.ua.stack.transport.tcp.impl.InternalBinaryEncodingsHelper;
import com.prosysopc.ua.stack.transport.tcp.impl.SecurityToken;
import com.prosysopc.ua.stack.transport.tcp.impl.TcpConnectionParameters;
import com.prosysopc.ua.stack.transport.tcp.nio.InputMessage;
import com.prosysopc.ua.stack.utils.bytebuffer.IncubationBuffer;
import com.prosysopc.ua.stack.utils.bytebuffer.InputStreamReadable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureInputMessageBuilder
implements InputMessage {
    static Logger sj = LoggerFactory.getLogger(SecureInputMessageBuilder.class);
    MessageListener Bp;
    Object Bq;
    TcpConnectionParameters As;
    EncoderContext ws;
    Exception Br;
    IncubationBuffer Bs;
    Runnable Bt;
    int Bu;
    IEncodeable vQ;
    Integer Bv;
    Integer Bw;
    int messageType;
    boolean Bx = true;
    boolean done;
    String wo;
    byte[] yR;
    byte[] yS;
    List<Integer> By = new ArrayList<Integer>(1);
    AtomicInteger Bz;
    long BA = 0L;

    public SecureInputMessageBuilder(Object object, MessageListener messageListener, TcpConnectionParameters tcpConnectionParameters, EncoderContext encoderContext, AtomicInteger atomicInteger) {
        this.Bp = messageListener;
        this.Bq = object;
        this.As = tcpConnectionParameters;
        this.ws = encoderContext;
        this.Bz = atomicInteger;
        sj.debug("SecureInputMessageBuilder: expectedSequenceNumber={}", (Object)atomicInteger);
        this.Bs = new IncubationBuffer();
        int n2 = tcpConnectionParameters.maxRecvMessageSize == 0 ? Integer.MAX_VALUE : tcpConnectionParameters.maxRecvMessageSize;
        InputStreamReadable inputStreamReadable = new InputStreamReadable(this.Bs, n2);
        inputStreamReadable.order(ByteOrder.LITTLE_ENDIAN);
        final BinaryDecoder binaryDecoder = new BinaryDecoder(inputStreamReadable);
        binaryDecoder.setEncoderContext(encoderContext);
        this.Bt = new Runnable(){

            @Override
            public void run() {
                try {
                    IEncodeable iEncodeable = InternalBinaryEncodingsHelper.getMessage(binaryDecoder);
                    if (!(SecureInputMessageBuilder.this.Bq instanceof SecurityToken)) {
                        for (int i2 = 1; i2 < SecureInputMessageBuilder.this.By.size(); ++i2) {
                            if (SecureInputMessageBuilder.this.By.get(i2) == SecureInputMessageBuilder.this.By.get(i2 - 1) - 1) continue;
                            String string = "Sequence numbers of chunks are not consecutive";
                            sj.info(string);
                            SecureInputMessageBuilder.this.setError(new ServiceResultException(StatusCodes.Bad_DecodingError, string));
                            return;
                        }
                    }
                    SecureInputMessageBuilder.this.setMessage(iEncodeable);
                }
                catch (Exception exception) {
                    SecureInputMessageBuilder.this.setError(exception);
                }
                catch (StackOverflowError stackOverflowError) {
                    SecureInputMessageBuilder.this.setError(new ServiceResultException(StatusCodes.Bad_DecodingError, "Stack overflow: " + Arrays.toString(Arrays.copyOf(stackOverflowError.getStackTrace(), 30)) + "..."));
                }
            }
        };
    }

    public synchronized void addChunk(final ByteBuffer byteBuffer) throws ServiceResultException {
        if (!this.Bx) {
            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "Final chunk added to message builder");
        }
        this.BA += (long)byteBuffer.remaining();
        sj.trace("Current message size via chunks: {}", (Object)this.BA);
        if (this.BA > (long)this.ws.getMaxMessageSize()) {
            sj.trace("Max message limits ({}) exceeded, at {}, stopping accepting chunks", (Object)this.ws.getMaxMessageSize(), (Object)this.BA);
            throw new ServiceResultException(StatusCodes.Bad_RequestTooLarge);
        }
        final int n2 = this.Bu++;
        this.By.add(null);
        int n3 = ChunkUtils.getMessageType(byteBuffer);
        int n4 = n3 & 0xFFFFFF;
        int n5 = n3 & 0xFF000000;
        if (n5 == 0x46000000) {
            this.Bx = false;
        }
        final Integer n6 = this.Bz != null ? Integer.valueOf(this.Bz.getAndIncrement()) : null;
        sj.debug("addChunk: expectedSequenceNumber={}", (Object)n6);
        if (n5 == 0x41000000) {
            this.setMessage(null);
        }
        if (n2 == 0) {
            this.messageType = n4;
            this.Bw = ChunkUtils.getSecureChannelId(byteBuffer);
        }
        this.Bs.incubate(byteBuffer);
        if (!this.Bx) {
            this.Bs.close();
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (SecureInputMessageBuilder.this.hasError()) {
                    return;
                }
                try {
                    sj.debug("token: {}", SecureInputMessageBuilder.this.Bq);
                    if (SecureInputMessageBuilder.this.Bq instanceof SecurityToken) {
                        new ChunkSymmDecryptVerifier(byteBuffer, (SecurityToken)SecureInputMessageBuilder.this.Bq).run();
                    } else if (SecureInputMessageBuilder.this.Bq instanceof SecurityConfiguration) {
                        ChunkAsymmDecryptVerifier chunkAsymmDecryptVerifier = new ChunkAsymmDecryptVerifier(byteBuffer, (SecurityConfiguration)SecureInputMessageBuilder.this.Bq);
                        chunkAsymmDecryptVerifier.run();
                        SecureInputMessageBuilder.this.wo = chunkAsymmDecryptVerifier.getSecurityPolicyUri();
                        SecureInputMessageBuilder.this.yR = chunkAsymmDecryptVerifier.getSenderCertificate();
                        SecureInputMessageBuilder.this.yS = chunkAsymmDecryptVerifier.getReceiverCertificateThumbprint();
                    }
                    int n22 = byteBuffer.position();
                    byte[] byArray = new byte[byteBuffer.remaining()];
                    byteBuffer.get(byArray);
                    byteBuffer.position(n22);
                    int n3 = byteBuffer.position();
                    byteBuffer.position(n3 - 8);
                    int n4 = byteBuffer.getInt();
                    SecureInputMessageBuilder.this.By.set(n2, n4);
                    if (n6 != null) {
                        if (n4 > n6) {
                            long l2 = System.currentTimeMillis();
                            long l3 = 100L;
                            while (n4 > n6 && System.currentTimeMillis() - l2 < l3) {
                                Thread.sleep(1L);
                            }
                        }
                        if (n6 != n4) {
                            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "chunkSequenceNumber=" + n4 + ", expectedSequenceNumber=" + n6);
                        }
                    }
                    int n5 = byteBuffer.getInt();
                    SecureInputMessageBuilder.this.w(n5);
                    int n62 = ChunkUtils.getSecureChannelId(byteBuffer);
                    if (n62 != SecureInputMessageBuilder.this.Bw) {
                        throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "secureChannelId=" + n62 + ", expected Id");
                    }
                    byteBuffer.position(n3);
                    sj.trace("hatching chunk, requestId: {}", (Object)n5);
                    SecureInputMessageBuilder.this.Bs.hatch(byteBuffer);
                }
                catch (Exception exception) {
                    sj.info("addChunk: failed", (Throwable)exception);
                    SecureInputMessageBuilder.this.Bs.forceClose();
                    SecureInputMessageBuilder.this.setError(exception);
                }
            }
        };
        runnable.run();
        if (!this.Bx) {
            this.Bt.run();
        }
    }

    public void close() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.Bs.forceClose();
    }

    @Override
    public Exception getError() {
        return this.Br;
    }

    @Override
    public IEncodeable getMessage() {
        return this.vQ;
    }

    @Override
    public int getMessageType() {
        return this.messageType;
    }

    public byte[] getReceiverCertificateThumbprint() {
        return this.yS;
    }

    @Override
    public int getRequestId() {
        return this.Bv;
    }

    @Override
    public int getSecureChannelId() {
        return this.Bw;
    }

    public String getSecurityPolicyUri() {
        return this.wo;
    }

    public byte[] getSenderCertificate() {
        return this.yR;
    }

    @Override
    public List<Integer> getSequenceNumbers() {
        return this.By;
    }

    @Override
    public Object getToken() {
        return this.Bq;
    }

    public synchronized boolean isDone() {
        return this.done;
    }

    public synchronized boolean moreChunksRequired() {
        return this.Bx;
    }

    public void softClose() {
        this.Bs.close();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("token=" + this.Bq);
        stringBuilder.append(", secureChannelId=" + this.Bw);
        stringBuilder.append(", more=" + this.moreChunksRequired());
        return stringBuilder.toString();
    }

    private synchronized void w(int n2) throws ServiceResultException {
        if (this.Bv != null && this.Bv != n2) {
            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError);
        }
        this.Bv = n2;
    }

    protected void fireComplete() {
        if (this.Bp != null) {
            this.Bp.onMessageComplete(this);
        }
    }

    protected synchronized boolean hasError() {
        return this.Br != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setError(Exception exception) {
        SecureInputMessageBuilder secureInputMessageBuilder = this;
        synchronized (secureInputMessageBuilder) {
            if (this.done) {
                sj.info("setError[when done]", (Throwable)exception);
                return;
            }
            this.done = true;
            this.Br = exception;
            this.Bs.forceClose();
        }
        this.fireComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setMessage(IEncodeable iEncodeable) {
        SecureInputMessageBuilder secureInputMessageBuilder = this;
        synchronized (secureInputMessageBuilder) {
            if (this.done) {
                return;
            }
            this.Bs.close();
            this.done = true;
            this.vQ = iEncodeable;
        }
        this.fireComplete();
    }

    public static interface MessageListener {
        public void onMessageComplete(InputMessage var1);
    }
}

