/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.tcp.nio;

import com.prosysopc.ua.stack.builtintypes.ServiceResponse;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.ActivateSessionResponse;
import com.prosysopc.ua.stack.core.CloseSecureChannelRequest;
import com.prosysopc.ua.stack.core.EndpointConfiguration;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.core.OpenSecureChannelRequest;
import com.prosysopc.ua.stack.core.PublishRequest;
import com.prosysopc.ua.stack.core.SecurityTokenRequestType;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.encoding.IEncodeable;
import com.prosysopc.ua.stack.encoding.binary.BinaryEncoder;
import com.prosysopc.ua.stack.transport.AsyncWrite;
import com.prosysopc.ua.stack.transport.CloseableObject;
import com.prosysopc.ua.stack.transport.CloseableObjectState;
import com.prosysopc.ua.stack.transport.Endpoint;
import com.prosysopc.ua.stack.transport.EndpointBinding;
import com.prosysopc.ua.stack.transport.IConnectionListener;
import com.prosysopc.ua.stack.transport.ServerSecureChannel;
import com.prosysopc.ua.stack.transport.endpoint.EndpointBindingCollection;
import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.CertificateValidator;
import com.prosysopc.ua.stack.transport.security.KeyPair;
import com.prosysopc.ua.stack.transport.security.SecurityAlgorithm;
import com.prosysopc.ua.stack.transport.security.SecurityConfiguration;
import com.prosysopc.ua.stack.transport.security.SecurityMode;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.transport.tcp.impl.Acknowledge;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkAsymmEncryptSigner;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkFactory;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkSymmEncryptSigner;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkUtils;
import com.prosysopc.ua.stack.transport.tcp.impl.ErrorMessage;
import com.prosysopc.ua.stack.transport.tcp.impl.Hello;
import com.prosysopc.ua.stack.transport.tcp.impl.InternalBinaryEncodingsHelper;
import com.prosysopc.ua.stack.transport.tcp.impl.ReverseHello;
import com.prosysopc.ua.stack.transport.tcp.impl.SecurityToken;
import com.prosysopc.ua.stack.transport.tcp.nio.AbstractServerConnection;
import com.prosysopc.ua.stack.transport.tcp.nio.ChunksToMessage;
import com.prosysopc.ua.stack.transport.tcp.nio.InputMessage;
import com.prosysopc.ua.stack.transport.tcp.nio.MessageToChunks;
import com.prosysopc.ua.stack.transport.tcp.nio.MessageType;
import com.prosysopc.ua.stack.transport.tcp.nio.OpcTcpServer;
import com.prosysopc.ua.stack.transport.tcp.nio.OpcTcpServerSecureChannel;
import com.prosysopc.ua.stack.transport.tcp.nio.PendingRequest;
import com.prosysopc.ua.stack.transport.tcp.nio.SecureInputMessageBuilder;
import com.prosysopc.ua.stack.utils.CertificateUtils;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import com.prosysopc.ua.stack.utils.IStatefulObject;
import com.prosysopc.ua.stack.utils.IncubationQueue;
import com.prosysopc.ua.stack.utils.SizeCalculationOutputStream;
import com.prosysopc.ua.stack.utils.StackUtils;
import com.prosysopc.ua.stack.utils.StateListener;
import com.prosysopc.ua.stack.utils.TimerUtil;
import com.prosysopc.ua.stack.utils.asyncsocket.AsyncInputStream;
import com.prosysopc.ua.stack.utils.asyncsocket.AsyncSocket;
import com.prosysopc.ua.stack.utils.asyncsocket.AsyncSocketImpl;
import com.prosysopc.ua.stack.utils.asyncsocket.BufferMonitorState;
import com.prosysopc.ua.stack.utils.asyncsocket.MonitorListener;
import com.prosysopc.ua.stack.utils.asyncsocket.SocketState;
import com.prosysopc.ua.stack.utils.bytebuffer.ByteBufferArrayWriteable2;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpcTcpServerConnection
extends AbstractServerConnection {
    private static final Logger logger = LoggerFactory.getLogger(OpcTcpServerConnection.class);
    private static long AT = 600000L;
    int Aq;
    Map<Integer, PendingRequest> xt = new ConcurrentHashMap<Integer, PendingRequest>();
    EndpointBinding AU;
    OpcTcpServer AV;
    AsyncSocket AW;
    ReverseHello AX;
    AtomicBoolean AY = new AtomicBoolean(false);
    Timer wq = TimerUtil.getTimer();
    TimerTask AZ;
    Runnable Ba = new Runnable(){

        @Override
        public void run() {
            OpcTcpServerConnection.this.setError(StatusCodes.Bad_Timeout);
        }
    };
    EncoderContext ws;
    EndpointConfiguration gs;
    MonitorListener Bb = new MonitorListener(){

        public void a(IStatefulObject<BufferMonitorState, ?> iStatefulObject, BufferMonitorState bufferMonitorState, BufferMonitorState bufferMonitorState2) {
            if (bufferMonitorState2.isUnreachable()) {
                if (OpcTcpServerConnection.this.At != null) {
                    OpcTcpServerConnection.this.At.close();
                    OpcTcpServerConnection.this.At = null;
                }
                return;
            }
            if (bufferMonitorState2 != BufferMonitorState.Triggered) {
                logger.error("Unexpected trigger state {}", (Object)bufferMonitorState2);
                return;
            }
            AsyncInputStream asyncInputStream = OpcTcpServerConnection.this.AW.getInputStream();
            ByteBuffer byteBuffer = asyncInputStream.peek(8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.getInt();
            int n2 = byteBuffer.getInt();
            if (n2 < 12) {
                OpcTcpServerConnection.this.setError(StatusCodes.Bad_TcpInternalError);
                if (OpcTcpServerConnection.this.At != null) {
                    OpcTcpServerConnection.this.At.close();
                }
                return;
            }
            if (n2 > OpcTcpServerConnection.this.As.maxRecvChunkSize) {
                OpcTcpServerConnection.this.setError(new ServiceResultException(StatusCodes.Bad_TcpMessageTooLarge, "Chunk size (" + n2 + ") exceeded maximum (" + OpcTcpServerConnection.this.As.maxRecvChunkSize + ")"));
                if (OpcTcpServerConnection.this.At != null) {
                    OpcTcpServerConnection.this.At.close();
                }
                return;
            }
            if (asyncInputStream.available() >= n2) {
                ByteBuffer byteBuffer2 = asyncInputStream.read(n2);
                byteBuffer2.rewind();
                try {
                    try {
                        OpcTcpServerConnection.this.handleChunk(byteBuffer2);
                    }
                    catch (RuntimeException runtimeException) {
                        logger.warn("Error in handleChunk", (Throwable)runtimeException);
                        throw StackUtils.toServiceResultException(runtimeException);
                    }
                }
                catch (ServiceResultException serviceResultException) {
                    logger.info("Error in handleChunk", (Throwable)serviceResultException);
                    OpcTcpServerConnection.this.setError(serviceResultException);
                }
                asyncInputStream.createMonitor(asyncInputStream.getPosition() + 8L, this);
            } else {
                asyncInputStream.createMonitor(asyncInputStream.getPosition() + (long)n2, this);
            }
        }

        @Override
        public /* synthetic */ void onStateTransition(IStatefulObject iStatefulObject, Object object, Object object2) {
            this.a(iStatefulObject, (BufferMonitorState)((Object)object), (BufferMonitorState)((Object)object2));
        }
    };
    SecureInputMessageBuilder.MessageListener Bc = new SecureInputMessageBuilder.MessageListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMessageComplete(InputMessage inputMessage) {
            IEncodeable iEncodeable = inputMessage.getMessage();
            for (Object object : OpcTcpServerConnection.this.Aw) {
                if (!object.handleMessage(inputMessage)) continue;
                return;
            }
            if (iEncodeable == null) {
                3 var3_3 = this;
                synchronized (var3_3) {
                    Object object;
                    object = inputMessage.getError();
                    if (object == null) {
                        return;
                    }
                    OpcTcpServerConnection.this.setError(StackUtils.toServiceResultException((Exception)object));
                    return;
                }
            }
            try {
                if (inputMessage.getMessageType() == 4674381) {
                    if (iEncodeable instanceof PublishRequest) {
                        OpcTcpServerConnection.this.handleSecureMessage(inputMessage);
                    } else {
                        StackUtils.getBlockingWorkExecutor().execute(() -> {
                            try {
                                OpcTcpServerConnection.this.handleSecureMessage(inputMessage);
                            }
                            catch (ServiceResultException serviceResultException) {
                                OpcTcpServerConnection.this.setError(serviceResultException);
                            }
                        });
                    }
                } else if (inputMessage.getMessageType() == 5196867) {
                    OpcTcpServerConnection.this.handleCloseSecureChannelRequest(inputMessage);
                } else if (inputMessage.getMessageType() == 5132367) {
                    OpcTcpServerConnection.this.handleOpenSecureChannelRequest(inputMessage);
                }
            }
            catch (ServiceResultException serviceResultException) {
                OpcTcpServerConnection.this.setError(serviceResultException);
            }
        }
    };

    public static long getHandshakeTimeout() {
        return AT;
    }

    public static void setHandshakeTimeout(long l2) {
        AT = l2;
    }

    OpcTcpServerConnection(OpcTcpServer opcTcpServer, AsyncSocketImpl asyncSocketImpl) {
        this(opcTcpServer, asyncSocketImpl, null);
    }

    OpcTcpServerConnection(OpcTcpServer opcTcpServer, AsyncSocketImpl asyncSocketImpl, ReverseHello reverseHello) {
        this.AV = opcTcpServer;
        this.AW = asyncSocketImpl;
        this.AX = reverseHello;
        this.ws = opcTcpServer.getEncoderContext();
        this.Ar = new StateListener<SocketState>(){

            public void a(IStatefulObject<SocketState, ?> iStatefulObject, SocketState socketState, SocketState socketState2) {
                if (socketState2 == SocketState.Error) {
                    OpcTcpServerConnection.this.setError(StackUtils.toServiceResultException(OpcTcpServerConnection.this.AW.getStateMonitor().getError()));
                }
                if (socketState2 == SocketState.Closed) {
                    OpcTcpServerConnection.this.close();
                }
            }

            @Override
            public /* synthetic */ void onStateTransition(IStatefulObject iStatefulObject, Object object, Object object2) {
                this.a(iStatefulObject, (SocketState)((Object)object), (SocketState)((Object)object2));
            }
        };
        this.setState(CloseableObjectState.Opening);
    }

    @Override
    public void addConnectionListener(IConnectionListener iConnectionListener) {
        logger.debug("addConnectionListener: listener={}", (Object)iConnectionListener);
        super.addConnectionListener(iConnectionListener);
    }

    @Override
    public synchronized CloseableObject close() {
        this.cancelTimeoutTimer();
        try {
            this.setState(CloseableObjectState.Closing);
        }
        finally {
            try {
                this.AW.close();
            }
            catch (IOException iOException) {}
            this.setState(CloseableObjectState.Closed);
        }
        return this;
    }

    @Override
    public SocketAddress getLocalAddress() {
        Socket socket = this.AW.socket();
        if (socket == null) {
            return null;
        }
        return socket.getLocalSocketAddress();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        Socket socket = this.AW.socket();
        if (socket == null) {
            return null;
        }
        return socket.getRemoteSocketAddress();
    }

    public boolean hasActiveSession() {
        return this.AY.get();
    }

    public void init() {
        this.AW.getStateMonitor().addStateListener(this.Ar);
        if (this.AX == null) {
            this.AZ = TimerUtil.schedule(this.wq, this.Ba, StackUtils.getBlockingWorkExecutor(), System.currentTimeMillis() + AT);
        }
        this.AW.getInputStream().createMonitor(8L, this.Bb);
        if (this.AX != null) {
            this.AW.getStateMonitor().addStateListener(new StateListener<SocketState>(){

                public void a(IStatefulObject<SocketState, ?> iStatefulObject2, SocketState socketState, SocketState socketState2) {
                    if (socketState == SocketState.Connecting && socketState2 == SocketState.Connected) {
                        OpcTcpServerConnection.this.AZ = TimerUtil.schedule(OpcTcpServerConnection.this.wq, OpcTcpServerConnection.this.Ba, StackUtils.getBlockingWorkExecutor(), System.currentTimeMillis() + AT);
                        OpcTcpServerConnection.this.sendReverseHello(OpcTcpServerConnection.this.AX);
                        OpcTcpServerConnection.this.AW.getInputStream().createMonitor(8L, (iStatefulObject, bufferMonitorState, bufferMonitorState2) -> {});
                    }
                }

                @Override
                public /* synthetic */ void onStateTransition(IStatefulObject iStatefulObject, Object object, Object object2) {
                    this.a(iStatefulObject, (SocketState)((Object)object), (SocketState)((Object)object2));
                }
            });
        }
    }

    public boolean isPurgeEligible() {
        logger.trace("isPurgeEligible, reverse: {}, hasActiveSession: {}", (Object)this.isReverse(), (Object)this.hasActiveSession());
        return !this.isReverse() && !this.hasActiveSession();
    }

    public boolean isReverse() {
        return this.AX != null;
    }

    @Override
    public void removeConnectionListener(IConnectionListener iConnectionListener) {
        logger.debug("removeConnectionListener: listener={}", (Object)iConnectionListener);
        super.removeConnectionListener(iConnectionListener);
        this.cancelTimeoutTimer();
    }

    public void setActiveSession(boolean bl) {
        this.AY.set(bl);
        logger.trace("setActiveSession: {}", (Object)bl);
    }

    private void a(BinaryEncoder binaryEncoder, IEncodeable iEncodeable) throws EncodingException {
        if (iEncodeable == null) {
            throw new EncodingException("Cannot encode null message");
        }
        InternalBinaryEncodingsHelper.putServiceResponse(binaryEncoder, (ServiceResponse)iEncodeable);
    }

    private String D(String string) {
        if (string == null) {
            return null;
        }
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    protected void cancelTimeoutTimer() {
        TimerTask timerTask = this.AZ;
        if (timerTask != null) {
            timerTask.cancel();
            this.AZ = null;
            this.Ba = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endChunkSend(ByteBuffer byteBuffer) {
        this.Av.hatch(byteBuffer);
        OpcTcpServerConnection opcTcpServerConnection = this;
        synchronized (opcTcpServerConnection) {
            while (this.Av.nextIsHatched()) {
                ByteBuffer byteBuffer2 = (ByteBuffer)this.Av.removeNextHatchedIfAvailable();
                byteBuffer2.rewind();
                this.AW.getOutputStream().offer(byteBuffer2);
            }
        }
    }

    protected BufferMonitorState flush(long l2) throws InterruptedException, IOException {
        return this.AW.getOutputStream().createMonitor(l2, null).waitForState(BufferMonitorState.FINAL_STATES);
    }

    @Override
    protected CertificateValidator getRemoteCertificateValidator() {
        return this.AU == null ? null : this.AU.serviceServer.getApplication().getOpctcpSettings().getCertificateValidator();
    }

    protected void handleAcknowledgeMessage(Acknowledge acknowledge) throws ServiceResultException {
        throw new ServiceResultException(StatusCodes.Bad_UnexpectedError);
    }

    protected void handleAsymmChunk(ByteBuffer byteBuffer) throws ServiceResultException {
        logger.trace("handleAsymmChunk");
        byteBuffer.rewind();
        if (this.At != null && !this.At.moreChunksRequired()) {
            this.At = null;
        }
        if (this.At == null) {
            Object object;
            Cert cert;
            int n2 = ChunkUtils.getSecureChannelId(byteBuffer);
            OpcTcpServerSecureChannel opcTcpServerSecureChannel = this.Au == null ? null : this.validateSecureChannelId(n2);
            String string = ChunkUtils.getString(byteBuffer);
            SecurityPolicy securityPolicy = SecurityPolicy.getSecurityPolicy(string);
            if (securityPolicy == null) {
                logger.warn("Security policy \"{}\" is not supported by the stack", (Object)string);
                throw new ServiceResultException(StatusCodes.Bad_SecurityPolicyRejected, "Security policy \"" + string + "\" is not supported by the stack");
            }
            byte[] byArray = ChunkUtils.getByteString(byteBuffer);
            byte[] byArray2 = ChunkUtils.getByteString(byteBuffer);
            logger.debug("secureChannelId={}", (Object)n2);
            logger.debug("secureChannel={}", (Object)opcTcpServerSecureChannel);
            logger.debug("securityPolicyUri={}", (Object)string);
            logger.debug("securityPolicy={}", (Object)securityPolicy);
            logger.debug("encodedRemoteCertificate={}", (Object)byArray);
            logger.debug("encodedLocalCertificateThumbprint={}", (Object)byArray2);
            KeyPair keyPair = this.AU.serviceServer.getApplication().getApplicationInstanceCertificate(byArray2);
            if (keyPair == null && securityPolicy != SecurityPolicy.NONE) {
                logger.warn("Requested Application Instance Certificate is not found in the server");
                throw new ServiceResultException(StatusCodes.Bad_SecurityChecksFailed, "Requested Application Instance Certificate is not found in the server");
            }
            try {
                cert = byArray == null ? null : new Cert(CertificateUtils.decodeX509Certificate(byArray));
            }
            catch (CertificateException certificateException) {
                throw new ServiceResultException(StatusCodes.Bad_SecurityChecksFailed);
            }
            CertificateValidator certificateValidator = this.getRemoteCertificateValidator();
            if (certificateValidator != null && (object = certificateValidator.validateCertificate(cert)) != null && !((StatusCode)object).isGood()) {
                logger.warn("Remote certificate not accepted: {}", object);
                if (((StatusCode)object).isStatusCode(StatusCodes.Bad_CertificateChainIncomplete) || ((StatusCode)object).isStatusCode(StatusCodes.Bad_CertificateRevoked)) {
                    throw new ServiceResultException(StatusCodes.Bad_SecurityChecksFailed);
                }
                throw new ServiceResultException((StatusCode)object);
            }
            object = securityPolicy == SecurityPolicy.NONE ? MessageSecurityMode.None : MessageSecurityMode.SignAndEncrypt;
            SecurityMode securityMode = new SecurityMode(securityPolicy, (MessageSecurityMode)object);
            this.securityConfiguration = new SecurityConfiguration(securityMode, keyPair, cert);
            AtomicInteger atomicInteger = opcTcpServerSecureChannel == null ? null : opcTcpServerSecureChannel.recvSequenceNumber;
            this.At = new SecureInputMessageBuilder(this.securityConfiguration, this.Bc, this.As, this.ws, atomicInteger);
        }
        logger.debug("onAsymmSecureChunk: {}", (Object)byteBuffer);
        this.At.addChunk(byteBuffer);
    }

    protected void handleChunk(ByteBuffer byteBuffer) throws ServiceResultException {
        if (logger.isTraceEnabled()) {
            logger.trace("handleChunk, chunk: {}, byte order: {}", (Object)byteBuffer, (Object)byteBuffer.order());
        }
        int n2 = ChunkUtils.getMessageType(byteBuffer);
        int n3 = n2 & 0xFFFFFF;
        logger.trace("handleChunk, type: {}, messageType: {}", (Object)n2, (Object)n3);
        if (n3 == 4674381) {
            this.handleSymmChunk(byteBuffer);
        } else if (n3 == 5196867) {
            this.handleCloseChunk(byteBuffer);
        } else if (n3 == 5132367) {
            this.handleAsymmChunk(byteBuffer);
        } else if (n3 == 4998472 || n3 == 4932417 || n3 == 0x525245) {
            this.handleRawChunk(byteBuffer);
        } else {
            logger.trace("Unknown chunk messagetype encountered: {}, type: {}, closing connection..", (Object)n3, (Object)n2);
            this.close();
        }
    }

    protected void handleCloseChunk(ByteBuffer byteBuffer) throws ServiceResultException {
        logger.trace("handleCloseChunk");
        this.close();
    }

    protected void handleCloseSecureChannelRequest(InputMessage inputMessage) throws ServiceResultException {
        logger.debug("onCloseChannel");
        IEncodeable iEncodeable = inputMessage.getMessage();
        if (!(iEncodeable instanceof CloseSecureChannelRequest)) {
            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError);
        }
        CloseSecureChannelRequest closeSecureChannelRequest = (CloseSecureChannelRequest)iEncodeable;
        OpcTcpServerSecureChannel opcTcpServerSecureChannel = this.validateSecureChannelId(inputMessage.getSecureChannelId());
        opcTcpServerSecureChannel.handleCloseSecureChannelRequest(inputMessage, closeSecureChannelRequest);
    }

    protected void handleErrorMessage(ErrorMessage errorMessage) {
        logger.debug("onError: {}", (Object)errorMessage);
        this.setError(errorMessage.getError());
    }

    protected void handleHelloMessage(Hello hello) throws ServiceResultException {
        List<EndpointBinding> list;
        this.cancelTimeoutTimer();
        EndpointBindingCollection endpointBindingCollection = this.AV.getEndpointBindings();
        if (endpointBindingCollection == null) {
            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError);
        }
        if (this.Au != null) {
            throw new ServiceResultException(StatusCodes.Bad_TcpNotEnoughResources);
        }
        String string = this.D(hello.getEndpointUrl());
        logger.debug("onHello: url={}", (Object)string);
        if (string == null || string.equals("")) {
            this.AU = this.AV.discoveryEndpointBinding;
        } else {
            list = endpointBindingCollection.get(string);
            if (list.isEmpty()) {
                this.AU = endpointBindingCollection.getDefault(string);
                if (this.AU == null) {
                    throw new ServiceResultException(StatusCodes.Bad_TcpEndpointUrlInvalid);
                }
            } else {
                this.AU = list.get(0);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug(" endpoints={}", (Object)Arrays.toString(endpointBindingCollection.getEndpointAddresses().toArray(new Endpoint[0])));
            logger.debug(" endpoint=" + (this.AU == null ? "binding is null" : this.AU.endpointAddress));
        }
        if (this.getState() != CloseableObjectState.Opening) {
            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError);
        }
        list = new Acknowledge();
        if (hello.getSendBufferSize().longValue() < 8192L) {
            this.setError(new ServiceResultException(StatusCodes.Bad_TcpInternalError, "Peer send buffer size <  8192"));
        }
        if (hello.getReceiveBufferSize().longValue() < 8192L) {
            this.setError(new ServiceResultException(StatusCodes.Bad_TcpInternalError, "Peer recv buffer size <  8192"));
        }
        if (this.getError() != null) {
            logger.warn("onHello: " + this.getError());
        }
        this.Aq = Math.min(0, hello.getProtocolVersion().intValue());
        ((Acknowledge)((Object)list)).setProtocolVersion(UnsignedInteger.getFromBits(this.Aq));
        if (hello.getMaxMessageSize() != null && hello.getMaxMessageSize().intValue() != 0) {
            this.As.maxSendMessageSize = this.As.maxSendMessageSize == 0 ? hello.getMaxMessageSize().intValue() : Math.min(this.As.maxSendMessageSize, hello.getMaxMessageSize().intValue());
        }
        if (this.AU == null) {
            throw new ServiceResultException(StatusCodes.Bad_TcpInternalError);
        }
        int n2 = this.AU.endpointAddress.getEndpointConfiguration().getMaxMessageSize();
        this.As.maxSendMessageSize = this.As.maxSendMessageSize == 0 ? n2 : Math.min(this.As.maxSendMessageSize, n2);
        this.As.maxRecvMessageSize = this.As.maxRecvMessageSize == 0 ? n2 : Math.min(this.As.maxRecvMessageSize, n2);
        this.ws.setMaxMessageSize(n2);
        ((Acknowledge)((Object)list)).setMaxMessageSize(UnsignedInteger.getFromBits(this.As.maxRecvMessageSize));
        if (hello.getMaxChunkCount().intValue() != 0) {
            this.As.maxSendChunkCount = Math.min(this.As.maxSendChunkCount, hello.getMaxChunkCount().intValue());
        }
        ((Acknowledge)((Object)list)).setMaxChunkCount(UnsignedInteger.getFromBits(this.As.maxRecvChunkCount));
        this.As.maxSendChunkSize = Math.min(hello.getReceiveBufferSize().intValue(), this.As.maxSendChunkSize);
        this.As.maxRecvChunkSize = Math.min(hello.getSendBufferSize().intValue(), this.As.maxRecvChunkSize);
        ((Acknowledge)((Object)list)).setSendBufferSize(UnsignedInteger.getFromBits(this.As.maxSendChunkSize));
        ((Acknowledge)((Object)list)).setReceiveBufferSize(UnsignedInteger.getFromBits(this.As.maxRecvChunkSize));
        this.As.maxRecvChunkSize = Math.min(this.As.maxRecvChunkSize, hello.getReceiveBufferSize().intValue());
        this.As.maxSendChunkSize = Math.min(this.As.maxSendChunkSize, hello.getSendBufferSize().intValue());
        this.setState(CloseableObjectState.Opening);
        this.As.endpointUrl = hello.getEndpointUrl();
        this.sendAcknowledge((Acknowledge)((Object)list));
        this.setState(CloseableObjectState.Open);
    }

    protected void handleOpenSecureChannelRequest(InputMessage inputMessage) throws ServiceResultException {
        IEncodeable iEncodeable = inputMessage.getMessage();
        if (iEncodeable == null) {
            OpcTcpServerConnection opcTcpServerConnection = this;
            synchronized (opcTcpServerConnection) {
                Exception exception = inputMessage.getError();
                logger.warn("InputMessage has error", (Throwable)exception);
                throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, (Throwable)exception);
            }
        }
        if (!(iEncodeable instanceof OpenSecureChannelRequest)) {
            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError);
        }
        OpenSecureChannelRequest openSecureChannelRequest = (OpenSecureChannelRequest)iEncodeable;
        if (openSecureChannelRequest.getRequestType() == SecurityTokenRequestType.Issue) {
            if (this.Au != null) {
                throw new ServiceResultException(StatusCodes.Bad_TcpNotEnoughResources);
            }
            OpcTcpServerSecureChannel opcTcpServerSecureChannel = new OpcTcpServerSecureChannel(this, this.AV.wJ.incrementAndGet());
            logger.debug("handleOpenSecureChannelRequest: endpointServer={} SecureChannelId={}", (Object)this.AV, (Object)opcTcpServerSecureChannel.getSecureChannelId());
            opcTcpServerSecureChannel.handleOpenChannel(inputMessage, openSecureChannelRequest);
        } else if (openSecureChannelRequest.getRequestType() == SecurityTokenRequestType.Renew) {
            OpcTcpServerSecureChannel opcTcpServerSecureChannel = this.validateSecureChannelId(inputMessage.getSecureChannelId());
            if (!Objects.equals(openSecureChannelRequest.getRequestType(), SecurityTokenRequestType.Renew)) {
                throw new ServiceResultException(StatusCodes.Bad_UnexpectedError);
            }
            opcTcpServerSecureChannel.handleRenewSecureChannelRequest(inputMessage, openSecureChannelRequest);
        }
    }

    protected void handleRawChunk(ByteBuffer byteBuffer) {
        logger.trace("handleRawChunk");
        int n2 = ChunkUtils.getMessageType(byteBuffer);
        int n3 = n2 & 0xFFFFFF;
        int n4 = n2 & 0xFF000000;
        if (n4 != 0x46000000) {
            this.close();
        }
        byteBuffer.position(8);
        try {
            if (n3 == 4998472) {
                ChunksToMessage chunksToMessage = new ChunksToMessage(this.As, this.ws, Hello.class, byteBuffer);
                this.handleHelloMessage((Hello)chunksToMessage.call());
            } else if (n3 == 4932417) {
                ChunksToMessage chunksToMessage = new ChunksToMessage(this.As, this.ws, Acknowledge.class, byteBuffer);
                this.handleAcknowledgeMessage((Acknowledge)chunksToMessage.call());
            } else if (n3 == 0x525245) {
                ChunksToMessage chunksToMessage = new ChunksToMessage(this.As, this.ws, ErrorMessage.class, byteBuffer);
                this.handleErrorMessage((ErrorMessage)chunksToMessage.call());
            }
        }
        catch (Exception exception) {
            this.setError(StackUtils.toServiceResultException(exception));
        }
    }

    protected void handleSecureMessage(InputMessage inputMessage) throws ServiceResultException {
        IEncodeable iEncodeable = inputMessage.getMessage();
        int n2 = inputMessage.getSecureChannelId();
        if (logger.isDebugEnabled()) {
            logger.debug("handleSecureMessage: secureChannelId=" + n2 + "msg=" + (iEncodeable == null ? "null" : iEncodeable.getClass().getSimpleName()));
        }
        OpcTcpServerSecureChannel opcTcpServerSecureChannel = this.validateSecureChannelId(n2);
        if (iEncodeable instanceof OpenSecureChannelRequest) {
            OpenSecureChannelRequest openSecureChannelRequest = (OpenSecureChannelRequest)iEncodeable;
            if (!Objects.equals(openSecureChannelRequest.getRequestType(), SecurityTokenRequestType.Renew)) {
                throw new ServiceResultException(StatusCodes.Bad_UnexpectedError);
            }
            opcTcpServerSecureChannel.handleRenewSecureChannelRequest(inputMessage, openSecureChannelRequest);
        } else if (iEncodeable instanceof CloseSecureChannelRequest) {
            opcTcpServerSecureChannel.handleCloseSecureChannelRequest(inputMessage, (CloseSecureChannelRequest)iEncodeable);
        } else {
            opcTcpServerSecureChannel.handleSecureMessage(inputMessage, iEncodeable);
        }
    }

    protected void handleSymmChunk(ByteBuffer byteBuffer) throws ServiceResultException {
        logger.trace("handleSymmChunk");
        int n2 = ChunkUtils.getSecureChannelId(byteBuffer);
        int n3 = ChunkUtils.getTokenId(byteBuffer);
        byteBuffer.rewind();
        OpcTcpServerSecureChannel opcTcpServerSecureChannel = this.validateSecureChannelId(n2);
        if (((CloseableObjectState)((Object)opcTcpServerSecureChannel.getState())).equals((Object)CloseableObjectState.Closed)) {
            throw new ServiceResultException(StatusCodes.Bad_SecureChannelIdInvalid);
        }
        SecurityToken securityToken = opcTcpServerSecureChannel.getSecurityToken(n3);
        if (securityToken == null) {
            throw new ServiceResultException(StatusCodes.Bad_SecureChannelTokenUnknown);
        }
        if (!securityToken.isValid()) {
            securityToken = opcTcpServerSecureChannel.getLatestNonExpiredToken();
        }
        if (securityToken == null || !securityToken.isValid()) {
            logger.error("SecurityToken expired");
            throw new ServiceResultException(StatusCodes.Bad_SecureChannelClosed);
        }
        SecurityToken securityToken2 = opcTcpServerSecureChannel.getActiveSecurityToken();
        if (securityToken != securityToken2) {
            logger.debug("handleSymmChunk: activeToken={}, token={}", (Object)securityToken2, (Object)securityToken);
            if (securityToken2.getCreationTime() < securityToken.getCreationTime()) {
                opcTcpServerSecureChannel.setActiveSecurityToken(securityToken);
            }
        }
        logger.debug("handleSymmChunk: {}", (Object)this.At);
        if (this.At != null && !this.At.moreChunksRequired()) {
            this.At.softClose();
            this.At = null;
        }
        if (this.At == null) {
            this.At = new SecureInputMessageBuilder(securityToken, this.Bc, this.As, this.ws, opcTcpServerSecureChannel.recvSequenceNumber);
            logger.debug("handleSymmChunk: secureMessageBuilder={}", (Object)this.At);
        }
        this.At.addChunk(byteBuffer);
    }

    @Override
    protected synchronized void onStateTransition(CloseableObjectState closeableObjectState, CloseableObjectState closeableObjectState2) {
        super.onStateTransition(closeableObjectState, closeableObjectState2);
        logger.debug("onStateTransition: {}->{}", (Object)closeableObjectState, (Object)closeableObjectState2);
        if (closeableObjectState2 == CloseableObjectState.Closing) {
            ServiceResultException serviceResultException = (ServiceResultException)this.getError();
            ArrayList<ServerSecureChannel> arrayList = new ArrayList<ServerSecureChannel>();
            this.getSecureChannels(arrayList);
            for (ServerSecureChannel serverSecureChannel : arrayList) {
                OpcTcpServerSecureChannel opcTcpServerSecureChannel = (OpcTcpServerSecureChannel)serverSecureChannel;
                if (opcTcpServerSecureChannel != null && serviceResultException != null) {
                    opcTcpServerSecureChannel.setError(serviceResultException);
                }
                serverSecureChannel.close();
            }
        }
    }

    protected void sendAcknowledge(Acknowledge acknowledge) throws ServiceResultException {
        ChunkFactory.AcknowledgeChunkFactory acknowledgeChunkFactory = new ChunkFactory.AcknowledgeChunkFactory();
        MessageToChunks messageToChunks = new MessageToChunks(acknowledge, this.As, this.ws, acknowledgeChunkFactory, MessageType.Encodeable);
        ByteBuffer[] byteBufferArray = messageToChunks.call();
        ByteBuffer[] byteBufferArray2 = acknowledgeChunkFactory.expandToCompleteChunk(byteBufferArray);
        byteBufferArray2[0].putInt(1179337537);
        byteBufferArray2[0].rewind();
        this.sendChunks(byteBufferArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int sendAsymmSecureMessage(AsyncWrite asyncWrite, SecurityConfiguration securityConfiguration, int n2, int n3, AtomicInteger atomicInteger) throws ServiceResultException {
        int n4;
        Object object = asyncWrite;
        synchronized (object) {
            if (asyncWrite.isCanceled()) {
                return -1;
            }
            asyncWrite.setQueued();
        }
        object = new ChunkFactory.AsymmMsgChunkFactory(this.As.maxSendChunkSize, securityConfiguration);
        MessageToChunks messageToChunks = new MessageToChunks(asyncWrite.getMessage(), this.As, this.ws, (ChunkFactory)object, MessageType.Message);
        ByteBuffer[] byteBufferArray = messageToChunks.call();
        ByteBuffer[] byteBufferArray2 = ((ChunkFactory)object).expandToCompleteChunk(byteBufferArray);
        Object object2 = asyncWrite;
        synchronized (object2) {
            if (asyncWrite.isCanceled()) {
                return -1;
            }
            asyncWrite.setWriting();
        }
        object2 = securityConfiguration.getSecurityPolicy();
        OpcTcpServerConnection opcTcpServerConnection = this;
        synchronized (opcTcpServerConnection) {
            n4 = atomicInteger.getAndAdd(byteBufferArray2.length);
            this.startChunkSend(byteBufferArray2);
        }
        for (int i2 = 0; i2 < byteBufferArray2.length; ++i2) {
            ByteBuffer byteBuffer = byteBufferArray2[i2];
            ByteBuffer byteBuffer2 = byteBufferArray[i2];
            boolean bl = byteBuffer == byteBufferArray2[byteBufferArray2.length - 1];
            byteBuffer.rewind();
            byteBuffer.putInt(0x4E504F | (bl ? 0x46000000 : 0x43000000));
            byteBuffer.position(8);
            byteBuffer.putInt(n2);
            byte[] byArray = ((SecurityPolicy)((Object)object2)).getEncodedPolicyUri();
            byteBuffer.putInt(byArray.length);
            byteBuffer.put(byArray);
            byArray = securityConfiguration.getEncodedLocalCertificate();
            byteBuffer.putInt(byArray == null ? -1 : byArray.length);
            if (byArray != null) {
                byteBuffer.put(byArray);
            }
            byteBuffer.putInt((byArray = securityConfiguration.getEncodedRemoteCertificateThumbprint()) == null ? -1 : byArray.length);
            if (byArray != null) {
                byteBuffer.put(byArray);
            }
            byteBuffer.putInt(n4++);
            byteBuffer.putInt(n3);
            new ChunkAsymmEncryptSigner(byteBuffer, byteBuffer2, securityConfiguration).run();
            byteBuffer.rewind();
            this.endChunkSend(byteBuffer);
        }
        asyncWrite.setWritten();
        return byteBufferArray2.length;
    }

    protected synchronized void sendChunks(ByteBuffer ... byteBufferArray) {
        this.startChunkSend(byteBufferArray);
        for (ByteBuffer byteBuffer : byteBufferArray) {
            this.endChunkSend(byteBuffer);
        }
    }

    protected void sendError(ErrorMessage errorMessage) throws ServiceResultException {
        ChunkFactory.ErrorMessageChunkFactory errorMessageChunkFactory = new ChunkFactory.ErrorMessageChunkFactory();
        MessageToChunks messageToChunks = new MessageToChunks(errorMessage, this.As, this.ws, errorMessageChunkFactory, MessageType.Encodeable);
        ByteBuffer[] byteBufferArray = messageToChunks.call();
        ByteBuffer[] byteBufferArray2 = errorMessageChunkFactory.expandToCompleteChunk(byteBufferArray);
        byteBufferArray2[0].putInt(1179800133);
        byteBufferArray2[0].rewind();
        this.sendChunks(byteBufferArray2);
    }

    protected void sendHello(Hello hello) {
        this.As.endpointUrl = hello.getEndpointUrl();
        ChunkFactory chunkFactory = new ChunkFactory(this.As.maxSendChunkSize, 8, 0, 0, 0, 1, MessageSecurityMode.None, 0);
        MessageToChunks messageToChunks = new MessageToChunks(hello, this.As, this.ws, chunkFactory, MessageType.Encodeable);
        ByteBuffer[] byteBufferArray = messageToChunks.call();
        ByteBuffer[] byteBufferArray2 = chunkFactory.expandToCompleteChunk(byteBufferArray);
        byteBufferArray2[0].putInt(1179403592);
        byteBufferArray2[0].rewind();
        this.sendChunks(byteBufferArray2);
    }

    protected void sendReverseHello(ReverseHello reverseHello) {
        ChunkFactory chunkFactory = new ChunkFactory(this.As.maxSendChunkSize, 8, 0, 0, 0, 1, MessageSecurityMode.None, 0);
        MessageToChunks messageToChunks = new MessageToChunks(reverseHello, this.As, this.ws, chunkFactory, MessageType.Encodeable);
        ByteBuffer[] byteBufferArray = messageToChunks.call();
        ByteBuffer[] byteBufferArray2 = chunkFactory.expandToCompleteChunk(byteBufferArray);
        byteBufferArray2[0].putInt(1178945618);
        byteBufferArray2[0].rewind();
        this.sendChunks(byteBufferArray2);
        logger.debug("Sent ReverseHello: {}", (Object)reverseHello);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendSecureMessage(final AsyncWrite asyncWrite, final SecurityToken securityToken, int n2, int n3, AtomicInteger atomicInteger) {
        int n4;
        ByteBuffer[] byteBufferArray;
        ByteBuffer[] byteBufferArray2;
        boolean bl;
        int n5;
        int n6;
        ByteBuffer[] byteBufferArray3;
        ByteBuffer[] byteBufferArray4;
        try {
            byteBufferArray4 = asyncWrite;
            synchronized (byteBufferArray4) {
                if (asyncWrite.isCanceled()) {
                    return;
                }
                asyncWrite.setQueued();
            }
            logger.trace("sendSecureMessage: {}", (Object)asyncWrite.getMessage());
            byteBufferArray4 = new SizeCalculationOutputStream();
            byteBufferArray3 = new BinaryEncoder((OutputStream)byteBufferArray4);
            byteBufferArray3.setEncoderContext(this.ws);
            byteBufferArray3.getLocales().addAll(asyncWrite.getLocales());
            this.a((BinaryEncoder)byteBufferArray3, asyncWrite.getMessage());
            n6 = byteBufferArray4.getLength();
            if (n6 > this.As.maxSendMessageSize && this.As.maxSendMessageSize != 0) {
                throw new ServiceResultException(StatusCodes.Bad_TcpMessageTooLarge);
            }
            SecurityPolicy securityPolicy = securityToken.getSecurityPolicy();
            MessageSecurityMode messageSecurityMode = securityToken.getMessageSecurityMode();
            SecurityAlgorithm object = securityPolicy.getSymmetricEncryptionAlgorithm();
            SecurityAlgorithm securityAlgorithm = securityPolicy.getSymmetricSignatureAlgorithm();
            int n7 = CryptoUtil.getCipherBlockSize(object, null);
            int n8 = CryptoUtil.getSignatureSize(securityAlgorithm, null);
            int n9 = n5 = messageSecurityMode == MessageSecurityMode.SignAndEncrypt ? securityToken.getRemoteEncryptingKey().length : 0;
            int n10 = messageSecurityMode == MessageSecurityMode.SignAndEncrypt ? (n5 > 2048 ? 2 : 1) : 0;
            int n11 = this.As.maxSendChunkSize - 24 - n10 - n8;
            n11 -= (n11 + n10 + n8 + 8) % n7;
            int n12 = StackUtils.cores();
            int n13 = (n6 + n12 - 1) / n12;
            if (n13 > n11) {
                n13 = n11;
            }
            if (n13 < 4096) {
                n13 = 4096;
            }
            int n14 = n13 + 24 + n10 + n8;
            ChunkFactory chunkFactory = new ChunkFactory(n14, 8, 8, 8, n8, n7, messageSecurityMode, n5);
            int n15 = (n6 + chunkFactory.maxPlaintextSize - 1) / chunkFactory.maxPlaintextSize;
            if (n15 > this.As.maxSendChunkCount && this.As.maxSendChunkCount != 0) {
                throw new ServiceResultException(StatusCodes.Bad_TcpMessageTooLarge);
            }
            bl = n15 > 1 && n12 > 0 && messageSecurityMode != MessageSecurityMode.None;
            int n16 = n6;
            byteBufferArray2 = new ByteBuffer[n15];
            byteBufferArray = new ByteBuffer[n15];
            for (int i2 = 0; i2 < n15; ++i2) {
                byteBufferArray2[i2] = chunkFactory.allocate(n16);
                byteBufferArray[i2] = chunkFactory.expandToCompleteChunk(byteBufferArray2[i2]);
                n16 -= byteBufferArray2[i2].remaining();
            }
            AsyncWrite asyncWrite2 = asyncWrite;
            synchronized (asyncWrite2) {
                if (asyncWrite.isCanceled()) {
                    return;
                }
                asyncWrite.setWriting();
            }
        }
        catch (ServiceResultException serviceResultException) {
            asyncWrite.setError(serviceResultException);
            return;
        }
        byteBufferArray4 = byteBufferArray;
        byteBufferArray3 = byteBufferArray2;
        n6 = byteBufferArray.length;
        boolean bl2 = bl;
        OpcTcpServerConnection opcTcpServerConnection = this;
        synchronized (opcTcpServerConnection) {
            n4 = atomicInteger.getAndAdd(byteBufferArray.length);
            this.startChunkSend(byteBufferArray);
        }
        for (ByteBuffer byteBuffer : byteBufferArray) {
            n5 = byteBuffer == byteBufferArray[byteBufferArray.length - 1] ? 1 : 0;
            byteBuffer.rewind();
            byteBuffer.putInt(n3 | (n5 != 0 ? 0x46000000 : 0x43000000));
            byteBuffer.position(8);
            byteBuffer.putInt(securityToken.getSecureChannelId());
            byteBuffer.putInt(securityToken.getTokenId());
            byteBuffer.putInt(n4++);
            byteBuffer.putInt(n2);
        }
        final AtomicInteger atomicInteger2 = new AtomicInteger();
        ByteBufferArrayWriteable2.ChunkListener chunkListener = new ByteBufferArrayWriteable2.ChunkListener(){

            @Override
            public void onChunkComplete(ByteBuffer[] byteBufferArray, final int n2) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        new ChunkSymmEncryptSigner(byteBufferArray4[n2], byteBufferArray3[n2], securityToken).run();
                        byteBufferArray4[n2].rewind();
                        OpcTcpServerConnection.this.endChunkSend(byteBufferArray4[n2]);
                        if (atomicInteger2.incrementAndGet() == n6) {
                            asyncWrite.setWritten();
                        }
                    }
                };
                runnable.run();
            }
        };
        ByteBufferArrayWriteable2 byteBufferArrayWriteable2 = new ByteBufferArrayWriteable2(byteBufferArray2, chunkListener);
        byteBufferArrayWriteable2.order(ByteOrder.LITTLE_ENDIAN);
        final BinaryEncoder binaryEncoder = new BinaryEncoder(byteBufferArrayWriteable2);
        binaryEncoder.getLocales().addAll(asyncWrite.getLocales());
        binaryEncoder.setEncoderContext(this.ws);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    OpcTcpServerConnection.this.a(binaryEncoder, asyncWrite.getMessage());
                    if (asyncWrite.getMessage() instanceof ActivateSessionResponse) {
                        ActivateSessionResponse activateSessionResponse = (ActivateSessionResponse)asyncWrite.getMessage();
                        if (activateSessionResponse.getResponseHeader().getServiceResult().isGood()) {
                            OpcTcpServerConnection.this.AY.set(true);
                        } else {
                            OpcTcpServerConnection.this.AY.set(false);
                        }
                    }
                }
                catch (ServiceResultException serviceResultException) {
                    asyncWrite.setError(StackUtils.toServiceResultException(serviceResultException));
                }
            }
        };
        StackUtils.getBlockingWorkExecutor().execute(runnable);
    }

    @Override
    protected synchronized void setError(ServiceResultException serviceResultException) {
        if (!this.hasError()) {
            try {
                this.sendError(new ErrorMessage(serviceResultException.getStatusCode(), serviceResultException.getMessage()));
            }
            catch (ServiceResultException serviceResultException2) {
                logger.warn("Could not send error message", (Throwable)serviceResultException2);
            }
            super.setError(serviceResultException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startChunkSend(ByteBuffer ... byteBufferArray) {
        IncubationQueue incubationQueue = this.Av;
        synchronized (incubationQueue) {
            for (ByteBuffer byteBuffer : byteBufferArray) {
                this.Av.incubate(byteBuffer);
            }
        }
    }

    protected OpcTcpServerSecureChannel validateSecureChannelId(int n2) throws ServiceResultException {
        if (this.Au == null || this.Au.getSecureChannelId() != n2) {
            throw new ServiceResultException(StatusCodes.Bad_SecureChannelIdInvalid);
        }
        return this.Au;
    }
}

