/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.security;

import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.KeyPair;
import com.prosysopc.ua.stack.transport.security.SecurityMode;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import java.security.cert.Certificate;
import java.security.interfaces.RSAPrivateKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityConfiguration {
    public static final SecurityConfiguration NO_SECURITY;
    static Logger sj;
    SecurityMode ys;
    KeyPair yt = null;
    Cert yu = null;

    public SecurityConfiguration(SecurityMode securityMode, KeyPair keyPair, Cert cert) {
        if (securityMode == null) {
            throw new NullPointerException("SecurityMode mode is null");
        }
        this.ys = securityMode;
        if (securityMode.hasSigning()) {
            if (keyPair == null) {
                throw new NullPointerException("localApplicationInstanceCertificate is null");
            }
            this.yt = keyPair;
            if (cert == null) {
                throw new NullPointerException("remoteCertificate is null");
            }
            this.yu = cert;
        }
    }

    public byte[] getEncodedLocalCertificate() {
        if (this.yt == null) {
            return null;
        }
        return this.yt.getCertificate().getEncoded();
    }

    public byte[] getEncodedLocalCertificateThumbprint() {
        if (this.yt == null) {
            return null;
        }
        return this.yt.getCertificate().getEncodedThumbprint();
    }

    public byte[] getEncodedLocalPrivateKey() {
        if (this.yt == null) {
            return null;
        }
        return this.yt.getPrivateKey().getPrivateKey().getEncoded();
    }

    public byte[] getEncodedRemoteCertificate() {
        if (this.yu == null) {
            return null;
        }
        return this.yu.getEncoded();
    }

    public byte[] getEncodedRemoteCertificateThumbprint() {
        if (this.yu == null) {
            return null;
        }
        return this.yu.getEncodedThumbprint();
    }

    public Certificate getLocalCertificate() {
        if (this.yt == null) {
            return null;
        }
        return this.yt.getCertificate().getCertificate();
    }

    public KeyPair getLocalCertificate2() {
        return this.yt;
    }

    public RSAPrivateKey getLocalPrivateKey() {
        if (this.yt == null) {
            return null;
        }
        return this.yt.getPrivateKey().getPrivateKey();
    }

    public MessageSecurityMode getMessageSecurityMode() {
        return this.ys.getMessageSecurityMode();
    }

    public Certificate getReceiverCertificate() {
        if (this.yu == null) {
            return null;
        }
        return this.yu.getCertificate();
    }

    public Certificate getRemoteCertificate() {
        if (this.yu == null) {
            return null;
        }
        return this.yu.getCertificate();
    }

    public Cert getRemoteCertificate2() {
        return this.yu;
    }

    public SecurityMode getSecurityMode() {
        return this.ys;
    }

    public SecurityPolicy getSecurityPolicy() {
        return this.ys.getSecurityPolicy();
    }

    static {
        sj = LoggerFactory.getLogger(SecurityConfiguration.class);
        NO_SECURITY = new SecurityConfiguration(SecurityMode.NONE, null, null);
    }
}

