/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.encoding.json;

import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.UaOptionSet;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.Enumeration;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedLong;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.builtintypes.XmlElement;
import com.prosysopc.ua.stack.encoding.AbstractDecoder;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.IDecoder;
import com.prosysopc.ua.stack.encoding.json.b;
import com.prosysopc.ua.stack.utils.BijectionMap;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.typedictionary.EnumerationSpecification;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.OptionSetSpecification;
import com.prosysopc.ua.typedictionary.SimpleTypeSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonDecoder
extends AbstractDecoder
implements IDecoder {
    private static final Logger logger = LoggerFactory.getLogger(JsonDecoder.class);
    private static final Map<Class<?>, a<?>> tK = new HashMap();
    private static final Map<UaNodeId, a<?>> uz = new HashMap();
    private static final BijectionMap<UaNodeId, Class<?>> tM = new BijectionMap();
    private static final a<DateTime> uA;
    private static final a<ExtensionObject> uB;
    private static final a<Structure> uC;
    private static final a<DataValue> uD;
    private static final a<Variant> uE;
    private static final a<DiagnosticInfo> uF;
    private static final a<Enumeration> uG;
    private static final a<BigDecimal> uH;
    private static final a<UaOptionSet> uI;
    private InputStreamReader uJ;
    private com.prosysopc.ua.stack.encoding.json.a uK;
    private Stack<com.prosysopc.ua.stack.encoding.json.a> uL = new Stack();
    private boolean uM = false;
    private char uN;
    private boolean uO = false;

    private static <T> void a(UaNodeId uaNodeId, Class<T> clazz, a<T> a2) throws Error {
        if (uaNodeId != null) {
            if (uz.put(uaNodeId, a2) != null) {
                throw new Error("DataType " + uaNodeId + " already has a serializer defined");
            }
            if (tM.containsLeft(uaNodeId)) {
                throw new Error("DataType " + uaNodeId + " already mapped to a class");
            }
            if (tM.containsRight(clazz)) {
                throw new Error("Class " + clazz + " already mapped to a DataTypeId");
            }
            tM.map(uaNodeId, clazz);
        }
    }

    private static <T> void b(UaNodeId uaNodeId, Class<T> clazz, a<T> a2) {
        if (!Object.class.equals(clazz) && !Modifier.isFinal(clazz.getModifiers())) {
            throw new Error("Class " + clazz + " is not final, and cannot be put to known final classes serializtion helper");
        }
        a<T> a3 = tK.put(clazz, a2);
        if (a3 != null) {
            throw new Error("Class " + clazz + " already has a serializer defined");
        }
        JsonDecoder.a(uaNodeId, clazz, a2);
    }

    private static <T> a<T> j(Class<?> clazz) throws DecodingException {
        a<?> a2 = tK.get(clazz);
        if (a2 != null) {
            return a2;
        }
        if (ExtensionObject.class.isAssignableFrom(clazz)) {
            return uB;
        }
        if (Structure.class.isAssignableFrom(clazz)) {
            return uC;
        }
        if (DataValue.class.isAssignableFrom(clazz)) {
            return uD;
        }
        if (Variant.class.isAssignableFrom(clazz)) {
            return uE;
        }
        if (DiagnosticInfo.class.isAssignableFrom(clazz)) {
            return uF;
        }
        if (Enumeration.class.isAssignableFrom(clazz)) {
            return uG;
        }
        if (DateTime.class.isAssignableFrom(clazz)) {
            return uA;
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return uH;
        }
        if (UaOptionSet.class.isAssignableFrom(clazz)) {
            return uI;
        }
        throw new DecodingException("Cannot decode class: " + clazz);
    }

    private static a<Object> a(UaNodeId uaNodeId, EncoderContext encoderContext, AtomicReference<Class<?>> atomicReference) throws DecodingException {
        if (uaNodeId == null) {
            throw new IllegalArgumentException("The given DataTypeId cannot be null");
        }
        if (UaIds.BaseDataType.equals(uaNodeId)) {
            atomicReference.set(Object.class);
            return JsonDecoder.j(Object.class);
        }
        if (UaIds.Structure.equals(uaNodeId)) {
            atomicReference.set(ExtensionObject.class);
            return JsonDecoder.j(ExtensionObject.class);
        }
        a<Object> a2 = uz.get(uaNodeId);
        if (a2 == null) {
            UaDataTypeSpecification uaDataTypeSpecification = encoderContext.getDataTypeSpecification(uaNodeId);
            if (uaDataTypeSpecification == null) {
                logger.warn("Cannot find UaDataTypeSpecification for DataTypeId: {}", (Object)uaNodeId);
            } else if (uaDataTypeSpecification instanceof SimpleTypeSpecification) {
                a2 = uz.get(((SimpleTypeSpecification)uaDataTypeSpecification).getBaseTypeId());
                atomicReference.set(uaDataTypeSpecification.getJavaClass());
            } else if (uaDataTypeSpecification instanceof StructureSpecification) {
                a2 = uC;
                atomicReference.set(uaDataTypeSpecification.getJavaClass());
            } else if (uaDataTypeSpecification instanceof OptionSetSpecification) {
                a2 = uI;
                atomicReference.set(uaDataTypeSpecification.getJavaClass());
            } else if (uaDataTypeSpecification instanceof EnumerationSpecification) {
                a2 = uG;
                atomicReference.set(uaDataTypeSpecification.getJavaClass());
            }
        } else {
            atomicReference.set(tM.getRight(uaNodeId));
        }
        if (a2 == null) {
            throw new DecodingException("Cannot find serializer for DataTypeId: " + uaNodeId);
        }
        if (atomicReference.get() == null) {
            throw new DecodingException("Cannot find the class mapping for DataTypeId: " + uaNodeId);
        }
        return a2;
    }

    @Override
    public <T> T get(String string, UaNodeId uaNodeId, int n2) throws DecodingException {
        Object object;
        Class clazz;
        if (uaNodeId == null) {
            throw new IllegalArgumentException("The given DataTypeId cannot be null");
        }
        if (UaIds.BaseDataType.equals(uaNodeId)) {
            clazz = Object.class;
        } else if (UaIds.Structure.equals(uaNodeId)) {
            clazz = ExtensionObject.class;
        } else {
            object = this.getEncoderContext().getDataTypeSpecification(uaNodeId);
            if (object == null) {
                throw new DecodingException("Cannot find UaDataTypeSpecification, cannot decode DataType: " + uaNodeId);
            }
            clazz = object.getJavaClass();
        }
        object = this.K(string);
        if (object == null) {
            return null;
        }
        if (n2 > 0 && !((com.prosysopc.ua.stack.encoding.json.a)object).esH()) {
            throw new DecodingException("JsonDecoder: field '" + string + "' is not an array as expected");
        }
        Object object2 = this.a((com.prosysopc.ua.stack.encoding.json.a)object, clazz, uaNodeId, n2);
        return (T)object2;
    }

    @Override
    public EncoderContext getEncoderContext() {
        return this.ctx;
    }

    @Override
    public ExtensionObject getExtensionObject(String string) throws DecodingException {
        return this.a(string, ExtensionObject.class);
    }

    @Override
    public ExtensionObject[] getExtensionObjectArray(String string) throws DecodingException {
        return this.a(string, ExtensionObject[].class);
    }

    public Set<String> getFieldNames() throws DecodingException {
        com.prosysopc.ua.stack.encoding.json.a a2 = this.esx();
        if (!a2.esI()) {
            return new HashSet<String>();
        }
        return a2.esG().getFieldNames();
    }

    @Override
    public int[] getInt32Array_(String string) throws DecodingException {
        Integer[] integerArray = this.getInt32Array(string);
        int[] nArray = new int[integerArray.length];
        for (int i2 = 0; i2 < integerArray.length; ++i2) {
            nArray[i2] = integerArray[i2];
        }
        return nArray;
    }

    public String getJson(String string) throws DecodingException {
        com.prosysopc.ua.stack.encoding.json.a a2 = this.K(string);
        if (a2 == null) {
            return null;
        }
        return a2.esL();
    }

    public int getJsonArraySize() throws DecodingException {
        com.prosysopc.ua.stack.encoding.json.a a2 = this.esx();
        if (!a2.esH()) {
            return -1;
        }
        return a2.esF().size();
    }

    @Override
    public Variant getVariant(String string) throws DecodingException {
        return this.a(string, Variant.class);
    }

    @Override
    public Variant[] getVariantArray(String string) throws DecodingException {
        return this.a(string, Variant[].class);
    }

    public void popElementStack() {
        if (this.uL.isEmpty()) {
            return;
        }
        this.uL.pop();
    }

    public void pushElementStack(int n2) throws DecodingException {
        ArrayList<com.prosysopc.ua.stack.encoding.json.a> arrayList = this.esx().esF();
        this.uL.push((com.prosysopc.ua.stack.encoding.json.a)arrayList.get(n2));
    }

    public void pushElementStack(String string) throws DecodingException {
        this.uL.push(this.K(string));
    }

    public void setEncoderContext(EncoderContext encoderContext) {
        this.ctx = encoderContext;
    }

    public void setReadable(InputStream inputStream) {
        this.uJ = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        this.uM = false;
        this.uL.clear();
    }

    private Object a(com.prosysopc.ua.stack.encoding.json.a a2, int n2) throws DecodingException {
        Class clazz;
        switch (n2) {
            case 1: {
                clazz = Boolean.class;
                break;
            }
            case 2: {
                clazz = Byte.class;
                break;
            }
            case 3: {
                clazz = UnsignedByte.class;
                break;
            }
            case 4: {
                clazz = Short.class;
                break;
            }
            case 5: {
                clazz = UnsignedShort.class;
                break;
            }
            case 6: {
                clazz = Integer.class;
                break;
            }
            case 7: {
                clazz = UnsignedInteger.class;
                break;
            }
            case 8: {
                clazz = Long.class;
                break;
            }
            case 9: {
                clazz = UnsignedLong.class;
                break;
            }
            case 10: {
                clazz = Float.class;
                break;
            }
            case 11: {
                clazz = Double.class;
                break;
            }
            case 12: {
                clazz = String.class;
                break;
            }
            case 13: {
                clazz = DateTime.class;
                break;
            }
            case 14: {
                clazz = UUID.class;
                break;
            }
            case 15: {
                clazz = ByteString.class;
                break;
            }
            case 16: {
                clazz = XmlElement.class;
                break;
            }
            case 17: {
                clazz = NodeId.class;
                break;
            }
            case 18: {
                clazz = ExpandedNodeId.class;
                break;
            }
            case 19: {
                clazz = StatusCode.class;
                break;
            }
            case 20: {
                clazz = QualifiedName.class;
                break;
            }
            case 21: {
                clazz = LocalizedText.class;
                break;
            }
            case 22: {
                clazz = ExtensionObject.class;
                break;
            }
            case 23: {
                clazz = DataValue.class;
                break;
            }
            case 24: {
                clazz = Variant.class;
                break;
            }
            case 25: {
                clazz = DiagnosticInfo.class;
                break;
            }
            default: {
                throw new DecodingException("Cannot decode builtin type id " + n2);
            }
        }
        this.uL.push(a2);
        Object obj = this.a("Body", MultiDimensionArrayUtils.arrayClassOf(clazz, 1));
        this.uL.pop();
        return obj;
    }

    private Boolean a(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        if (a2 == null || a2.isNull()) {
            return null;
        }
        return Boolean.parseBoolean(a2.getString());
    }

    private UnsignedByte b(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        if (a2 == null || a2.isNull()) {
            return null;
        }
        String string = a2.getString();
        if (string.isEmpty()) {
            return null;
        }
        return UnsignedByte.valueOf(string);
    }

    private ByteString c(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        if (a2 == null || a2.isNull()) {
            return null;
        }
        ByteString byteString = ByteString.valueOf(CryptoUtil.base64Decode(a2.getString()));
        this.assertByteStringLength(byteString.getLength());
        return byteString;
    }

    private DataValue d(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        if (a2 == null) {
            return null;
        }
        if (a2.esI()) {
            b b2 = a2.esG();
            Variant variant = this.z(b2.O("Value"));
            DateTime dateTime = this.e(b2.O("SourceTimestamp"));
            UnsignedShort unsignedShort = this.w(b2.O("SourcePicoSeconds"));
            DateTime dateTime2 = this.e(b2.O("ServerTimestamp"));
            UnsignedShort unsignedShort2 = this.w(b2.O("ServerPicoSeconds"));
            StatusCode statusCode = this.u(b2.O("Status"));
            return new DataValue(variant, statusCode, dateTime, unsignedShort, dateTime2, unsignedShort2);
        }
        return null;
    }

    private DateTime e(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        if (a2 == null || a2.isNull()) {
            return null;
        }
        try {
            return DateTime.parseDateTime(a2.getString());
        }
        catch (Exception exception) {
            throw new DecodingException(exception);
        }
    }

    private BigDecimal f(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        if (a2 == null || a2.isNull()) {
            return null;
        }
        b b2 = a2.esG();
        Integer n2 = this.n(b2.O("Scale"));
        Long l2 = Long.valueOf(b2.O("Value").getString());
        return BigDecimal.valueOf(l2, n2);
    }

    private DiagnosticInfo g(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        if (a2 == null || a2.isNull()) {
            return null;
        }
        b b2 = a2.esG();
        String string = this.v(b2.O("Additional Info"));
        DiagnosticInfo diagnosticInfo = this.g(b2.O("Inner DiagnosticInfo"));
        StatusCode statusCode = this.u(b2.O("Inner StatusCode"));
        if (statusCode == null) {
            statusCode = StatusCode.GOOD;
        }
        Integer n2 = this.n(b2.O("Locale"));
        Integer n3 = this.n(b2.O("LocalizedText"));
        Integer n4 = this.n(b2.O("NamespaceUri"));
        Integer n5 = this.n(b2.O("SymbolicId"));
        return new DiagnosticInfo(string, diagnosticInfo, statusCode, n2, n3, n4, n5);
    }

    private Double h(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        if (a2 == null || a2.isNull()) {
            return null;
        }
        return this.B(a2);
    }

    private <T extends Enumeration> T a(com.prosysopc.ua.stack.encoding.json.a a2, Class<T> clazz, UaNodeId uaNodeId) throws DecodingException {
        if (a2 != null && a2.esJ()) {
            try {
                Method method = clazz.getMethod("valueOf", Integer.TYPE);
                if (a2.esK()) {
                    EnumerationSpecification enumerationSpecification = this.getEncoderContext().getEnumerationSpecification(uaNodeId);
                    if (enumerationSpecification != null) {
                        return (T)enumerationSpecification.getByValue(this.C(a2));
                    }
                    return (T)((Enumeration)method.invoke(null, this.C(a2)));
                }
                String[] stringArray = a2.getString().split("_");
                int n2 = Integer.parseInt(stringArray[stringArray.length - 1]);
                EnumerationSpecification enumerationSpecification = this.getEncoderContext().getEnumerationSpecification(uaNodeId);
                if (enumerationSpecification != null) {
                    return (T)enumerationSpecification.getByValue(n2);
                }
                return (T)((Enumeration)method.invoke(null, n2));
            }
            catch (Exception exception) {
                throw new DecodingException(exception, "cannot decode" + clazz);
            }
        }
        return null;
    }

    private ExpandedNodeId i(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        if (a2 == null || !a2.esI()) {
            return null;
        }
        b b2 = a2.esG();
        Object object = null;
        Integer n2 = this.n(b2.O("IdType"));
        if (n2 == null || n2 == 0) {
            object = this.x(b2.O("Id"));
        } else {
            switch (n2) {
                case 1: {
                    object = this.v(b2.O("Id"));
                    break;
                }
                case 2: {
                    object = this.l(b2.O("Id"));
                    break;
                }
                case 3: {
                    object = this.c(b2.O("Id"));
                }
            }
        }
        UnsignedInteger unsignedInteger = this.x(b2.O("ServerUri"));
        com.prosysopc.ua.stack.encoding.json.a a3 = b2.O("Namespace");
        if (a3 == null) {
            return new ExpandedNodeId(unsignedInteger, 0, object);
        }
        if (a3.esK()) {
            return new ExpandedNodeId(unsignedInteger, this.C(a3), object);
        }
        return new ExpandedNodeId(unsignedInteger, a3.getString(), object);
    }

    private ExtensionObject j(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        if (a2 != null && a2.esI()) {
            ExtensionObject extensionObject;
            Object object;
            b b2 = a2.esG();
            ExpandedNodeId expandedNodeId = this.i(b2.O("TypeId"));
            UaNodeId uaNodeId = UaNodeId.fromLocal(expandedNodeId, this.ctx.getNamespaceTable());
            expandedNodeId = uaNodeId.asExpandedNodeId();
            com.prosysopc.ua.stack.encoding.json.a a3 = b2.O("Encoding");
            Integer n2 = a3 != null && a3.esK() ? this.C(a3) : 0;
            if (a3 == null || a3.isNull() || n2 == 0) {
                object = b2.O("Body");
                extensionObject = new ExtensionObject(expandedNodeId, object == null ? null : ((com.prosysopc.ua.stack.encoding.json.a)object).esL());
            } else if (n2 == 1) {
                extensionObject = new ExtensionObject(expandedNodeId, this.c(b2.O("Body")));
            } else if (n2 == 2) {
                extensionObject = new ExtensionObject(expandedNodeId, this.A(b2.O("Body")));
            } else {
                throw new DecodingException("Unknown encoding byte: " + n2);
            }
            try {
                object = (Structure)extensionObject.decode(this.getEncoderContext());
                return new ExtensionObject((Structure)object);
            }
            catch (DecodingException decodingException) {
                return extensionObject;
            }
        }
        return null;
    }

    private Float k(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        return a2 == null || a2.isNull() ? null : Float.valueOf(Float.parseFloat(a2.getString()));
    }

    private UUID l(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        if (a2 == null || a2.isNull()) {
            return null;
        }
        return UUID.fromString(a2.getString());
    }

    private Short m(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        return a2 == null || a2.isNull() ? null : Short.decode(a2.getString());
    }

    private Integer n(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        if (a2 == null || a2.isNull()) {
            return null;
        }
        return this.C(a2);
    }

    private Long o(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        return a2 == null || a2.isNull() ? null : Long.valueOf(Long.parseLong(a2.getString()));
    }

    private LocalizedText p(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        if (a2 == null) {
            return null;
        }
        if (a2.esI()) {
            b b2 = a2.esG();
            com.prosysopc.ua.stack.encoding.json.a a3 = b2.O("Text");
            String string = a3 == null ? null : a3.getString();
            com.prosysopc.ua.stack.encoding.json.a a4 = b2.O("Locale");
            if (a4 == null) {
                return LocalizedText.builder().setText(string, LocalizedText.NO_LOCALE).build();
            }
            return LocalizedText.builder().setText(string, a4.getString()).build();
        }
        if (a2.esJ()) {
            return LocalizedText.builder().setText(a2.getString(), LocalizedText.NO_LOCALE).build();
        }
        return null;
    }

    private NodeId q(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        Integer n2;
        if (a2 == null || !a2.esI()) {
            return null;
        }
        b b2 = a2.esG();
        Integer n3 = 0;
        com.prosysopc.ua.stack.encoding.json.a a3 = b2.O("Namespace");
        if (a3 != null) {
            n3 = a3.esK() ? Integer.valueOf(this.C(a3)) : Integer.valueOf(this.ctx.getNamespaceTable().getIndex(a3.getString()));
        }
        if ((n2 = this.n(b2.O("IdType"))) == null || n2 == 0) {
            return new NodeId((int)n3, this.x(b2.O("Id")));
        }
        com.prosysopc.ua.stack.encoding.json.a a4 = b2.O("Id");
        switch (n2) {
            case 1: {
                return new NodeId((int)n3, this.v(a4));
            }
            case 2: {
                return new NodeId((int)n3, this.l(a4));
            }
            case 3: {
                return new NodeId((int)n3, this.c(a4));
            }
        }
        return null;
    }

    private UaOptionSet a(com.prosysopc.ua.stack.encoding.json.a a2, UaNodeId uaNodeId) throws DecodingException {
        if (a2 == null || a2.isNull()) {
            return null;
        }
        OptionSetSpecification optionSetSpecification = this.getEncoderContext().getOptionSetSpecification(uaNodeId);
        if (optionSetSpecification == null) {
            throw new DecodingException("Cannot resolve OptionSetSpecification for: " + uaNodeId);
        }
        Object obj = this.a(a2, optionSetSpecification.getBaseTypeJavaClass(), optionSetSpecification.getBaseTypeId(), 0);
        try {
            return (UaOptionSet)new Variant(obj).asOptionSet(optionSetSpecification);
        }
        catch (Exception exception) {
            throw new DecodingException(exception, "Could not resolve the value as UaOptionSet");
        }
    }

    private QualifiedName r(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        if (a2 == null) {
            return null;
        }
        if (a2.esI()) {
            b b2 = a2.esG();
            String string = b2.O("Name").getString();
            com.prosysopc.ua.stack.encoding.json.a a3 = b2.O("Uri");
            if (a3 == null) {
                return new QualifiedName(0, string);
            }
            if (a3.esK()) {
                return new QualifiedName(this.C(a3), string);
            }
            if (a3.esJ()) {
                return new QualifiedName(this.ctx.getNamespaceTable().getIndex(a3.getString()), string);
            }
        }
        return null;
    }

    private com.prosysopc.ua.stack.encoding.json.a esx() throws DecodingException {
        if (!this.uL.isEmpty()) {
            return this.uL.peek();
        }
        this.esB();
        return this.uK;
    }

    private com.prosysopc.ua.stack.encoding.json.a K(String string) throws DecodingException {
        com.prosysopc.ua.stack.encoding.json.a a2 = this.esx();
        if (string == null) {
            return a2;
        }
        if (!a2.esI()) {
            throw new DecodingException("JsonDecoder: Root Json is not an object");
        }
        return a2.esG().O(string);
    }

    private Byte s(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        return a2 == null || a2.isNull() ? null : Byte.valueOf(Byte.parseByte(a2.getString()));
    }

    private Object t(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        b b2 = a2.esG();
        int n2 = this.C(b2.O("Type"));
        com.prosysopc.ua.stack.encoding.json.a a3 = b2.O("Body");
        try {
            switch (n2) {
                case 1: {
                    return this.a(a3);
                }
                case 2: {
                    return this.s(a3);
                }
                case 3: {
                    return this.b(a3);
                }
                case 4: {
                    return this.m(a3);
                }
                case 5: {
                    return this.w(a3);
                }
                case 6: {
                    return this.n(a3);
                }
                case 7: {
                    return this.x(a3);
                }
                case 8: {
                    return this.o(a3);
                }
                case 9: {
                    return this.y(a3);
                }
                case 10: {
                    return this.k(a3);
                }
                case 11: {
                    return this.h(a3);
                }
                case 12: {
                    return this.v(a3);
                }
                case 13: {
                    return this.e(a3);
                }
                case 14: {
                    return this.l(a3);
                }
                case 15: {
                    return this.c(a3);
                }
                case 16: {
                    return this.A(a3);
                }
                case 17: {
                    return this.q(a3);
                }
                case 18: {
                    return this.i(a3);
                }
                case 19: {
                    return this.u(a3);
                }
                case 20: {
                    return this.r(a3);
                }
                case 21: {
                    return this.p(a3);
                }
                case 22: {
                    return this.j(a3);
                }
                case 23: {
                    return this.d(a3);
                }
                case 24: {
                    return this.z(a3);
                }
                case 25: {
                    return this.g(a3);
                }
            }
        }
        catch (Exception exception) {
            throw new DecodingException(exception);
        }
        throw new DecodingException("Cannot decode builtin type id " + n2);
    }

    private StatusCode u(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        Integer n2 = 0;
        if (a2 != null) {
            com.prosysopc.ua.stack.encoding.json.a a3;
            if (a2.esK()) {
                n2 = this.C(a2);
            } else if (a2.esI() && (a3 = a2.esG().O("Code")) != null) {
                n2 = this.C(a3);
            }
        }
        return StatusCode.getFromBits(n2);
    }

    private String v(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        if (a2 == null || a2.isNull()) {
            return null;
        }
        String string = a2.getString();
        this.assertStringLength(string.length());
        return string;
    }

    private UnsignedShort w(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        if (a2 == null || a2.isNull()) {
            return null;
        }
        return UnsignedShort.parseUnsignedShort(a2.getString());
    }

    private UnsignedInteger x(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        if (a2 == null || a2.isNull()) {
            return null;
        }
        return UnsignedInteger.parseUnsignedInteger(a2.getString());
    }

    private UnsignedLong y(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        return a2 == null || a2.isNull() ? null : UnsignedLong.parseUnsignedLong(a2.getString());
    }

    private Variant z(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        Object object = null;
        if (a2 == null || a2.isNull()) {
            return null;
        }
        if (a2.esI()) {
            b b2 = a2.esG();
            com.prosysopc.ua.stack.encoding.json.a a3 = b2.O("Type");
            com.prosysopc.ua.stack.encoding.json.a a4 = b2.O("Body");
            if (a4 == null || a3 == null) {
                object = a2.esL();
            } else if (a4.esH()) {
                int n2 = this.C(a3);
                object = this.a(a2, n2);
                com.prosysopc.ua.stack.encoding.json.a a5 = b2.O("Dimensions");
                if (a5 != null && a5.esH()) {
                    this.uL.push(a2);
                    int[] nArray = this.getInt32Array_("Dimensions");
                    this.uL.pop();
                    object = MultiDimensionArrayUtils.demuxArray(object, nArray);
                }
            } else {
                object = this.t(a2);
            }
        } else if (a2.esH()) {
            object = a2.esL();
        } else if (a2.isBoolean()) {
            object = this.a(a2);
        } else if (a2.esK()) {
            object = this.h(a2);
        } else if (a2.esJ()) {
            object = this.v(a2);
        }
        return new Variant(object);
    }

    private XmlElement A(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        return a2 == null || a2.isNull() ? null : new XmlElement(a2.getString());
    }

    private void esy() throws DecodingException {
        if (this.uO) {
            throw new DecodingException("JsonDecoder: goBack called twice in succession");
        }
        this.uO = true;
    }

    private <T> T a(com.prosysopc.ua.stack.encoding.json.a a2, Class<T> clazz, UaNodeId uaNodeId, int n2) throws DecodingException {
        int n3;
        Object object;
        Class clazz2;
        ArrayList<com.prosysopc.ua.stack.encoding.json.a> arrayList;
        if (n2 < 0) {
            throw new DecodingException("The given dimensions cannot be negative");
        }
        if (a2 == null) {
            return null;
        }
        a<Object> a3 = null;
        UaNodeId uaNodeId2 = uaNodeId;
        if (uaNodeId2 == null && clazz != null) {
            uaNodeId2 = tM.getLeft(MultiDimensionArrayUtils.getComponentType(clazz));
        }
        if (uaNodeId2 != null) {
            arrayList = new AtomicReference();
            a3 = JsonDecoder.a(uaNodeId2, this.getEncoderContext(), arrayList);
            clazz2 = (Class)((AtomicReference)((Object)arrayList)).get();
        } else {
            clazz2 = MultiDimensionArrayUtils.getComponentType(clazz);
            a3 = JsonDecoder.j(clazz2);
        }
        if (n2 == 0) {
            arrayList = a3;
            return arrayList.get(this, a2, clazz, uaNodeId);
        }
        arrayList = a2.esF();
        if (n2 == 1) {
            Object[] objectArray = (Object[])Array.newInstance(clazz2, arrayList.size());
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                objectArray[i2] = a3.get(this, arrayList.get(i2), clazz2, uaNodeId);
            }
            Object[] objectArray2 = objectArray;
            return (T)objectArray2;
        }
        ArrayList arrayList2 = new ArrayList();
        ArrayDeque<ArrayList<com.prosysopc.ua.stack.encoding.json.a>> arrayDeque = new ArrayDeque<ArrayList<com.prosysopc.ua.stack.encoding.json.a>>();
        int[] nArray = new int[n2];
        int n4 = 0;
        arrayDeque.add(arrayList);
        while (!arrayDeque.isEmpty()) {
            List list = (List)arrayDeque.poll();
            if (n4 < n2) {
                nArray[n4++] = list.size();
            }
            if (((com.prosysopc.ua.stack.encoding.json.a)(object = (com.prosysopc.ua.stack.encoding.json.a)list.get(0))).esH()) {
                for (n3 = 0; n3 < list.size(); ++n3) {
                    arrayDeque.add(((com.prosysopc.ua.stack.encoding.json.a)list.get(n3)).esF());
                }
                continue;
            }
            for (n3 = 0; n3 < list.size(); ++n3) {
                arrayList2.add(list.get(n3));
            }
        }
        int n5 = arrayList2.size();
        object = (Object[])Array.newInstance(clazz2, n5);
        for (n3 = 0; n3 < n5; ++n3) {
            object[n3] = a3.get(this, (com.prosysopc.ua.stack.encoding.json.a)arrayList2.get(n3), clazz2, uaNodeId);
        }
        Object object2 = MultiDimensionArrayUtils.demuxArray(object, nArray, clazz2);
        return (T)object2;
    }

    private Structure a(com.prosysopc.ua.stack.encoding.json.a a2, StructureSpecification structureSpecification) throws DecodingException {
        UnsignedLong unsignedLong = null;
        Structure.Builder builder = structureSpecification.toInstanceBuilder();
        if (a2 == null || a2.isNull()) {
            return null;
        }
        if (StructureSpecification.StructureType.OPTIONAL == structureSpecification.getStructureType()) {
            unsignedLong = this.y(a2.esG().O("EncodingMask"));
        }
        if (StructureSpecification.StructureType.UNION == structureSpecification.getStructureType() || StructureSpecification.StructureType.UNION_SUBTYPES == structureSpecification.getStructureType()) {
            long l2 = 0L;
            com.prosysopc.ua.stack.encoding.json.a a3 = a2.esG().O("SwitchField");
            if (a3 != null) {
                l2 = this.x(a3).longValue();
            }
            if (l2 < 0L) {
                throw new DecodingException("Union SwitchField must be >= 0");
            }
            if (l2 == 0L) {
                return builder.build();
            }
            long l3 = 0L;
            for (FieldSpecification fieldSpecification : structureSpecification.getFields()) {
                if (l2 != ++l3) continue;
                com.prosysopc.ua.stack.encoding.json.a a4 = a2.esG().O(fieldSpecification.getName());
                builder.set(fieldSpecification, this.a(a4, fieldSpecification));
                return builder.build();
            }
            throw new DecodingException("Union SwitchField overflow: " + ++l3);
        }
        int n2 = -1;
        for (FieldSpecification fieldSpecification : structureSpecification.getFields()) {
            com.prosysopc.ua.stack.encoding.json.a a5 = a2.esG().O(fieldSpecification.getName());
            if (fieldSpecification.isOptional()) {
                if ((unsignedLong.longValue() & (long)(1 << ++n2)) == 0L) continue;
                builder.set(fieldSpecification, this.a(a5, fieldSpecification));
                continue;
            }
            builder.set(fieldSpecification, this.a(a5, fieldSpecification));
        }
        return builder.build();
    }

    private Object a(com.prosysopc.ua.stack.encoding.json.a a2, FieldSpecification fieldSpecification) throws DecodingException {
        Class<?> clazz = fieldSpecification.getJavaClass();
        int n2 = MultiDimensionArrayUtils.getClassDimensions(clazz);
        if (fieldSpecification.isAllowSubTypes()) {
            Class<?> clazz2 = MultiDimensionArrayUtils.getComponentType(clazz);
            if (ExtensionObject.class.isAssignableFrom(clazz2)) {
                return this.a(a2, MultiDimensionArrayUtils.arrayClassOf(ExtensionObject.class, n2), UaIds.Structure, n2);
            }
            return this.a(a2, MultiDimensionArrayUtils.arrayClassOf(Variant.class, n2), UaIds.BaseDataType, n2);
        }
        return this.a(a2, clazz, fieldSpecification.getDataTypeId(), n2);
    }

    private char esz() throws DecodingException {
        char c2;
        while (Character.isWhitespace(c2 = this.esE())) {
        }
        return c2;
    }

    private String a(char c2) throws DecodingException {
        char c3 = this.esE();
        StringBuilder stringBuilder = new StringBuilder();
        while (c3 != c2) {
            block1 : switch (c3) {
                case '\n': 
                case '\r': {
                    throw new DecodingException("JsonDecoder: Unterminated string in Json");
                }
                case '\\': {
                    c3 = this.esE();
                    switch (c3) {
                        case 'b': {
                            stringBuilder.append('\b');
                            break block1;
                        }
                        case 't': {
                            stringBuilder.append('\t');
                            break block1;
                        }
                        case 'n': {
                            stringBuilder.append('\n');
                            break block1;
                        }
                        case 'f': {
                            stringBuilder.append('\f');
                            break block1;
                        }
                        case 'r': {
                            stringBuilder.append('\r');
                            break block1;
                        }
                        case 'u': {
                            try {
                                stringBuilder.append((char)Integer.parseInt(this.r(4), 16));
                                break block1;
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new DecodingException("JsonDecoder: Illegal escape in Json", numberFormatException);
                            }
                        }
                        case '\"': 
                        case '\'': 
                        case '/': 
                        case '\\': {
                            stringBuilder.append(c3);
                            break block1;
                        }
                    }
                    throw new DecodingException("JsonDecoder: Illegal escape in Json");
                }
                default: {
                    stringBuilder.append(c3);
                }
            }
            c3 = this.esE();
        }
        return stringBuilder.toString();
    }

    private com.prosysopc.ua.stack.encoding.json.a esA() throws DecodingException {
        char c2 = this.esz();
        switch (c2) {
            case '\"': 
            case '\'': {
                return new com.prosysopc.ua.stack.encoding.json.a(this.a(c2));
            }
            case '{': {
                this.esy();
                return new com.prosysopc.ua.stack.encoding.json.a(this.esD());
            }
            case '[': {
                this.esy();
                return new com.prosysopc.ua.stack.encoding.json.a(this.esC());
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.esy();
        while (true) {
            if ((c2 = this.esE()) == '\u0000') {
                throw new DecodingException("JsonDecoder: Unexpected end of Json");
            }
            if (Character.isWhitespace(c2) || ",]}".indexOf(c2) > -1) break;
            stringBuilder.append(c2);
        }
        this.esy();
        String string = stringBuilder.toString().trim();
        if (string.isEmpty()) {
            throw new DecodingException("JsonDecoder: Missing value in Json");
        }
        if ("null".equalsIgnoreCase(string)) {
            return new com.prosysopc.ua.stack.encoding.json.a();
        }
        return new com.prosysopc.ua.stack.encoding.json.a(string, true);
    }

    private void esB() throws DecodingException {
        if (this.uM) {
            return;
        }
        this.uM = true;
        char c2 = this.esz();
        if (c2 == '{') {
            this.esy();
            this.uK = new com.prosysopc.ua.stack.encoding.json.a(this.esD());
            return;
        }
        if (c2 == '[') {
            this.esy();
            this.uK = new com.prosysopc.ua.stack.encoding.json.a(this.esC());
            return;
        }
        throw new DecodingException("JsonDecoder: Json text should start with '{' or '[': '" + c2 + "' found");
    }

    private ArrayList<com.prosysopc.ua.stack.encoding.json.a> esC() throws DecodingException {
        if (this.esz() != '[') {
            throw new DecodingException("JsonDecoder: Json array must start with '['");
        }
        ArrayList<com.prosysopc.ua.stack.encoding.json.a> arrayList = new ArrayList<com.prosysopc.ua.stack.encoding.json.a>();
        boolean bl = false;
        block5: while (!bl) {
            char c2 = this.esz();
            switch (c2) {
                case ']': {
                    bl = true;
                    continue block5;
                }
                case ',': {
                    if (!arrayList.isEmpty()) continue block5;
                    throw new DecodingException("JsonDecoder: Missing first value in Json array");
                }
                case '\u0000': {
                    throw new DecodingException("JsonDecoder: Unexpected end of Json");
                }
            }
            this.esy();
            arrayList.add(this.esA());
            this.assertArrayLength(arrayList.size());
        }
        return arrayList;
    }

    private Double B(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        try {
            return Double.valueOf(a2.getString());
        }
        catch (Exception exception) {
            throw new DecodingException(exception);
        }
    }

    private int C(com.prosysopc.ua.stack.encoding.json.a a2) throws DecodingException {
        try {
            BigInteger bigInteger = new BigInteger(a2.getString());
            return bigInteger.intValue();
        }
        catch (Exception exception) {
            throw new DecodingException(exception);
        }
    }

    private b esD() throws DecodingException {
        if (this.esz() != '{') {
            throw new DecodingException("JsonDecoder: Json object must start with '{");
        }
        HashMap<String, com.prosysopc.ua.stack.encoding.json.a> hashMap = new HashMap<String, com.prosysopc.ua.stack.encoding.json.a>();
        block8: while (true) {
            char c2 = this.esz();
            switch (c2) {
                case '}': {
                    return new b(hashMap);
                }
                case '\u0000': {
                    throw new DecodingException("JsonDecoder: Unexpected end of Json");
                }
            }
            this.esy();
            String string = this.esA().getString();
            if (this.esz() != ':') {
                throw new DecodingException("JsonDecoder: Expected ':' after field name");
            }
            if (string != null) {
                if (hashMap.containsKey(string)) {
                    throw new DecodingException("JsonDecoder: Duplicate field name: " + string);
                }
                com.prosysopc.ua.stack.encoding.json.a a2 = this.esA();
                hashMap.put(string, a2);
            }
            switch (this.esz()) {
                case ',': {
                    continue block8;
                }
                case '}': {
                    return new b(hashMap);
                }
            }
            break;
        }
        throw new DecodingException("JsonDecoder: Expected a ',' or '}'");
    }

    private char esE() throws DecodingException {
        int n2;
        if (this.uO) {
            this.uO = false;
            return this.uN;
        }
        try {
            n2 = this.uJ.read();
        }
        catch (IOException iOException) {
            throw new DecodingException(iOException);
        }
        if (n2 <= 0) {
            return '\u0000';
        }
        this.uN = (char)n2;
        return this.uN;
    }

    private String r(int n2) throws DecodingException {
        char c2;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < n2 && (c2 = this.esE()) != '\u0000'; ++i2) {
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    @Deprecated
    <T> T a(String string, Class<T> clazz) throws DecodingException {
        int n2 = MultiDimensionArrayUtils.getClassDimensions(clazz);
        com.prosysopc.ua.stack.encoding.json.a a2 = this.K(string);
        if (a2 == null) {
            return null;
        }
        if (n2 > 0 && !a2.esH()) {
            throw new DecodingException("JsonDecoder: field '" + string + "' is not an array as expected");
        }
        return this.a(a2, clazz, null, n2);
    }

    static {
        JsonDecoder.b(UaIds.Boolean, Boolean.class, (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.a(a2));
        JsonDecoder.b(UaIds.SByte, Byte.class, (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.s(a2));
        JsonDecoder.b(UaIds.Byte, UnsignedByte.class, (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.b(a2));
        JsonDecoder.b(UaIds.Int16, Short.class, (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.m(a2));
        JsonDecoder.b(UaIds.UInt16, UnsignedShort.class, (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.w(a2));
        JsonDecoder.b(UaIds.Int32, Integer.class, (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.n(a2));
        JsonDecoder.b(UaIds.UInt32, UnsignedInteger.class, (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.x(a2));
        JsonDecoder.b(UaIds.Int64, Long.class, (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.o(a2));
        JsonDecoder.b(UaIds.UInt64, UnsignedLong.class, (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.y(a2));
        JsonDecoder.b(UaIds.Float, Float.class, (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.k(a2));
        JsonDecoder.b(UaIds.Double, Double.class, (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.h(a2));
        JsonDecoder.b(UaIds.String, String.class, (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.v(a2));
        JsonDecoder.b(UaIds.Guid, UUID.class, (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.l(a2));
        JsonDecoder.b(UaIds.ByteString, ByteString.class, (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.c(a2));
        JsonDecoder.b(UaIds.XmlElement, XmlElement.class, (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.A(a2));
        JsonDecoder.b(UaIds.NodeId, NodeId.class, (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.q(a2));
        JsonDecoder.b(UaIds.ExpandedNodeId, ExpandedNodeId.class, (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.i(a2));
        JsonDecoder.b(UaIds.StatusCode, StatusCode.class, (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.u(a2));
        JsonDecoder.b(UaIds.QualifiedName, QualifiedName.class, (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.r(a2));
        JsonDecoder.b(UaIds.LocalizedText, LocalizedText.class, (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.p(a2));
        uA = (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.e(a2);
        JsonDecoder.a(UaIds.DateTime, DateTime.class, uA);
        uB = (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.j(a2);
        JsonDecoder.a(UaIds.Structure, ExtensionObject.class, uB);
        uC = (jsonDecoder, a2, clazz, uaNodeId) -> {
            if (uaNodeId == null) {
                throw new DecodingException("DataTypeId is null, class: " + clazz);
            }
            StructureSpecification structureSpecification = jsonDecoder.getEncoderContext().getStructureSpecification(uaNodeId);
            if (structureSpecification == null) {
                throw new DecodingException("Cannot find StructureSpecification for DataType: " + uaNodeId);
            }
            return jsonDecoder.a(a2, structureSpecification);
        };
        uD = (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.d(a2);
        JsonDecoder.a(UaIds.DataValue, DataValue.class, uD);
        uE = (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.z(a2);
        uF = (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.g(a2);
        JsonDecoder.a(UaIds.DiagnosticInfo, DiagnosticInfo.class, uF);
        uG = (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.a(a2, clazz, uaNodeId);
        uH = (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.f(a2);
        JsonDecoder.a(UaIds.Decimal, BigDecimal.class, uH);
        uI = (jsonDecoder, a2, clazz, uaNodeId) -> jsonDecoder.a(a2, uaNodeId);
        JsonDecoder.b(null, Object.class, (jsonDecoder, a2, clazz, uaNodeId) -> uE.get(jsonDecoder, a2, Variant.class, uaNodeId).getValue());
    }

    private static interface a<T> {
        public T get(JsonDecoder var1, com.prosysopc.ua.stack.encoding.json.a var2, Class<? extends T> var3, UaNodeId var4) throws DecodingException;
    }
}

