/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.encoding.binary;

import com.prosysopc.ua.stack.core.IdType;

public enum NodeIdEncoding {
    TwoByte(0, IdType.Numeric),
    FourByte(1, IdType.Numeric),
    Numeric(2, IdType.Numeric),
    String(3, IdType.String),
    Guid(4, IdType.Guid),
    ByteString(5, IdType.String);

    private final byte uw;
    private final IdType ux;

    public static NodeIdEncoding getNodeIdEncoding(int n2) {
        if (n2 == TwoByte.getBits()) {
            return TwoByte;
        }
        if (n2 == FourByte.getBits()) {
            return FourByte;
        }
        if (n2 == Numeric.getBits()) {
            return Numeric;
        }
        if (n2 == String.getBits()) {
            return String;
        }
        if (n2 == Guid.getBits()) {
            return Guid;
        }
        if (n2 == ByteString.getBits()) {
            return ByteString;
        }
        return null;
    }

    private NodeIdEncoding(byte by, IdType idType) {
        this.uw = by;
        this.ux = idType;
    }

    public byte getBits() {
        return this.uw;
    }

    public IdType toIdentifierType() {
        return this.ux;
    }
}

