/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.encoding.binary;

import java.io.ByteArrayOutputStream;
import java.nio.ByteOrder;

public class ByteUtils {
    public static int bytesToInt(byte[] byArray, ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            return byArray[0] << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        }
        return byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16 | byArray[3] << 24;
    }

    public static long bytesToLong(byte[] byArray, ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            return (long)byArray[0] << 56 | ((long)byArray[1] & 0xFFL) << 48 | ((long)byArray[2] & 0xFFL) << 40 | ((long)byArray[3] & 0xFFL) << 32 | ((long)byArray[4] & 0xFFL) << 24 | ((long)byArray[5] & 0xFFL) << 16 | ((long)byArray[6] & 0xFFL) << 8 | (long)(byArray[7] & 0xFF);
        }
        return (long)(byArray[0] & 0xFF) | ((long)byArray[1] & 0xFFL) << 8 | ((long)byArray[2] & 0xFFL) << 16 | ((long)byArray[3] & 0xFFL) << 24 | ((long)byArray[4] & 0xFFL) << 32 | ((long)byArray[5] & 0xFFL) << 40 | ((long)byArray[6] & 0xFFL) << 48 | (long)byArray[7] << 56;
    }

    public static short bytesToShort(byte[] byArray, ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            return (short)(byArray[0] << 8 | byArray[1] & 0xFF);
        }
        return (short)(byArray[0] & 0xFF | byArray[1] << 8);
    }

    public static byte[] concat(byte[] byArray, byte[] byArray2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(byArray, 0, byArray.length);
        byteArrayOutputStream.write(byArray2, 0, byArray2.length);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] intToBytes(int n2, ByteOrder byteOrder) {
        byte[] byArray = new byte[4];
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            byArray[0] = (byte)(n2 >> 24 & 0xFF);
            byArray[1] = (byte)(n2 >> 16 & 0xFF);
            byArray[2] = (byte)(n2 >> 8 & 0xFF);
            byArray[3] = (byte)(n2 & 0xFF);
        } else {
            byArray[0] = (byte)(n2 & 0xFF);
            byArray[1] = (byte)(n2 >> 8 & 0xFF);
            byArray[2] = (byte)(n2 >> 16 & 0xFF);
            byArray[3] = (byte)(n2 >> 24 & 0xFF);
        }
        return byArray;
    }

    public static byte[] longToBytes(long l2, ByteOrder byteOrder) {
        byte[] byArray = new byte[8];
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            byArray[0] = (byte)(l2 >> 56 & 0xFFL);
            byArray[1] = (byte)(l2 >> 48 & 0xFFL);
            byArray[2] = (byte)(l2 >> 40 & 0xFFL);
            byArray[3] = (byte)(l2 >> 32 & 0xFFL);
            byArray[4] = (byte)(l2 >> 24 & 0xFFL);
            byArray[5] = (byte)(l2 >> 16 & 0xFFL);
            byArray[6] = (byte)(l2 >> 8 & 0xFFL);
            byArray[7] = (byte)(l2 & 0xFFL);
        } else {
            byArray[0] = (byte)(l2 & 0xFFL);
            byArray[1] = (byte)(l2 >> 8 & 0xFFL);
            byArray[2] = (byte)(l2 >> 16 & 0xFFL);
            byArray[3] = (byte)(l2 >> 24 & 0xFFL);
            byArray[4] = (byte)(l2 >> 32 & 0xFFL);
            byArray[5] = (byte)(l2 >> 40 & 0xFFL);
            byArray[6] = (byte)(l2 >> 48 & 0xFFL);
            byArray[7] = (byte)(l2 >> 56 & 0xFFL);
        }
        return byArray;
    }

    public static byte[] reverse(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[byArray.length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray2[i2] = byArray[byArray.length - 1 - i2];
        }
        return byArray2;
    }

    public static byte[] shortToBytes(short s2, ByteOrder byteOrder) {
        byte[] byArray = new byte[2];
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            byArray[0] = (byte)(s2 >> 8 & 0xFF);
            byArray[1] = (byte)(s2 & 0xFF);
        } else {
            byArray[0] = (byte)(s2 & 0xFF);
            byArray[1] = (byte)(s2 >> 8 & 0xFF);
        }
        return byArray;
    }

    public static byte[] writeInt(int n2, byte[] byArray, int n3, ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            byArray[n3++] = (byte)(n2 >> 24 & 0xFF);
            byArray[n3++] = (byte)(n2 >> 16 & 0xFF);
            byArray[n3++] = (byte)(n2 >> 8 & 0xFF);
            byArray[n3] = (byte)(n2 & 0xFF);
        } else {
            byArray[n3++] = (byte)(n2 & 0xFF);
            byArray[n3++] = (byte)(n2 >> 8 & 0xFF);
            byArray[n3++] = (byte)(n2 >> 16 & 0xFF);
            byArray[n3] = (byte)(n2 >> 24 & 0xFF);
        }
        return byArray;
    }

    public static byte[] writeLong(long l2, byte[] byArray, int n2, ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            byArray[n2++] = (byte)(l2 >> 56 & 0xFFL);
            byArray[n2++] = (byte)(l2 >> 48 & 0xFFL);
            byArray[n2++] = (byte)(l2 >> 40 & 0xFFL);
            byArray[n2++] = (byte)(l2 >> 32 & 0xFFL);
            byArray[n2++] = (byte)(l2 >> 24 & 0xFFL);
            byArray[n2++] = (byte)(l2 >> 16 & 0xFFL);
            byArray[n2++] = (byte)(l2 >> 8 & 0xFFL);
            byArray[n2] = (byte)(l2 & 0xFFL);
        } else {
            byArray[n2++] = (byte)(l2 & 0xFFL);
            byArray[n2++] = (byte)(l2 >> 8 & 0xFFL);
            byArray[n2++] = (byte)(l2 >> 16 & 0xFFL);
            byArray[n2++] = (byte)(l2 >> 24 & 0xFFL);
            byArray[n2++] = (byte)(l2 >> 32 & 0xFFL);
            byArray[n2++] = (byte)(l2 >> 40 & 0xFFL);
            byArray[n2++] = (byte)(l2 >> 48 & 0xFFL);
            byArray[n2] = (byte)(l2 >> 56 & 0xFFL);
        }
        return byArray;
    }

    public static byte[] writeShort(short s2, byte[] byArray, int n2, ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            byArray[n2++] = (byte)(s2 >> 8 & 0xFF);
            byArray[n2] = (byte)(s2 & 0xFF);
        } else {
            byArray[n2++] = (byte)(s2 & 0xFF);
            byArray[n2] = (byte)(s2 >> 8 & 0xFF);
        }
        return byArray;
    }

    private ByteUtils() {
    }
}

